
/*
Eagles Bulletin Board System
Copyright (C) 1994, Ray Rocker, rrrocker@rock.b11.ingr.com
                                rock@seabass.st.usm.edu
                                72673.2105@compuserve.com

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "oldbbs.h"
#include "server.h"
#include <fcntl.h>

extern char *optarg;
extern int optind;

usage(prog)
char *prog;
{
  fprintf(stderr, "Usage: %s [-d bbs-dir] old-PASSWDS-file\n", prog);
}

main(argc, argv)
int argc;
char *argv[];
{
  char *bbshome = NULL;
  int c, fd, rc;
  struct ouserec oldacct;
  ACCOUNT acct;

  while ((c = getopt(argc, argv, "d:?")) != -1)
    {
      switch (c)
	{
	case 'd':
	  bbshome = optarg;
	  break;
	case '?':
	  usage(argv[0]);
	  return 2;
	}
    }

  if (optind > argc-1) {
    usage(argv[0]);
    return 2;
  }

  if (home_bbs(bbshome) == -1) {
    fprintf(stderr, "%s: Cannot chdir to %s\n", argv[0], bbshome);
    return 1;
  }

  if ((fd = open(argv[optind], O_RDONLY)) == -1) {
    fprintf(stderr, "%s: Cannot open %s\n", argv[0], argv[optind]);
    return 1;
  }

  while (read(fd, &oldacct, sizeof oldacct) == sizeof oldacct) {
    memset(&acct, 0, sizeof acct);
    strncpy(acct.userid, oldacct.userid, NAMELEN);
    strncpy(acct.passwd, oldacct.passwd, PASSLEN);
    strncpy(acct.username, oldacct.username, UNAMELEN);
    strncpy(acct.terminal, oldacct.termtype, TERMLEN);
    strncpy(acct.email, oldacct.email, MAILLEN);
#if REALINFO
    strncpy(acct.realname, oldacct.realname, RNAMELEN);
    strncpy(acct.address, oldacct.address, ADDRLEN);
#endif
    rc = local_bbs_add_account(&acct, 1);
    switch (rc) {
    case S_OK:
      fprintf(stderr, "%s: added\n", acct.userid);
      break;
    case S_INVALID:
      fprintf(stderr, "%s: invalid userid or password\n", acct.userid);
      break;
    case S_EXISTS:
      fprintf(stderr, "%s: userid already exists\n", acct.userid);
      break;
    case S_SYSERR:
      fprintf(stderr, "%s: error creating account\n", acct.userid);
      fprintf(stderr, "Wrong -d argument or $BBSHOME?\n");
      close(fd);
      return 1;
    }
  }
  close(fd);
  return 0;
}    








