/*
 * This function reads the citadel.config file.  It should be called at
 * the beginning of EVERY Citadel program.
 */

#include <stdio.h>
#include "citadel.h"

extern struct config config;

void get_config() {
	FILE *cfp;

	chdir(BBSDIR);
	cfp=fopen("citadel.config","r");
	if (cfp==NULL) {
		fprintf(stderr,"ERROR: cannot open %s/citadel.config\n",
			BBSDIR);
		exit(1);
		}
	fread((char *)&config,sizeof(struct config),1,cfp);
	fclose(cfp);
	}
