/*
version: $Id: goodbye.c,v 5.123 1995/01/18 01:24:58 hitman Exp $
purpose: Says good bye to the users and thanks them for playing in the game.  This function also closes up some of the users files and saves the user.
updates: All updates are handled by RCS
*/

#include <stdio.h>

#ifndef __MSDOS__
#	include "hsh_glob.h"
#	include "hshgen_s.h"
#else				/* not_MSDOS */
#	include "..\src\bbs_fn-s\hsh_glob.h"
#	include "..\src\bbs_fn-s\hshgen_s.h"
#endif				/* MSDOS */
#	include "version.h"

/* Define functions and procedures. */
int             goodbye(_character * Character);

int 
goodbye(_character * Character)
{
	/* displays closing and opening screens */
	extern int      display_screen(void);

#ifdef DEBUG
	fprintf(stderr, "** %s: **\n", __FILE__);
#endif

/* display the closing screen */
	display_screen();

	/* Say good bye to the users */
#ifdef ENGLISH
	printf("Thanks for using the No-Name BBS System...%s!\n", PROGRAM);
#elif SPANISH			/* ENGLISH */
	printf("Asta la vista...%s!\n", PROGRAM);
#endif				/* SPANISH */

	/* Save the users information */
#ifdef DEBUG
	fprintf(stderr, "** %s: Save the data for the user. **\n", __FILE__);
#endif

	/* Exit the game */
	exit(0);

	/* Well something could go wrong */
	return (RET_NORMAL);
}				/* goodbye */
