#include <assert.h>
#include <signal.h>
#include <unistd.h>
#include <pwd.h>
#include "common.h"
#include "bbs-util.h"

#define GUEST_TIME	10

int n_procs, n_kill;
uid_t ps_uid[MAX_PROCS];
pid_t ps_pid[MAX_PROCS], kill_pid[MAX_PROCS];

void main() {
  int i, guest_online;
  uid_t guest_id;
  FILE *user_file;
  struct user_rec ur;
  char login[9];
  init_daemon();
  guest_id = uid_from_login("guest");
  for (;;) {
    n_kill = 0;
    proc_list(&n_procs, ps_uid, ps_pid);
    for (guest_online = 0, i = 0; i < n_procs; i++)
      if (ps_uid[i] == guest_id) guest_online = 1;
    user_file = fopen(USER_FILE, "r+b"); assert(user_file != NULL);
    while (!user_rec_read(&ur, user_file)) {
      if (ur.uid == guest_id && !guest_online && ur.tleft != GUEST_TIME) {
        ur.tleft = GUEST_TIME;
        fseek(user_file, -sizeof(struct user_rec), SEEK_CUR);
        user_rec_write(&ur, user_file);
      } else {
        for (i = 0; i < n_procs && ur.uid != ps_uid[i]; i++);
        if (i < n_procs) {
          ur.tleft = max(0, ur.tleft - 1);
          time(&ur.last);
          fseek(user_file, -sizeof(struct user_rec), SEEK_CUR);
          user_rec_write(&ur, user_file);
          if (!ur.tleft) {
            for (; i < n_procs; i++)
              if (ps_uid[i] == ur.uid) kill_pid[n_kill++] = ps_pid[i];
          }
        }
      }
    }
    fclose(user_file);
    if (n_kill) {
		/* ask the processes to leave quietly... */
      for (i = 0; i < n_kill; i++) kill(kill_pid[i], SIGTERM);
		/* give them a few seconds to leave... */
      sleep(5);
		/* are you *still* here... */
      for (i = 0; i < n_kill; i++) kill(kill_pid[i], SIGKILL);
      sleep(55);
    } else sleep(60);
  }
}
