#include <assert.h>
#include <unistd.h>
#include "common.h"
#include "bbs-util.h"

int expire_user() {
  time_t t;
  uid_t uid;
  char login[9], cmd[256];
  struct user_rec ur;
  FILE *user_file = fopen(USER_FILE, "r+b"); assert(user_file != NULL);
  time(&t);
  while (!user_rec_read(&ur, user_file)) {
    if (ur.expire && t >= ur.expire) {
      fclose(user_file);
      login_from_uid(ur.uid, login); 
      if (EXPIRE(ur.flags) == EXPIRE_DELETE)
        sprintf(cmd, ROOT_BINPATH"/user_del %s", login);
      else
        sprintf(cmd, ROOT_BINPATH"/user_unsubscribe %s", login);
      system(cmd);
      return 1;
    } else if (ur.tleft != ur.tlimit) {
      ur.tleft = ur.tlimit;
      fseek(user_file, -sizeof(struct user_rec), SEEK_CUR);
      user_rec_write(&ur, user_file);
    }
  }
  fclose(user_file);
  return 1;
}

void main() {
  while (!expire_user());
}
