#include <assert.h>
#include <signal.h>
#include <unistd.h>
#include "common.h"
#include "bbs-util.h"

int n_procs;
uid_t ps_uid[MAX_PROCS];
pid_t ps_pid[MAX_PROCS];

void main(int argc, char **argv) {
  int i;
  uid_t uid;
  if (argc != 2) {
    printf("usage: user_kick <login>\n");
    exit(0);
  }
  uid = uid_from_login(argv[1]);
  if (uid == (uid_t) -1) {
    printf("user %s does not exist.\n", argv[1]);
    exit(1);
  } else if (!uid) {
    printf("can't kick root!\n");
    exit(1);
  }
  proc_list(&n_procs, ps_uid, ps_pid);
  for (i = 0; i < n_procs; i++) if (ps_uid[i] == uid)
    kill(ps_pid[i], SIGTERM);
  sleep(5);
  proc_list(&n_procs, ps_uid, ps_pid);
  for (i = 0; i < n_procs; i++) if (ps_uid[i] == uid)
    kill(ps_pid[i], SIGKILL);
}
