#ifndef BBS_UTIL_H
#define BBS_UTIL_H

#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include "common.h"

#define ROOT_BINPATH		"/home/root/bin"
#define USER_FILE		"/etc/bbs-users"
#define EXPIRE_DELETE		0x00
#define EXPIRE_UNSUBSCRIBE	0x01

#define EXPIRE(a)	((a) & 0x01)

struct user_rec {
  uid_t uid;
  time_t expire, last;
  shword tlimit, tleft;
  time_t sub_expire;
  shword sub_tlimit;
  byte flags;
};	/* sizeof(user_rec) = 24 */

int user_rec_read(struct user_rec *ur, FILE *f);
int user_rec_write(struct user_rec *ur, FILE *f);

#endif
