
/*
 * XKOBO, a video-oriented game
 * Copyright (C) 1995  Akira Higuchi
 *     a-higuti@math.hokudai.ac.jp
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

extern "C"{
#include <unistd.h>
}
#include "manage.h"
#include "xkobo.h"
#include "key.h"

int _key::space;
int _key::left;
int _key::up;
int _key::down;
int _key::right;
int _key::shot;
int _key::direction;

void _key::init()
{
    direction = 1;
    _key::clear();
}

void _key::clear()
{
    left      = 0;
    right     = 0;
    up        = 0;
    down      = 0;
    shot      = 0;
}

void _key::press(KeySym sym)
{
    if      (sym == KEY_LEFT ) left  = 1;
    else if (sym == XK_Left  ) left  = 1;
    else if (sym == KEY_RIGHT) right = 1;
    else if (sym == XK_Right ) right = 1;
    else if (sym == KEY_UP   ) up    = 1;
    else if (sym == XK_Up    ) up    = 1;
    else if (sym == KEY_DOWN ) down  = 1;
    else if (sym == XK_Down  ) down  = 1;
    else if (sym == KEY_SHOT ) shot  = 1;
    else if (sym == KEY_EXIT ) manage.exit_key();
    else if (sym == KEY_START) manage.start_key();
    else if (sym == KEY_PLUS ) manage.plus_key();
    else if (sym == KEY_MINUS) manage.minus_key();
    _key::change();
}

void _key::release(KeySym sym)
{
    if      (sym == KEY_LEFT ) left  = 0;
    else if (sym == XK_Left  ) left  = 0;
    else if (sym == KEY_RIGHT) right = 0;
    else if (sym == XK_Right ) right = 0;
    else if (sym == KEY_UP   ) up    = 0;
    else if (sym == XK_Up    ) up    = 0;
    else if (sym == KEY_DOWN ) down  = 0;
    else if (sym == XK_Down  ) down  = 0;
    else if (sym == KEY_SHOT ) shot  = 0;
    _key::change();
}

void _key::mouse_press(int n)
{
    if      (n == 1) shot = 1;
    else if (n == 3) manage.start_key();
    _key::change();
}

void _key::mouse_release(int n)
{
    if      (n == 1) shot = 0;
    _key::change();
}

void _key::mouse_position(int h, int v)
{
    if (h > 0){
        if (v > 0){
            if (h > (v<<1)) direction = 3;
            else if (v > (h<<1)) direction = 5;
            else direction = 4;
        }
        else if (v < 0){
            if (h > ((-v)<<1)) direction = 3;
            else if ((-v) > (h<<1)) direction = 1;
            else direction = 2;
        }
        else direction = 3;
    }
    else if (h < 0){
        if (v > 0){
            if ((-h) > (v<<1)) direction = 7;
            else if (v > ((-h)<<1)) direction = 5;
            else direction = 6;
        }
        else if (v < 0){
            if ((-h) > ((-v)<<1)) direction = 7;
            else if ((-v) > ((-h)<<1)) direction = 1;
            else direction = 8;
        }
        else direction = 7;
    }
    else if (v > 0){
        direction = 5;
    }
    else {
        direction = 1;
    }
}

void _key::change()
{
    int l = left;
    int r = right;
    int u = up;
    int d = down;
    if (l & r){l = 0; r = 0;}
    if (u & d){u = 0; d = 0;}
    if (l){
        if (u) direction = 8;
        else if (d) direction = 6;
        else direction = 7;
    }
    else if (r){
        if (u) direction = 2;
        else if (d) direction = 4;
        else direction = 3;
    }
    else {
        if (u) direction = 1;
        else if (d) direction = 5;
    }
    if (l || r || u || d){
        mouse_x = 0;
        mouse_y = 0;
    }
}
