#!/usr/local/bin/wish -f
# ENTER YOUR CORRECT PATH FOR wish HERE
# if you don't know it try: which wish
#
#
# Setup for XBlast V0.1 or higher
# only works with XBlast V1.03 or higher
# 
# (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
# May 18th 1994
# started March 1994
#
# Interactive Setup using the tk/tcl script language
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public Licences as published
# by the Free Software Foundation; either version 2; or (at your option)
# any later version
#
# This program is distributed in the hope that it will entertaining,
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Publis License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.
# 675 Mass Ave, Cambridge, MA 02139, USA.
#
#
#
# EDIT YOUR XBLAST PATH
# xblast directory

set GAMEDIR ./

# Here starts the script

# constants

# Button Abstaende
set OLW 10
set OLH 5

# Label Width
set LW 20

# Set Window Title

wm title . "XBlast Setup"

# Headline
frame .header -borderwidth 6 -relief raised
label .header.label -text "Setup for XBlast V0.1" -width 60
label .header.label2 -text "(C) 1994 Oliver Vogel" -width 60
pack \
  .header.label \
  .header.label2 \
  -side top -fill both -expand yes

#
frame .fropt


# players
set XBNumPlay 2
set XBNumDisp 1


frame .fropt.play -borderwidth 4 -relief raised
label .fropt.play.label -text "Players"


# player number

proc BuildPEntry {w i} {
  frame ${w}
  label ${w}.l -text [expr $i + 1] -width 4
  entry ${w}.e -relief raised -borderwidth 2 -width 20
  pack ${w}.l $w.e -side left
}

proc SelectPEntry {w n} {
  set i 0
  while {${i} < 4} {
    set ww $w.ent${i}
    if {${i} < ${n}} {
      ${ww}.e configure -state normal
      ${ww}.e configure -borderwidth 2
      ${ww}.e configure -foreground black
      
    } else {
      ${ww}.e configure -state disabled
      ${ww}.e configure -borderwidth 0
      ${ww}.e configure -foreground white
    }
    incr i
  }
 SetDisplayNumber $n
}


proc SetPlayerNumber {n} {
  global XBNumPlay	

  if { $XBNumPlay < ${n} } {
    set XBNumPlay ${n}
    SelectPEntry .fropt.play $XBNumPlay
  }
  if { ${n} == 1 } {
     if { $XBNumPlay > 2 } {
       set XBNumPlay 2
       SelectPEntry .fropt.play $XBNumPlay
       }
    }
}

proc SetDisplayNumber {n} {
  global XBNumDisp 
 
  if { $n > 2 } {
      if {$XBNumDisp == 1} {
        set XBNumDisp 2
        SelectDEntry .fropt.disp $XBNumDisp
      }
    }

  if {$n < $XBNumDisp} {
      set XBNumDisp $n
      SelectDEntry .fropt.disp $XBNumDisp
    }
}


frame .fropt.play.num

radiobutton .fropt.play.num.r2 \
  -value 2 \
  -variable XBNumPlay \
  -text "2" \
  -command "SelectPEntry .fropt.play 2"
radiobutton .fropt.play.num.r3 \
  -value 3 \
  -variable XBNumPlay \
  -text "3" \
  -command "SelectPEntry .fropt.play 3"
radiobutton .fropt.play.num.r4 \
  -value 4 \
  -variable XBNumPlay \
  -text "4" \
  -command "SelectPEntry .fropt.play 4"
pack \
  .fropt.play.num.r2 \
  .fropt.play.num.r3 \
  .fropt.play.num.r4 \
  -side left -expand yes -padx $OLW

set i 0
while {${i} < 4} {
  BuildPEntry .fropt.play.ent${i} ${i}
  incr i
}

SelectPEntry .fropt.play 2


#pack players

pack .fropt.play.label \
  .fropt.play.num  \
  .fropt.play.ent0  \
  .fropt.play.ent1  \
  .fropt.play.ent2  \
  .fropt.play.ent3  \
  -side top \
  -expand yes \
  -fill both


# displays
frame .fropt.disp -borderwidth 4 -relief raised
label .fropt.disp.label -text "Displays"

# display number
frame .fropt.disp.num
radiobutton .fropt.disp.num.r1 \
  -value 1 \
  -variable XBNumDisp \
  -text "1" \
  -command "SelectDEntry .fropt.disp 1 "
radiobutton .fropt.disp.num.r2 \
  -value 2 \
  -variable XBNumDisp \
  -text "2" \
  -command "SelectDEntry .fropt.disp 2 "
radiobutton .fropt.disp.num.r3 \
  -value 3 \
  -variable XBNumDisp \
  -text "3" \
  -command "SelectDEntry .fropt.disp 3 "
radiobutton .fropt.disp.num.r4 \
  -value 4 \
  -variable XBNumDisp \
  -text "4" \
  -command "SelectDEntry .fropt.disp 4 "
pack .fropt.disp.num.r1 \
  .fropt.disp.num.r2 \
  .fropt.disp.num.r3 \
  .fropt.disp.num.r4 \
  -side left -expand yes -padx $OLW

proc BuildDEntry {w i} {
  frame ${w}
  label ${w}.l -text [expr $i + 1] -width 4
  entry ${w}.e -relief raised -borderwidth 2 -width 20
  pack ${w}.l $w.e -side left
}

proc SelectDEntry {w n } {
  set i 0
  while {${i} < 4} {
    set ww $w.ent${i}
    if {${i} < ${n}} {
      ${ww}.e configure -state normal
      ${ww}.e configure -borderwidth 2
      ${ww}.e configure -foreground black
      
    } else {
      ${ww}.e configure -state disabled
      ${ww}.e configure -borderwidth 0
      ${ww}.e configure -foreground white
    }
    incr i
  }
 SetPlayerNumber $n 
}


proc ReadEntry {w n} {
  set zeile [${w}.ent${n}.e get ]
  return $zeile 
}


set i 0
while {${i} < 4} {
  BuildDEntry .fropt.disp.ent${i} ${i}
  incr i
}

SelectDEntry .fropt.disp $XBNumDisp 

# pack display
pack \
  .fropt.disp.label \
  .fropt.disp.num \
  .fropt.disp.ent0  \
  .fropt.disp.ent1  \
  .fropt.disp.ent2  \
  .fropt.disp.ent3  \
  -side top -expand yes 


# options
frame .opt -borderwidth 4 -relief raised
label .opt.header -text "Options"

# number of victories
frame .opt.vic
label .opt.vic.l -text "\# of Victories" -width $LW -anchor e
set XBVic 3
radiobutton .opt.vic.r1 \
  -value 1              \
  -variable XBVic       \
  -text "1"
radiobutton .opt.vic.r2 \
  -value 2              \
  -variable XBVic       \
  -text "2"
radiobutton .opt.vic.r3 \
  -value 3              \
  -variable XBVic       \
  -text "3"
radiobutton .opt.vic.r4 \
  -value 4             \
  -variable XBVic       \
  -text "4"
radiobutton .opt.vic.r5 \
  -value 5              \
  -variable XBVic       \
  -text "5"
pack \
  .opt.vic.l \
  .opt.vic.r1 \
  .opt.vic.r2 \
  .opt.vic.r3 \
  .opt.vic.r4 \
  .opt.vic.r5 \
  -side left -padx $OLW

#Number of Lives
frame .opt.liv
label .opt.liv.l -text "\# of Lives" -width $LW -anchor e
set XBLiv 3
radiobutton .opt.liv.r1 \
  -value 1             \
  -variable XBLiv      \
  -text "1"       
radiobutton .opt.liv.r2 \
  -value 2             \
  -variable XBLiv      \
  -text "2"       
radiobutton .opt.liv.r3 \
  -value 3             \
  -variable XBLiv      \
  -text "3"       
pack \
  .opt.liv.l \
  .opt.liv.r1 \
  .opt.liv.r2 \
  .opt.liv.r3 \
  -side left -padx $OLW


#Sound 
frame .opt.sound
label .opt.sound.l -text "Sound via Bell" -width $LW -anchor e
set XBSound 1
radiobutton .opt.sound.yes \
  -value 1 \
  -variable XBSound \
  -text "Yes"
radiobutton .opt.sound.no \
  -value 0 \
  -variable XBSound \
  -text "No"
pack \
  .opt.sound.l \
  .opt.sound.yes \
  .opt.sound.no \
  -side left -padx $OLW

#Random 
frame .opt.rand
label .opt.rand.l -text "Randomize Levels" -width $LW -anchor e
set XBRand 0
radiobutton .opt.rand.yes \
  -value 1 \
  -variable XBRand \
  -text "Yes"
radiobutton .opt.rand.no \
  -value 0 \
  -variable XBRand \
  -text "No"
pack \
  .opt.rand.l \
  .opt.rand.yes \
  .opt.rand.no \
  -side left -padx $OLW

# pack options
pack \
  .opt.header \
  .opt.vic    \
  .opt.liv    \
  .opt.sound    \
  .opt.rand    \
   -side top -fill both -expand yes -pady $OLH


# pack fropt
pack \
  .fropt.disp \
  .fropt.play \
  -side left -expand yes -fill both -padx 10

# actions 

frame .act -borderwidth 4 -relief raised
button .act.start \
  -command "start_game" \
  -text "Start Game" \
  -relief raised
button .act.cancel \
  -command "destroy ." \
  -text "Cancel" \
  -relief raised 



#pack actions
pack \
  .act.start \
  .act.cancel \
  -side left -padx $OLW -pady $OLH 

# pack all together
pack \
  .header \
  .fropt \
  .opt \
  .act    \
  -side top -fill both -expand yes -pady 5



# start game proc

proc start_game {} {
  global XBNumPlay 
  global XBNumDisp
  global XBVic
  global XBLiv
  global XBSound
  global XBRand

  global GAMEDIR 
  global env


  set Display $env(DISPLAY)

#  puts "Display = $Display"
 

  set i 0

  while { $i < 4 } {
    if { ${i} < ${XBNumDisp} } {
        set Test [ReadEntry .fropt.disp ${i} ]
        set Disp${i} $Test
	if { $Test == {} } {
	   set Disp${i} $Display
	}
      }
    
    if { ${i} >= ${XBNumDisp} } {
        set Disp${i} {}
       }

    incr i
    }
 

  set i 0

  while { $i < 4 } {
    if { ${i} < ${XBNumPlay} } {
        set Test [ReadEntry .fropt.play ${i} ]
        set Name${i} $Test
	if { $Test == {} } {
	   set Name${i} Player_${i}
	}
      }
    
    if { ${i} >= ${XBNumPlay} } {
        set Name${i} {}
       }

    incr i
    }
 

  set MINUS_O {}
  if { ${XBNumDisp} != 1 } {
    set MINUS_O -o
    }


  set MINUS_Q {}
  if { ${XBSound} != 1} {
    set MINUS_Q -q
    }  

  set MINUS_R {}
  if { ${XBRand} == 1} {
    set MINUS_R -r 
    }


#  puts "$Name0,$Name1,$Name2,$Name3."
#  puts "${GAMEDIR}xblast -p $XBNumPlay:$XBNumDisp \
#			-d $Disp0 $MINUS_O $Disp1 $Disp2 $Disp3 \
#			$MINUS_Q $MINUS_R \
#			-L $XBLiv -v $XBVic \
#                        -n $Name0 $Name1 $Name2 $Name3"
#

  exec ${GAMEDIR}xblast -p $XBNumPlay:$XBNumDisp \
			-d $Disp0 $MINUS_O $Disp1 $Disp2 $Disp3 \
			$MINUS_Q $MINUS_R\
			-L $XBLiv -v $XBVic \
                        -n $Name0 $Name1 $Name2 $Name3 

  destroy .
}






