/*
 * Programm XBLAST V1.11 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * May 24th 1994
 * started August 1993
 *
 * File: maze.c
 * level management
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#include <stdio.h>
#include <stdlib.h>
#include "include.h"
#include "mytypes.h"
#include "const.h"
#include "data.h"

/* Lynx doesnt no cfree () */
#if defined(Lynx)
#define cfree free
#endif


#define BOMB_TIME 64
#define BOMB_ERROR_PROB 16
#define BOMB_DELAY 5

short redraw_maze[MAZE_W][MAZE_H + 2];
static int expl_maze[MAZE_W][MAZE_H];
static int bomb_maze[MAZE_W][MAZE_H];
static short maze[MAZE_W][MAZE_H];
static short extra[MAZE_W][MAZE_H];
static short dist_extra[MAZE_W][MAZE_H];
static short dist_x[MAZE_W*MAZE_H], dist_y[MAZE_W*MAZE_H];
static int block[MAX_BLOCK];
static Explosion *expl_list;
static Explosion *expl_end;
static int  num_expl = 0 ;
static int shadow_mode;
static int expl_dirty_flag;
static int initial_bomb_dir;

extern void (*special_init_function)();
extern void (*special_revive_function)();
extern void (*special_game_function)();
extern void (*special_extra_function)();
extern void (*special_key_function)();

void new_explosion();



  /* public function load_maze */

void load_maze( stat, level, num_player, num_disp, max_lives, min_range, 
	       min_bombs )
     BMPlayer *stat;
     int level, num_player, num_disp, max_lives;
     int *min_range, *min_bombs;
{
  int x,y,i,player;
  int rnd;

  expl_list = NULL;
  expl_end = NULL;
  num_expl = 0;
  expl_dirty_flag = FALSE;

  special_init_function = maze_data[level]->init_func;
  special_revive_function = maze_data[level]->revive_func;
  special_game_function = maze_data[level]->game_func;
  special_extra_function = maze_data[level]->extra_func;
  special_key_function = maze_data[level]->key_func;

  shadow_mode = maze_data[level]->shadow;
  initial_bomb_dir = maze_data[level]->bomb_dir;

  *min_range = maze_data[level]->range;
  *min_bombs = maze_data[level]->bombs;

  for (player = 0; player < num_player; player ++)
    {
      stat[player].y = maze_data[level]->position[player].y;
      stat[player].x = maze_data[level]->position[player].x;
      stat[player].anime = 0;
      stat[player].invincible = NEW_INVINCIBLE;
      stat[player].illness = Healthy;
      stat[player].illtime = 0;
      stat[player].dying = 0;
      stat[player].stunned = 0;
      stat[player].lives = max_lives;
      stat[player].range = maze_data[level]->range;
      stat[player].bombs = maze_data[level]->bombs;
      stat[player].remote_control = 0;
      stat[player].kick = 0;
      stat[player].d_ist = GoStop;
      stat[player].d_soll= GoStop;
      stat[player].d_look= GoDown;
    }

  for (x = 0; x < MAZE_W; x++)
    for (y = 0; y < MAZE_H; y++)
      {
        bomb_maze[x][y] = 0;
        expl_maze[x][y] = 0;
        maze[x][y] = maze_data[level]->maze[x][y];

	

	if (maze[x][y] == BTExtra)
          {
            rnd = rand() % 64;
            if (rnd < maze_data[level]->prob.bomb)
              extra[x][y] = BTBomb;
            else if (rnd < maze_data[level]->prob.range)
              extra[x][y] = BTRange;
            else if (rnd < maze_data[level]->prob.ill)
              extra[x][y] = BTSick;
            else if (rnd < maze_data[level]->prob.invinc)
              extra[x][y] = BTSpecial;
            else if (rnd < maze_data[level]->prob.evil)
              extra[x][y] = BTEvil;
            else 
              extra[x][y] = BTFree;
          }
        else
	  {
	    extra[x][y] = BTFree;
	    
	    if (maze[x][y] == BTFree)
	      switch( maze[x-1][y] )
		{
		case BTBlock:
		  if ( shadow_mode & ShadowBlock)
		    maze[x][y] = BTShadow;
		  break;

		case BTExtra:
		  if ( shadow_mode & ShadowExtra)
		    maze[x][y] = BTShadow;
		  break;
		}
	  }

        redraw_maze[x][y] = FALSE;
      }

  for (i = 0; i < MAX_BLOCK; i++)
    block[i] = maze_data[level]->blocks[i];

  for (player = 0; player <num_disp; player++)
    for (i=0; i< MAX_BLOCK; i++)
      init_block(player, block[i], i);

  for (player = 0; player <num_disp; player++)
    init_explosion_blocks(player);
}



/* public function set_victories */

void set_victories(num_victories)
     int num_victories;
{
 int x,y;

 for (x = 2*num_victories + 5; x < MAZE_W; x ++)
   for (y = 4; y < 12; y++)
     maze_data[LEVEL_MAX]->maze[x][y] = 6;
}



/* public function get_level_name */

char *get_level_name(level)
     int level;
{
  return(maze_data[level]->name);
}



/* public unload_blocks */

void unload_blocks(num_disp)
     int num_disp;
{
  int player, i;

  for(player = 0; player < num_disp; player ++)
    {
      for (i = 0; i< MAX_BLOCK; i++)
	free_block(player, i);
      free_explosion_blocks(player);
    }
}



/* public function draw_maze */

void draw_maze( player )
     int player;
{
  int x,y;

  for (x=0; x<MAZE_W; x++)
    for (y=0; y<MAZE_H; y++)
      draw_block(player, x, y, (int) maze[x][y]);
}



/* public function redraw_rectangles */

void set_redraw_rectangles()
{
  int x,y;

  for (y=0; y<MAZE_H+2; y++)
    for (x=0; x<MAZE_W; x++)
      if (redraw_maze[x][y])
          add_rectangle(x, y);
}



/* public function mark_maze */

void mark_maze( x1,y1, x2, y2)
     int x1, y1, x2, y2;
{
  int x,y;

  for (x=MAX(x1,0); x<=MIN(x2,MAZE_W-1); x++)
    for (y=MAX(y1,0); y<=MIN(y2,MAZE_H+1); y++)
      redraw_maze[x][y] = TRUE;
}



/* public function clear_redraw_map */

void clear_redraw_map()
{
  int x,y;

  for(x=0; x<MAZE_W; x++)
    for(y=0; y<(MAZE_H+2); y++)
      {
        redraw_maze[x][y] = FALSE;
        expl_maze[x][y] = 0;
      }
}



/* public function update_maze */

void update_maze( player )
     int player;
{
  int x,y;

  for (x=0; x<MAZE_W; x++)
    for (y=0; y<MAZE_H; y++)
      if (redraw_maze[x][y] == TRUE)
        {
          if (expl_maze[x][y] & 0x10)
            draw_explosion(player, x, y, expl_maze[x][y] & 0xf);
	  else
	    draw_block(player, x, y, (int) maze[x][y]);
        }
}


void update_expl( player )
     int player;
{
  int x,y;

  for (x=0; x<MAZE_W; x++)
    for (y=0; y<MAZE_H; y++)
      if (redraw_maze[x][y] == TRUE)
        {
          if (expl_maze[x][y] & 0x10)
            draw_explosion(player, x, y, expl_maze[x][y] & 0xf);
        }
}



/* public function check_maze */

int check_maze(x,y)
     int x,y;
{
  return( (maze[x][y]==BTBlock) 
	 || (maze[x][y]==BTBlockRise) 
	 || (maze[x][y]==BTExtra) 
	 || (maze[x][y]==BTExtraOpen ) );
}



/* public function check_maze */

int check_maze_free(x,y)
     int x,y;
{
  return( (maze[x][y]==BTFree) || (maze[x][y]==BTShadow) );
}



/* public function set_maze_block */

void set_maze_block(x,y,block)
     int x,y, block;
{
  expl_dirty_flag = TRUE;

  maze[x][y] = (short)block;
  if ( (block == BTBlock) 
      && (shadow_mode & ShadowBlock) 
      && (x != (MAZE_W-1) )
      && (maze[x+1][y] == BTFree) )
    {
      maze[x+1][y] = BTShadow;
      mark_maze(x,y,x+1,y);
    }
  else if ( (block == BTExtra) 
	   && (shadow_mode & ShadowExtra) 
	   && (x != (MAZE_W-1) )
	   && (maze[x+1][y] == BTFree) )
    {
      maze[x+1][y] = BTShadow;
      mark_maze(x,y,x+1,y);
    }
 else
   {
     mark_maze(x,y,x,y);
   }
}


/* public function get_extra */

int get_extra(invincible,x,y)
     int invincible,x,y;
{
  int extra_block;

  extra_block = ( maze[x][y]<=BTExtraOpen ? 0 : maze[x][y]);
  if ( (invincible>0)  && (extra_block == BTSick))
    extra_block = 0;

  if (extra_block != 0)
    {
      redraw_maze[x][y] = TRUE;
      if ( ( (shadow_mode & ShadowBlock) && (maze[x-1][y]==BTBlock) )
	  || ( (shadow_mode & ShadowExtra) 
	      && ( (maze[x-1][y]==BTExtra) || (maze[x-1][y]==BTExtraOpen) ) ) )
	maze[x][y] = BTShadow;
      else
	maze[x][y] = BTFree;
    }
  return( extra_block );
}


static void my_swap( a , b)
     short *a, *b;
{
  int s;

  s = *a;
  *a = *b;
  *b = s;
}


/* global function */

void distribute_extras(bombs, range, other)
     int bombs, range, other;
{
  int x,y;
  Explosion *ptr;
  int ra;
  int i, where, swap;
  int free_blocks = 0;
  int non_free = 0;

  if (bombs + range + other != 0)
    {
  
      /* Create Extra Distribution Map */
      /* First check for free Blocks */
      for (x=0; x < MAZE_W; x++)
	for (y=0; y < MAZE_H; y++)
	  if ( (maze[x][y] == BTShadow) 
	      || (maze[x][y] == BTFree) )
	    {
	      dist_extra[x][y] = TRUE;
	      free_blocks ++;
	    }
	  else
	    {
	      dist_extra[x][y] = FALSE;
	      non_free ++;
	    }
      
      
      /* Go through explosions */
      for (ptr = expl_list; ptr != NULL; ptr = ptr->next)
	{
	  if (ptr->count >=0)
	    {
	      ra = MIN(ptr->range, ptr->count + 1);
	      
	      for (x = ptr->x; (x <= (ptr->x + ra)) && (x <= MAZE_W); x++)
		{
		  if (dist_extra[x][ptr->y])
		    free_blocks --;
		  dist_extra[x][ptr->y] = FALSE;
		}
	      for (x = ptr->x; (x >= (ptr->x - ra)) && (x >= 0); x--)
		{
		  if (dist_extra[x][ptr->y])
		    free_blocks --;
		  dist_extra[x][ptr->y] = FALSE;
		}
	      for (y = ptr->y; (y <= (ptr->y + ra)) && (y <= MAZE_H); y++)
		{
		  if (dist_extra[ptr->x][y])
		    free_blocks --;
		  dist_extra[ptr->x][y] = FALSE;
		}
	      for (y = ptr->y; (y >= (ptr->y - ra)) && (y >= 0); y--)
		{
		  if (dist_extra[ptr->x][y])
		    free_blocks --;
		  dist_extra[ptr->x][y] = FALSE;
		}
	    }
	}
      
      
      
      /* fill dist_koord array */
      i = 0;
      for (x=0; x < MAZE_W; x++)
	for (y=0; y < MAZE_H; y++)
	  if (dist_extra[x][y] == TRUE)
	    {
	      dist_x[i] = x;
	      dist_y[i] = y;
	      i ++;
	    }
      
      
#if DEVELOP
      if (i != free_blocks)
	fprintf(stderr,"Error in dist extra %d != %d\n",i,free_blocks);
#endif
      
      /* First the special extra */
      
      if ( (free_blocks>0) && (other) )
	{
	  where = (rand()>>4) % free_blocks;
	  set_maze_block(dist_x[where],dist_y[where], BTSpecial);
	  
	  free_blocks--;
	  /* this position is used */
	  if (where != free_blocks)
	    {
	      my_swap( dist_x + where, dist_x + free_blocks );
	      my_swap( dist_y + where, dist_y + free_blocks );
	    }
	}
      
      if (free_blocks > 0)
	for(i = 0; (free_blocks > 0) && (i < range); i++)
	  {
	    where = (rand()>>4) % free_blocks;
	    set_maze_block(dist_x[where],dist_y[where], BTRange);
	    
	    free_blocks--;
	    /* this position is used */
	    if (where != free_blocks)
	      {
		my_swap( dist_x + where, dist_x + free_blocks );
		my_swap( dist_y + where, dist_y + free_blocks );
	      }
	  }
      
      if (free_blocks > 0)
	for(i = 0; (free_blocks > 0) && (i < bombs); i++)
	  {
	    where = (rand()>>4) % free_blocks;
	    set_maze_block(dist_x[where],dist_y[where], BTBomb);
	    
	    free_blocks--;
	    /* this position is used */
	    if (where != free_blocks)
	      {
		my_swap( dist_x + where, dist_x + free_blocks );
		my_swap( dist_y + where, dist_y + free_blocks );
	      }
	  }
    }
}



/* local function one_expl_at */

static void one_expl_at(x, y, ra, ri, outer, inner)
     int x, y, ra, ri, outer, inner;
{
  int i;

  /* check if explosion are dirty */
  if (expl_dirty_flag)
    {
      /* right */
      for (i=0; (i < ra) && ((x+i) < MAZE_W); i++)
	redraw_maze[x+i][y]=TRUE;
	
      /* leftt */
      for (i=0; (i < ra) && ((x-i) >= 0); i++)
	redraw_maze[x-i][y]=TRUE;
	
      /* down */
      for (i=0; (i < ra) && ((y+i) < MAZE_H); i++)
	redraw_maze[x][y+i]=TRUE;
	
      /* up */
      for (i=0; (i < ra) && ((y-i) >= 0); i++)
	redraw_maze[x][y-i]=TRUE;
	
    }
  

  /* right */
  for (i = 0; (i <= ra) && (maze[x+i][y] <= BTShadow) ; i ++)
    {
      if (i>=(ri-1))
        {
          if( (i+2 > outer) || (i < inner+2 ) )
            redraw_maze[x+i][y] = TRUE;
          if (i >= ri)
            if (i != ri && i != ra)
              expl_maze[x+i][y] |= 0x1a;
            else
              if (i != ri)
                expl_maze[x+i][y] |= 0x18;
              else
                if(i == ra)
                  expl_maze[x+i][y] |= 0x10;
                else
                  expl_maze[x+i][y] |= 0x12;
        }
    }
  if ( (i <= ra) && (maze[x+i][y] == BTExtra) )
    {
      maze[x+i][y] = BTExtraOpen;
      redraw_maze[x+i][y] = TRUE;
    }


  /* left */
  for (i = 0; (i <= ra) && (maze[x-i][y] <= BTShadow); i ++)
    {
      if (i>=(ri-1))
        {
          if(  ( (i+2 > outer) || (i < inner+2 ) ) )
            redraw_maze[x-i][y] = TRUE;
          if (i >= ri)
            if (i != ri && i != ra)
              expl_maze[x-i][y] |= 0x1a;
            else
              if (i != ri)
                expl_maze[x-i][y] |= 0x12;
              else
                if(i == ra)
                  expl_maze[x-i][y] |= 0x10;
                else
                  expl_maze[x-i][y] |= 0x18;
        }
    }
  if ( (i <= ra ) && (maze[x-i][y] == BTExtra) )
    {
      maze[x-i][y] = BTExtraOpen;
      redraw_maze[x-i][y] = TRUE;
    }


  /* up */
  for (i = 0; (i <= ra) && (maze[x][y-i] <= BTShadow); i ++)
    {
      if (i>=(ri-1))
        {
          if(  ( (i+2 > outer) || (i < inner+2 ) ) )
            redraw_maze[x][y-i] = TRUE;
          if (i >= ri)
            if (i != ri && i != ra)
              expl_maze[x][y-i] |= 0x15;
            else
              if (i != ri)
                expl_maze[x][y-i] |= 0x14;
              else
                if(i == ra)
                  expl_maze[x][y-i] |= 0x10;
                else
                  expl_maze[x][y-i] |= 0x11;
        }
    }
  if ( (i <= ra) && ( maze[x][y-i] == BTExtra) )
    {
      maze[x][y-i] = BTExtraOpen;
      redraw_maze[x][y-i] = TRUE;
    }


  /* down */
  for (i = 0; (i <= ra) && (maze[x][y+i] <= BTShadow); i ++)
    {
      if (i>=(ri-1))
        {
          if(  ( (i+2 > outer) || (i < inner+2 ) ) )
            redraw_maze[x][y+i] = TRUE;
          if (i >= ri)
            if (i != ri && i != ra)
              expl_maze[x][y+i] |= 0x15;
            else
              if (i != ri)
                expl_maze[x][y+i] |= 0x11;
              else
                if(i == ra)
                  expl_maze[x][y+i] |= 0x10;
                else
                  expl_maze[x][y+i] |= 0x14;
        }
    }
  if ( (i <= ra) && ( maze[x][y+i] == BTExtra) )
    {
      maze[x][y+i] = BTExtraOpen;
      redraw_maze[x][y+i] = TRUE;
    }

}



/* local function del_explosion */

static void del_explosion(ptr)
     Explosion *ptr;
{
  Explosion *hilf;

  int i,x,y,r,ra;
  /* Bloecke vernichten */

  add_player_num_bomb(ptr->player);

  x = ptr->x;
  y = ptr->y;
  r = ptr->range;
  bomb_maze[x][y]=0;

  num_expl --;

  if ((ptr->count) < ((ptr->range+1) << 1) )
    {
      ra = MIN(ptr->range,ptr->count);

      /* vorzeitig zu loeschen */
            for (i=0; (i < ra) && ((x+i) < MAZE_W); i++)
	redraw_maze[x+i][y]=TRUE;
	
      /* leftt */
      for (i=0; (i < ra) && ((x-i) >= 0); i++)
	redraw_maze[x-i][y]=TRUE;
	
      /* down */
      for (i=0; (i < ra) && ((y+i) < MAZE_H); i++)
	redraw_maze[x][y+i]=TRUE;
	
      /* up */
      for (i=0; (i < ra) && ((y-i) >= 0); i++)
	redraw_maze[x][y-i]=TRUE;
    }


  /* rechts */
  for (i=0; i<=r && ((maze[x+i][y] <= BTShadow)); i++);
  if (i <= r)
    switch(maze[x+i][y])
      {
      case BTExtraOpen:
	if (extra[x+i][y] != BTEvil)
	  maze[x+i][y]= extra[x+i][y];
	else
	  {
	    maze[x+i][y] = BTFree;
	    new_explosion(MAX_PLAYER,x+i,y,3,FALSE);
	  }
        redraw_maze[x+i][y] = TRUE;

	/* Redraw Shadow on the right */
	if ( ( shadow_mode & ShadowExtra )
	    && ( maze[x+i+1][y] == BTShadow ) )
	  {
	    maze[x+i+1][y] = BTFree;
	    redraw_maze[x+i+1][y] = TRUE;
	  }
	/* Redraw for empty Floor */
	if ( maze[x+i][y] == BTFree )
	  {
	    if ( (shadow_mode & ShadowExtra) 
		&& ( (maze[x+i-1][y] == BTExtra) 
		    || (maze[x+i-1][y] == BTExtraOpen) ) )
	      {
		maze[x+i][y] = BTShadow;
	      }
	    if ( (shadow_mode & ShadowBlock) 
		&& (maze[x+i-1][y] == BTBlock)  )
	      {
		maze[x+i][y] = BTShadow;
	      }
						 
	  }

        break;

      case BTSick:
      case BTBomb:
      case BTRange:
      case BTSpecial:
	if ( ( (shadow_mode & ShadowBlock) 
	      && (maze[x+i-1][y]==BTBlock) )
	    || ( (shadow_mode & ShadowExtra) 
		&& ( (maze[x+i-1][y]==BTExtra) 
		    || (maze[x+i-1][y]==BTExtraOpen) ) ) )
	  maze[x+i][y] = BTShadow;
	else
	  maze[x+i][y]= BTFree;
        redraw_maze[x+i][y] = TRUE;
        break;
      }


  /* links */
  for (i=0; i<=r && ((maze[x-i][y] <= BTShadow)); i++);
  if (i <= r)
    switch(maze[x-i][y])
      {
      case BTExtraOpen:
	if (extra[x-i][y] != BTEvil)
	  maze[x-i][y]= extra[x-i][y];
	else
	  {
	    maze[x-i][y] = BTFree;
	    new_explosion(MAX_PLAYER,x-i,y,3,FALSE);
	  }
        redraw_maze[x-i][y] = TRUE;

	/* Redraw Shadow on the right */
	if ( ( shadow_mode & ShadowExtra )
	    && ( maze[x-i+1][y] == BTShadow ) )
	  {
	    maze[x-i+1][y] = BTFree;
	    redraw_maze[x-i+1][y] = TRUE;
	  }
	/* Redraw for empty Floor */
	if ( maze[x-i][y] == BTFree )
	  {
	    if ( (shadow_mode & ShadowExtra) 
		&& ( (maze[x-i-1][y] == BTExtra) 
		    || (maze[x-i-1][y] == BTExtraOpen) ) )
	      {
		maze[x-i][y] = BTShadow;
	      }
	    if ( (shadow_mode & ShadowBlock) 
		&& (maze[x-i-1][y] == BTBlock)  )
	      {
		maze[x-i][y] = BTShadow;
	      }
						 
	  }

        break;

      case BTSick:
      case BTBomb:
      case BTRange:
      case BTSpecial:
	if ( ( (shadow_mode & ShadowBlock) 
	      && (maze[x-i-1][y]==BTBlock) )
	    || ( (shadow_mode & ShadowExtra) 
		&& ( (maze[x-i-1][y]==BTExtra) 
		    || (maze[x-i-1][y]==BTExtraOpen) ) ) )
	  maze[x-i][y] = BTShadow;
	else
        maze[x-i][y]= BTFree;
        redraw_maze[x-i][y] = TRUE;
        break;
      }


  /* unten */
  for (i=0; i<=r && ((maze[x][y+i] <= BTShadow)); i++);
  if (i <= r)
    switch(maze[x][y+i])
      {
      case BTExtraOpen:
	if (extra[x][y+i] != BTEvil)
	  maze[x][y+i]= extra[x][y+i];
	else
	  {
	    maze[x][y+i] = BTFree;
	    new_explosion(MAX_PLAYER,x,y+i,3,FALSE);
	  }
        redraw_maze[x][y+i] = TRUE;

	/* Redraw Shadow on the right */
	if ( ( shadow_mode & ShadowExtra )
	    && ( maze[x+1][y+i] == BTShadow ) )
	  {
	    maze[x+1][y+i] = BTFree;
	    redraw_maze[x+1][y+i] = TRUE;
	  }
	/* Redraw for empty+i Floor */
	if ( maze[x][y+i] == BTFree )
	  {
	    if ( (shadow_mode & ShadowExtra) 
		&& ( (maze[x-1][y+i] == BTExtra) 
		    || (maze[x-1][y+i] == BTExtraOpen) ) )
	      {
		maze[x][y+i] = BTShadow;
	      }
	    if ( (shadow_mode & ShadowBlock) 
		&& (maze[x-1][y+i] == BTBlock)  )
	      {
		maze[x][y+i] = BTShadow;
	      }
						 
	  }

        break;

      case BTSick:
      case BTBomb:
      case BTRange:
      case BTSpecial:
	if ( ( (shadow_mode & ShadowBlock) 
	      && (maze[x-1][y+i]==BTBlock) )
	    || ( (shadow_mode & ShadowExtra) 
		&& ( (maze[x-1][y+i]==BTExtra) 
		    || (maze[x-1][y+i]==BTExtraOpen) ) ) )
	  maze[x][y+i] = BTShadow;
	else
	  maze[x][y+i]= BTFree;
        redraw_maze[x][y+i] = TRUE;
        break;
      }


  /* oben */
  for (i=0; i<=r && ((maze[x][y-i] <= BTShadow)); i++);
  if (i <= r)
    switch(maze[x][y-i])
      {
      case BTExtraOpen:
	if (extra[x][y-i] != BTEvil)
	  maze[x][y-i]= extra[x][y-i];
	else
	  {
	    maze[x][y-i] = BTFree;
	    new_explosion(MAX_PLAYER,x,y-i,3,FALSE);
	  }
        redraw_maze[x][y-i] = TRUE;

	/* Redraw Shadow on the right */
	if ( ( shadow_mode & ShadowExtra )
	    && ( maze[x+1][y-i] == BTShadow ) )
	  {
	    maze[x+1][y-i] = BTFree;
	    redraw_maze[x+1][y-i] = TRUE;
	  }
	/* Redraw for empty-i Floor */
	if ( maze[x][y-i] == BTFree )
	  {
	    if ( (shadow_mode & ShadowExtra) 
		&& ( (maze[x-1][y-i] == BTExtra) 
		    || (maze[x-1][y-i] == BTExtraOpen) ) )
	      {
		maze[x][y-i] = BTShadow;
	      }
	    if ( (shadow_mode & ShadowBlock) 
		&& (maze[x-1][y-i] == BTBlock)  )
	      {
		maze[x][y-i] = BTShadow;
	      }
						 
	  }

        break;

      case BTSick:
      case BTBomb:
      case BTRange:
      case BTSpecial:
	if ( ( (shadow_mode & ShadowBlock) 
	      && (maze[x-1][y-i]==BTBlock) )
	    || ( (shadow_mode & ShadowExtra) 
		&& ( (maze[x-1][y-i]==BTExtra) 
		    || (maze[x-1][y-i]==BTExtraOpen) ) ) )
	  maze[x][y-i] = BTShadow;
	else
	  maze[x][y-i]= BTFree;
        redraw_maze[x][y-i] = TRUE;
        break;
      }



  /* aus liste aushaengen */
  if (ptr == expl_list)
    {
      expl_list = ptr->next;
      if (expl_list == NULL)
        expl_end = NULL;
      cfree(ptr);
    }
  else
    {
      for (hilf = expl_list; (hilf->next != ptr) && (hilf->next != NULL);
           hilf = hilf->next);

      if (hilf->next != NULL)
        {
          if (expl_end == ptr)
            expl_end = hilf;
          hilf->next = hilf->next->next;
          cfree(ptr);
        }
    }
}



/* public function do_bombs() */

void do_bombs()
{
  Explosion *ptr;
  int draw_flag;

  for (ptr = expl_list; ptr != NULL; ptr = ptr->next)
    {
      if (ptr->count < 0)
        {
	  draw_flag = TRUE;
	  switch(ptr->dir)
	    {
	    case GoStop:
	      draw_flag = FALSE;
	      break;
	      
	    case GoUp:
	      if  ( (ptr->dy == 0) 
		   && (maze[ptr->x][ptr->y-1] != BTFree)
		   && (maze[ptr->x][ptr->y-1] != BTShadow) ) 
		{
		  ptr->dir = GoStop;
		}
	      else if ( (ptr->dy <= 0) && bomb_maze[ptr->x][ptr->y-1] )  
		{
		  ptr->dir = GoStop;
		  ptr->dy = 0;
		}
	      else
		{
		  ptr->dy -= BOMB_VY;
		  if (ptr->dy <= -BLOCK_HEIGHT/2)
		    {
		      bomb_maze[ptr->x][ptr->y] = 0;
		      ptr->dy += BLOCK_HEIGHT;
		      ptr->y -= 1;
		      bomb_maze[ptr->x][ptr->y] = 1;
		    }
		}
	      break;

	    case GoDown:
	      if ( (ptr->dy == 0) 
		    && (maze[ptr->x][ptr->y+1] != BTFree)
		    && (maze[ptr->x][ptr->y+1] != BTShadow) )
		{
		  ptr->dir = GoStop;
		}
	      else if ( (ptr->dy >= 0) && bomb_maze[ptr->x][ptr->y+1]) 
		{
		  ptr->dir = GoStop;
		  ptr->dy = 0;
		}
	      else
		{
		  ptr->dy += BOMB_VY;
		  if (ptr->dy >= BLOCK_HEIGHT/2)
		    {
		      bomb_maze[ptr->x][ptr->y] = 0;
		      ptr->dy -= BLOCK_HEIGHT;
		      ptr->y += 1;
		      bomb_maze[ptr->x][ptr->y] = 1;
		    }
		}
	      break;

	    case GoRight:
	      if ( (ptr->dx == 0)  
		  && (maze[ptr->x+1][ptr->y] != BTFree)
		  && (maze[ptr->x+1][ptr->y] != BTShadow) )
		{
		  ptr->dir = GoStop;
		}
	      else if ( (ptr->dx >= 0) && bomb_maze[ptr->x+1][ptr->y]) 
		{
		  ptr->dir = GoStop;
		  ptr->dx = 0;
		}
	      else
		{
		  ptr->dx += BOMB_VX;
		  if (ptr->dx >= BLOCK_WIDTH/2)
		    {
		      bomb_maze[ptr->x][ptr->y] = 0;
		      ptr->dx -= BLOCK_WIDTH;
		      ptr->x += 1;
		      bomb_maze[ptr->x][ptr->y] = 1;
		    }
		}
	      break;

	    case GoLeft:
	      if ( (ptr->dx == 0)  
		  && (maze[ptr->x-1][ptr->y] != BTFree)
		  && (maze[ptr->x-1][ptr->y] != BTShadow) )
		{
		  ptr->dir = GoStop;
		}
	      else if ( (ptr->dx <= 0) && bomb_maze[ptr->x-1][ptr->y]) 
		{
		  ptr->dir = GoStop;
		  ptr->dx  = 0;
		}
	      else
		{
		  ptr->dx -= BOMB_VX;
		  if (ptr->dx <= -BLOCK_WIDTH/2)
		    {
		      bomb_maze[ptr->x][ptr->y] = 0;
		      ptr->dx += BLOCK_WIDTH;
		      ptr->x -= 1;
		      bomb_maze[ptr->x][ptr->y] = 1;
		    }
		}
	      break;

	    }


          /* draw a bomb */
	  if ( (ptr->dir == GoUp) || (ptr->dir == GoDown) )
	    {
	      if (ptr->dy <= 0)
		redraw_maze[ptr->x][ptr->y-1] = TRUE;
	      if (ptr->dy >= 0)
		redraw_maze[ptr->x][ptr->y+1] = TRUE;
	    }

	  
	  if ( (ptr->dir == GoLeft) || (ptr->dir == GoRight) )
	    {
	      if (ptr->dx < 0)
		redraw_maze[ptr->x-1][ptr->y] = TRUE;
	      else if (ptr->dx > 0)
		redraw_maze[ptr->x+1][ptr->y] = TRUE;
	    }

          if (expl_maze[ptr->x][ptr->y]!=0)
            ptr->count = 0;
          if (ptr->blink + ptr->count == 0)
            {
              redraw_maze[ptr->x][ptr->y] = TRUE;
              add_bomb_to_sprite_list(ptr->x*BLOCK_WIDTH + ptr->dx, 
					   ptr->y*BLOCK_HEIGHT + ptr->dy,
                                           ((ptr->range == 1) ? 0x11 : 0x10),
                                           FALSE);
              ptr->blink = ptr->blink >> 1;
            }
          else
            {
              if ( draw_flag || ( (ptr->blink<<1) + ptr->count == 1) )
                redraw_maze[ptr->x][ptr->y] = TRUE;
              add_bomb_to_sprite_list(ptr->x*BLOCK_WIDTH + ptr->dx, 
				      ptr->y*BLOCK_HEIGHT + ptr->dy,
				      ((ptr->range == 1) ? 0x11 : 0x10),
				      TRUE);
            }

	  /* Bomb Error */
	  if ( (ptr->count == -3) 
	      && ((rand()>>2)%BOMB_ERROR_PROB == 0) )
	    {
	      ptr->count = -BOMB_TIME *(2+(rand()>>2)%BOMB_DELAY);
	      ptr->blink = (BOMB_TIME >>1);
	    }
        }
    }
}



/* public function ignite_players_bombs */

int ignite_players_bombs( player )
     int player;
{
  Explosion *ptr;
  int number_of_bombs = 0;

  for (ptr = expl_list; ptr != NULL; ptr = ptr->next)
    {
      if (ptr->count < 0)
        {
          /* draw a bomb */
          if ( ptr->player == player )
	    {
	      ptr->count = 0;
	      number_of_bombs ++;
	    }
        }
    }
  return(number_of_bombs);
}



/* public function ignite_bombs */

void ignite_bombs()
{
  Explosion *ptr;

  for (ptr = expl_list; ptr != NULL; ptr = ptr->next)
    {
      if (ptr->count < 0)
        {
          /* draw a bomb */
          if ( (expl_maze[ptr->x][ptr->y] & 0x0f) !=0)
            ptr->count = 0;
        }
    }
}



/* public functions do_explosion */

int do_explosions()
{
  Explosion *ptr;
  register int hilf;
  int explode_flag;

  explode_flag=FALSE;
  for (ptr = expl_list; ptr != NULL; ptr = ptr->next)
    {
      if (ptr->count >=0)
	if ((ptr->count) >= ((ptr->range+1) << 1) )
	  del_explosion(ptr);
	else
	  {
	    if ( (hilf = ptr->count) == 0)
	      explode_flag = TRUE;
	    one_expl_at(ptr->x,ptr->y,MIN(ptr->range,hilf),
			MAX(0,( (hilf) - ptr->range)),
			hilf,hilf - ptr->range);
	  }
      ptr->count ++;
    }
  expl_dirty_flag = FALSE;

  return(explode_flag);
}



/* public function new_explosion */

void new_explosion(player,x,y,range,remote_controlled)
     int player, x, y, range, remote_controlled;
{
  Explosion *new;

  if (bomb_maze[x][y]==0)
    {
      bomb_maze[x][y]=1;
      redraw_maze[x][y] = TRUE;

      num_expl ++;

      new = (Explosion *)calloc(1,sizeof(Explosion));

      if (expl_list == NULL)
        expl_list = new;
      else
        expl_end->next = new;

      new->player = player;
      new->x = x;
      new->y = y;
      new->dx = 0;
      new->dy = 0;
      new->dir = initial_bomb_dir;
      switch(new->dir)
	{
	case GoDown:
	  if(check_maze_free(new->x,new->y+1))
	    new->dy=BOMB_VY;
	  break;
	}
      new->range = range;
      if (remote_controlled)
	new->count = -GAME_TIME;
      else
	new->count = -BOMB_TIME;
	
      new->blink = BOMB_TIME >>1;

      expl_end = new;
    }
  else
    add_player_num_bomb(player);

}


/* public function stun_players */

void stun_players(ps, num_player)
     BMPlayer *ps;
     int num_player;
{
  Explosion *ptr;
  int player;

  for (ptr = expl_list; ptr != NULL; ptr = ptr->next)
    {
      if (ptr->dir != GoStop)
	{
	  for (player = 0; player < num_player; player ++)
	    {
	      if ( (ps[player].invincible == 0)
		  && (ABS(ptr->x*BLOCK_WIDTH + ptr->dx - ps[player].x ) 
		      < BOMB_STUN_X )
		  && (ABS(ptr->y*BLOCK_HEIGHT + ptr->dy 
			  - ps[player].y - BLOCK_HEIGHT ) < BOMB_STUN_Y ) )
		{
		  /* spieler getroffen */
		  if (0 == ps[player].stunned)
		    ps[player].stunned = STUN_TIME;
		  if (ptr->dx == 0)
		    {
		      if (ptr->dy < 0)
			redraw_maze[ptr->x][ptr->y-1] = TRUE;
		      if (ptr->dy > 0)
			redraw_maze[ptr->x][ptr->y+1] = TRUE;
		    }
		  if (ptr->dy == 0)
		    {
		      if (ptr->dx < 0)
			redraw_maze[ptr->x-1][ptr->y-1] = TRUE;
		      if (ptr->dx > 0)
			redraw_maze[ptr->x+1][ptr->y-1] = TRUE;
		    }
		  ptr->dx = 0;
		  ptr->dy = 0;
#if 0
		  if ( (ptr->dx == 0) && (ptr->dy == 0) )
#endif
		    ptr->dir = GoStop;
		}
	    }
	}
    }
}


/* public function check_explosion */

int check_explosion(x,y)
     int x,y;
{
  return((int)(expl_maze[x][y]!=0));
}



/* public function check_bomb */

int check_bomb(x,y)
     int x,y;
{
  return((int)(bomb_maze[x][y]!=0));
}



/* public function number_of_explosions */

int number_of_explosions()
{
  return(num_expl);
}



/* public delete_outer_bombs(range) */

void delete_outer_bombs(range)
     int range;
{
  Explosion *ptr;
  range ++;

  for (ptr = expl_list; ptr != NULL; ptr = ptr->next)
    if ( (ptr->x < range) || (ptr->x >= (MAZE_W-range) )
	|| (ptr->y < range) || (ptr->y >= (MAZE_H-range) ) )
      del_explosion(ptr);
}



/* public function */

void delete_bomb_at(x,y)
     int x,y;
{
  Explosion *ptr;

  for (ptr = expl_list; ptr != NULL; ptr = ptr->next)
    if ( (ptr->x ==x) && (ptr->y == y) ) 
      del_explosion(ptr);
}



/* public function */

void move_bomb(x,y,dir)
     int x,y,dir;
{
  Explosion *ptr;

  for (ptr = expl_list; ptr != NULL; ptr = ptr->next)
    if ( (ptr->x ==x) && (ptr->y == y) && (ptr->dir == GoStop) ) 
      {
	ptr->dir = dir;
	switch(dir)
	  {
	  case GoUp:
	  case GoDown:
	    ptr->dx = 0;
	    break;

	  case GoLeft:
	  case GoRight:
	    ptr->dy = 0;
	    break;
	  }
      }
}



/* public copy_expl_block */

void copy_expl_block(x, y, block)
     int x,y;
     int block[CHARH][CHARW];
{
  int xp,yp;

  for (xp = x; xp < x+CHARW; xp ++)
    for (yp = y; yp < y+CHARH; yp ++)
      {
	expl_maze[xp][yp] = block[yp-y][xp-x];
	redraw_maze[xp][yp] = TRUE;
      }
}



/* public replace_block_by */

void replace_block_by(old, new, mode)
     int old, new, mode;
{
  int x,y;

  expl_dirty_flag = TRUE;

  if (new != BTFree)
    {
      for (x=0; x<MAZE_W; x++)
	for (y=0; y<MAZE_H; y++)
	  if (maze[x][y]==old)
	    {
	      maze[x][y]=new;
	      redraw_maze[x][y] |= mode;
	    }
    }
  else
      for (x=0; x<MAZE_W; x++)
	for (y=0; y<MAZE_H; y++)
	  if (maze[x][y]==old)
	    {
	      redraw_maze[x][y] |= mode;
	      if ( (shadow_mode & ShadowBlock) 
		  && (maze[x-1][y]==BTBlock) )
		{
		  maze[x][y] = BTShadow;
		}
	      else if ( (shadow_mode & ShadowExtra) 
		       && (maze[x-1][y]==BTExtra) )
		{
		  maze[x][y] = BTShadow;
		}
	      else
		{
		  maze[x][y] = BTFree;
		}
	    }
}
