/*
 * Programm XBLAST V1.04 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * May 16th 1994
 * started August 1993
 *
 * File: func.h
 * special functions for levels 
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */



/* void functions */

void special_init_void()
{
}

void special_revive_void(player)
     int player;
{
}

void special_game_void()
{
}

void special_extra_void(ps, player, num_disp)
     BMPlayer *ps;
     int player, num_disp;
{
}

void special_key_void(ps, player)
     BMPlayer *ps;
     int player;
{
}


/* Invincible */

void special_extra_invincible(ps, player, num_disp)
     BMPlayer *ps;
     int player, num_disp;
{
  int x, disp;

  ps->illtime = 0;
  ps->illness = Healthy;
  ps->invincible = EXTRA_INVINCIBLE;
  x = (2*player + (player > 1 ? 7 : 0));
  for (disp = 0; disp < num_disp; disp ++)
    draw_score_block(disp, x, SBPlayer + player);
  mark_maze(x, MAZE_H, x, MAZE_H);
}


/* Kicking */


void special_init_kick(player)
  int player;
{
  for (player = 0; player < num_player; player ++)
    {
      player_stat[player].kick = TRUE;
    }
}


void special_revive_kick(player)
     int player;
{
  player_stat[player].kick = TRUE;
  replace_block_by(BTSpecial, BTFree, FALSE);
}



void special_extra_kick(ps, player, num_disp)
     BMPlayer *ps;
     int player, num_disp;
{
  int x, disp;

  ps->kick = TRUE;
}



/* racing */

void special_init_race()
{
  int player;
  
  for (player = 0; player < num_player; player ++)
    {
      player_stat[player].illness = IllRun;
      player_stat[player].illtime = GAME_TIME;
    }
}


void special_revive_race(player)
     int player;
{
  player_stat[player].illness = IllRun;
  player_stat[player].illtime = GAME_TIME;
}



/* Remote Control */

void special_extra_RC(ps, player, num_disp)
     BMPlayer *ps;
     int player, num_disp;
{
  ps->remote_control = TRUE;
}


void special_key_RC(ps, player)
     BMPlayer *ps;
     int player;
{
  if (ps->remote_control > 0)
    ignite_players_bombs(player);
}



/* shrinking */

#define SHRINK_TIME 8

static int next_shrink;
static int shrink_range;

void special_init_shrink()
{
  next_shrink = GAME_TIME/(int)(MAZE_H/2);
  shrink_range  = 1;
}


void special_game_shrink()
{
  int x,y;
  int player;
  BMPlayer *ps;

  if (game_time == next_shrink-SHRINK_TIME)
    {
      shrink_range --;
      for (x = shrink_range; x < (MAZE_W - shrink_range); x++)
	{
	  set_maze_block(x, shrink_range, BTBlockRise);
	  set_maze_block(x, (int)(MAZE_H - 1 - shrink_range), BTBlockRise);
	}
      for (y = shrink_range; y < (MAZE_H - shrink_range); y++)
	{
	  set_maze_block(shrink_range, y, BTBlockRise);
	  set_maze_block((int)(MAZE_W - 1 - shrink_range), y, BTBlockRise);
	}
      shrink_range ++;
    }
      
  else if (game_time == next_shrink)
    {
      for (x = shrink_range; x < (MAZE_W - shrink_range); x++)
	{
	  set_maze_block(x, shrink_range, BTBlock);
	  set_maze_block(x, (int)(MAZE_H - 1 - shrink_range), BTBlock);
	}
      for (y = shrink_range; y < (MAZE_H - shrink_range); y++)
	{
	  set_maze_block(shrink_range, y, BTBlock);
	  set_maze_block((int)(MAZE_W - 1 - shrink_range), y, BTBlock);
	}
      
      shrink_range --;
      for (x = shrink_range; x < (MAZE_W - shrink_range); x++)
	{
	  set_maze_block(x, shrink_range, BTSpecial);
	  set_maze_block(x, MAZE_H-1-shrink_range, BTSpecial);
	}
      for (y = shrink_range; y < (MAZE_H - shrink_range); y++)
	{
	  set_maze_block(shrink_range, y, BTSpecial);
	  set_maze_block(MAZE_W-1-shrink_range,y, BTSpecial);
	}
      shrink_range ++;
      
#if 0      
      mark_maze(shrink_range-1, shrink_range-1, 
		shrink_range, MAZE_H-shrink_range);
      mark_maze(MAZE_W-1-shrink_range, shrink_range-1, 
		MAZE_W-shrink_range, MAZE_H-shrink_range);
      mark_maze(shrink_range-1, shrink_range-1, 
		MAZE_W-shrink_range, shrink_range);
      mark_maze(shrink_range-1, MAZE_H-1-shrink_range, 
		MAZE_W-shrink_range, MAZE_H-shrink_range);
#endif
      
      for (player = 0; player < num_player; player ++)
	{
	  ps = player_stat + player;
	  if ( ps->lives > 0 )
	    if ( (ps->x < (shrink_range+1)*BLOCK_WIDTH) 
		|| (ps->x > (MAZE_W-shrink_range-2)*BLOCK_WIDTH)
		|| (ps->y < shrink_range*BLOCK_HEIGHT) 	      
		|| (ps->y > (MAZE_H-shrink_range-3)*BLOCK_HEIGHT) )
	      {
		ps->lives = 1;
		ps->dying = DEAD_TIME;
	      }
	}

      delete_outer_bombs(shrink_range);

      if ( (shrink_range += 1) == (MAZE_H+1)/2)
	next_shrink = 0;
      else
	next_shrink = (shrink_range * GAME_TIME)/(int)(MAZE_H/2);
    }
}



/* shrinking 2 */
#define END_COUNT (4*MAZE_H + 4*MAZE_W - 32)
#define SHRINK_RATE 4


static int next_shrink_2;
static int count=0;

void special_init_shrink_2()
{
  next_shrink_2 = GAME_TIME/2;
  count = 0;
}


void special_game_shrink_2()
{
  int x,y;
  int player;
  BMPlayer *ps;


  if ( (game_time == next_shrink_2-2) || (game_time == next_shrink_2) )
    {
      if (count < MAZE_H-2)
	{
	  x=1,
	  y=MAZE_H-2-count;
	}
      else if (count < (MAZE_H +MAZE_W -5) )
	{
	  y=1;
	  x=2+(count-MAZE_H+2);
	}
      else if (count < (2*MAZE_H +MAZE_W  -8) )
	{
	  x=MAZE_W-2;
	  y=2 + (count-MAZE_H -MAZE_W +5);
	}
      else if (count < (2*MAZE_H +2*MAZE_W -12) )
	{
	  y=MAZE_H-2;
	  x=MAZE_W-3-(count-2*MAZE_H -MAZE_W +8);
	}
      else if (count < (3*MAZE_H + 2*MAZE_W - 16) )
	{
	  x=2;
	  y=MAZE_H-3-(count-2*MAZE_H -2*MAZE_W +12 );
	}
      else if (count < (3*MAZE_H +3*MAZE_W - 21) )
	{
	  y=2;
	  x=3+(count-3*MAZE_H -2*MAZE_W + 16);
	}
      else if (count < (4*MAZE_H +3*MAZE_W -26) )
	{
	  x=MAZE_W-3;
	  y=3+(count -3*MAZE_H -3*MAZE_W +21);
	}
      else if (count < (4*MAZE_H +4*MAZE_W -32) )
	{
	  y=MAZE_H-3;
	  x=MAZE_W-4-(count -4*MAZE_H -3*MAZE_W +26);
	}

      if (game_time == next_shrink_2)
	{
	  count ++;
	  if ( count  == END_COUNT )
	    next_shrink_2 = 0;
	  else
	    next_shrink_2 += SHRINK_RATE;
	  set_maze_block(x, y, BTBlock);
	}
      else
	{
	  set_maze_block(x, y, BTBlockRise);
	  for (player = 0; player < num_player; player ++)
	    {
	      ps = player_stat + player;
	      if ( ps->lives > 0 )
		if ( ( (ps->x < (x+1)*BLOCK_WIDTH) 
		      && (ps->x > (x-1)*BLOCK_WIDTH) )
		    &&( (ps->y < (y)*BLOCK_HEIGHT) 	      
		       && (ps->y > (y-2)*BLOCK_HEIGHT) ) )
		  {
		    ps->lives = 1;
		    ps->dying = DEAD_TIME;
		  }
	    }
	  delete_bomb_at(x,y);
	}
    }
}



/* Extra Stunned */

void special_extra_stunned(ps, player, num_disp)
     BMPlayer *ps;
     int player, num_disp;
{
  ps->stunned = STUN_TIME;
}



/* Extra Ignite All */

void special_extra_ignite_all(ps, player, num_disp)
     BMPlayer *ps;
     int player, num_disp;
{
  for (player = 0; player <= MAX_PLAYER; player++)
    ignite_players_bombs( player );
}


/* Combined Functions */

void special_init_shrink_2_and_kick(player)
     int player;
{
  special_init_kick(player);
  special_init_shrink_2(player);
}


