#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#define MAXMENUS 5
#define MAXMENUSIZE 10

typedef struct _menubuttontype {
	char *name;
	XtCallbackProc callback;
	XtPointer arg;
} menubuttontype;

typedef struct _submenutype {
	char *name;
	int size;
	menubuttontype button[MAXMENUSIZE];
	Widget pulldown, pshell;
} submenutype;

typedef struct _menutype {
	int size;
	submenutype submenu[MAXMENUS];
} menutype;

#define OK	1
#define CANCEL	2

Widget CreateMenuBar(char *name, Widget parent, menutype menu);
Widget CreatePixmapBox(char *name, Widget parent, Pixmap pixmap,
	char *text);
Widget CreateEnterText
	(char *name, Widget parent, int buttonmask, char *text, XtCallbackProc callback);
Widget CreateDialog
	(char *name, Widget parent, int buttonmask, Pixmap icon, char *text, char *buttonlabel, XtCallbackProc callback);
Widget CreateDrawingArea(char *name, Widget parent, int width, int height);
void print_to_widget(Widget w, char *str);
Widget CreateLabel(char *name, Widget parent);
Widget CreateSep(char *name, Widget parent);
Widget CreateRowCol(char *name, Widget parent);
	
void setup_main_widgets ();
void setup_other_widgets (Pixmap about, Pixmap rules, Pixmap thanks,
	Pixmap story, Pixmap freeware);
void update_info(Widget info, horde *bill, network *net, library *systems,
	int level);
void update_high_scores(Widget highscorebox, scorelist scores[10]);
void update_scorebox(Widget scorebox, int level, int score);
