#include "xbill.h"
#include "widgets.h"
#include "text.h"

Widget toplevel, base, menubar, field, info;
Widget aboutbox, rulesbox, thanksbox, storybox, freebox;
Widget warpbox, quitbox, newgamebox, pausebox;
Widget scorebox, highscorebox;
Widget endgamebox, enternamebox;

static menutype menu = {2, 
	{
		{"Game", 5, 
			{
				{"New game", (XtCallbackProc)popup, &newgamebox},
				{"Pause game", (XtCallbackProc)popup, &pausebox},
				{"Warp to level...", (XtCallbackProc)popup, &warpbox},
				{"View high scores", (XtCallbackProc)popup, &highscorebox},
				{"Quit game", (XtCallbackProc)popup, &quitbox},
			}
		},
		{"Info", 5,  
			{
				{"Story of xBill", (XtCallbackProc)popup, &storybox},
				{"Rules", (XtCallbackProc)popup, &rulesbox},
				{"About xBill", (XtCallbackProc)popup, &aboutbox},
				{"Special thanks", (XtCallbackProc)popup, &thanksbox},
				{"Understanding freeware", (XtCallbackProc)popup, &freebox},
			}
		}
	}
};

static char *warpstr = "Warp to level?";
static char *quitstr = "Quit Game?";
static char *newgamestr = "New Game?";
static char *pausestr = "Game paused.  Press Unpause to continue.";
static char *enternamestr = "You have gotten a high score.  Enter your name.";
static char *teststr = "";

extern XtAppContext app;
extern horde bill;
extern library systems;
extern Pixmap icon;

/****************************/
/*  Create main game board  */
/****************************/
void setup_main_widgets () {
	base = CreateRowCol ("base", toplevel);

	menubar=CreateMenuBar("menubar", base, menu);
	
	CreateSep ("bar1", base);
	
	field = CreateDrawingArea ("field", base, 400, 400);
	XtAddEventHandler (field, ButtonPressMask, FALSE, (XtEventHandler)hit_monster, &bill);
	XtAddEventHandler (field, ButtonReleaseMask, FALSE, (XtEventHandler)drop_os, &systems);
	XtAddEventHandler (field, LeaveWindowMask, FALSE, (XtEventHandler)leave_window, NULL);
	XtAddEventHandler (field, EnterWindowMask, FALSE, (XtEventHandler)enter_window, NULL);
	XtAddEventHandler (field, ExposureMask, FALSE, (XtEventHandler)redraw_window, NULL);
#ifdef DEBUG
	XtAddEventHandler (field, KeyPressMask, FALSE, (XtEventHandler)print_debug_info, NULL);
#endif
	CreateSep ("bar2", base);
	
	info = CreateLabel ("info", base);
}

void setup_other_widgets(Pixmap about, Pixmap rules, Pixmap thanks,
	Pixmap story, Pixmap freeware)
{
	DPRINTF("starting setup_other_widgets...\n");
	newgamebox = CreateDialog ("New Game", base, OK|CANCEL, (Pixmap)NULL, newgamestr, (char *)NULL, new_game);
	DPRINTF("loaded new game dialog...\n");
	pausebox = CreateDialog ("Pause Game", base, OK, icon, pausestr, "Unpause", NULL);
	DPRINTF("loaded pause game dialog...\n");
	quitbox = CreateDialog ("Quit", base, OK|CANCEL, (Pixmap)NULL, quitstr, (char *)NULL, quit_game); 
	DPRINTF("loaded quit dialog...\n");
	warpbox = CreateEnterText ("Warp To Level", base, OK|CANCEL, warpstr, (XtCallbackProc) warp_apply);
	DPRINTF("loaded warp dialog...\n");

	aboutbox = CreatePixmapBox ("About", base, about, (char *)NULL);
	DPRINTF("loaded about box...\n");
	rulesbox = CreatePixmapBox ("Rules", base, rules, rules_txt);
	DPRINTF("loaded rules box...\n");
	thanksbox = CreatePixmapBox ("Help", base, thanks, thanks_txt);
	DPRINTF("loaded help box...\n");
	storybox = CreatePixmapBox ("Story", base, story, story_txt);
	DPRINTF("loaded story box...\n");
	freebox = CreatePixmapBox ("Freeware", base, freeware, freeware_txt);
	DPRINTF("loaded freeware box...\n");

	scorebox = CreateDialog ("Score", base, OK, (Pixmap)NULL, teststr, (char *)NULL, NULL);
	DPRINTF("loaded score box...\n");
	endgamebox = CreateDialog ("Endgame", base, OK, (Pixmap)NULL, endgame_txt, "Nuts!", NULL);
	DPRINTF("loaded endgame box...\n");
	highscorebox = CreateDialog ("HighScore", base, OK, (Pixmap)NULL, teststr, (char *)NULL, NULL);
	DPRINTF("loaded highscore box...\n");
	enternamebox = CreateEnterText("Enter Name", base, OK, enternamestr, (XtCallbackProc) enter_name);
	DPRINTF("loaded name entering box...\n");
}	
