/*
 *   eutl - A collection of useful libraries
 *   xmalloc - file wrappers which use the errlib routines so clients
 *             can assume the file routines succeeded.
 *
 *   (c) Copyright 1993,1994 Eric Anderson 
 *
 * My thanks to Geoffrey Collyer and Henry Spencer for providing the basis
 * for this copyright.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. The authors are not responsible for the consequences of use of this
 *    software, no matter how awful, even if they arise from flaws in it.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Since few users ever read sources,
 *    credits must appear in the documentation.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.  Since few users
 *    ever read sources, credits must appear in the documentation.
 *
 * 4. This notice may not be removed or altered.
 */

#include "xfile.h"
#include <libc.h>

static ErrorFunction Erf = LongJmpErrorFunction;
char *xfile_packagever = "XFile -- file wrappers V1.0";
char *xfile_Eopen = "error on open";
char *xfile_Eclose = "error on close";
char *xfile_Eflush = "error on flush";

FILE *xfopen(char *filename,char *type)
{
  FILE *ret;

  ret = fopen(filename,type);
  if (ret) return ret;
  {
    char *errortype;
    switch (*type) {
     case 'r': 
      errortype = *(type+1) == '+' ? "updating" : "reading";
      break;
     case 'w': 
      errortype = *(type+1) == '+' ? "trucating and updating" : "writing";
      break;
     case 'a':
      errortype = *(type+1) == '+' ? "updating at EOF" : "appending";
      break;
     default:
      errortype = "some unknown operation";
    }
    Erf(xfile_packagever,xfile_Eopen,
	"Error opening %s for %s\n",filename,errortype);
  }
  return NULL;			/*NOTREACHED*/
}

void xfclose(FILE *file)
{
  if (fclose(file)) {
    Erf(xfile_packagever,xfile_Eclose,
	"Error closing file: %s\n",strerror(errno));
  }
}

void xfflush(FILE *file)
{
  if (fflush(file)) {
    Erf(xfile_packagever,xfile_Eflush,
	"Error flushing file: %s\n",strerror(errno));
  }
}
