#include <stdio.h>
#include "tcplib.h"
#include "xmalloc.h"
#include "timelib.h"

const int port=8855;

void Send(int size,int npackets)
{
  int l;
  char *buf;
  TcpSocket conn;

  buf = xmalloc(size);

  conn = GetConnection(NULL,port);
  TcpLibBufferOutput(conn,1);
  for(l=0;l<npackets;l++) {
/*    printf("Send %d\n",l);*/
    SendMsg(conn,buf,size);
    if ((l%100)==99)
      TcpLibFlush(conn);
  }
  TcpLibFlush(conn);
  exit(0);
}
  
void Receive(int size,int npackets)
{
  int l;
  char *buf;
  TcpSocket server,conn;
  struct timeval start,end;

  buf = xmalloc(size);

  server = BecomeServer(port);
  WaitForInput(&server,1,TCPLIB_FOREVER);
  if (!HasInput(server)) {
    fprintf(stderr,"WaitForInput returned, but no input\n");
    exit(1);
  }
/*  printf("Accepting Connection\n");*/
  conn = AcceptConnection(server,NULL);
  gettimeofday(&start,NULL);
  for(l=0;l<npackets;l++) {
/*    printf("Receive %d\n",l);*/
    GetMsg(conn,buf,size);
  }
  gettimeofday(&end,NULL);
  printf("Receive of %d packets of size %d took %d ms, %d bytes/ms\n",
	 npackets,size,msDiff(end,start),(npackets*size)/msDiff(end,start));
  exit(0);
}
    
main(int argc,char *argv[])
{
  int size,npackets;

  if (argc != 4 || 
      (strcmp(argv[1],"-s")!=0 && strcmp(argv[1],"-r")!=0) ||
      ((size = atoi(argv[2]))<=0) ||
      ((npackets = atoi(argv[3]))<=0)) {
    fprintf(stderr,"Usage:%s <-s|-r> size npackets\n",argv[0]);
    exit(1);
  }
  
  if (strcmp(argv[1],"-s")==0)
    Send(size,npackets);
  else
    Receive(size,npackets);
  exit(1);
}

