#ifndef __eutl_dynarray_h
#define __eutl_dynarray_h

/* exceptions are used. */
extern char *dynarray_packagever;
extern char *dynarray_Ebadisize;
extern char *dynarray_Eoutofbounds;

/* Usually, just the part after eutl_dynarray_ would be used to call these
   functions, as generated by the defines tested on __eutl_dynarray_impl */

typedef struct __eutl_dynarray_DynArray *eutl_dynarray_DynArray;

/* item size, initial item count, item count increment 
   the default will set the initial number an increment such that
   about EUTL_DYNARRAY_MEMCHUNK bytes are used for each increment, 
   with a minimum increment of EUTL_DYNARRAY_MININCR */

#define EUTL_DYNARRAY_MEMCHUNK 512
#define EUTL_DYNARRAY_MININCR 10
   
eutl_dynarray_DynArray eutl_dynarray_dyn_create(unsigned int itemsize,
				  unsigned int initialnum,/* 0 for default */
				  unsigned int itemincr); /* 0 for default. */
void eutl_dynarray_dyn_destroy(eutl_dynarray_DynArray gone);

void eutl_dynarray_dyn_set(eutl_dynarray_DynArray array,
			   unsigned int index,
			   void *iptr); /* pointer to item */
void *eutl_dynarray_dyn_get(eutl_dynarray_DynArray array,
			    unsigned int index);

/* dyn_set and dyn_get would be used like:
   {
   int x,y,z;
   DynArray arr = eutl_dynarray_dyn_create(sizeof(int),0,0);
   x = 5;y=7;z=8;
   dyn_set(arr,2,&x); // arr[2] = 5 
   y = *(int *)dyn_get(arr,2); // y = 5 
   dyn_set(arr,0,&z); // arr[0] = 8
   y = *(int *)dyn_get(arr,1); // y = unknown
   y = *(int *)dyn_get(arr,5); // dynarray_EOutOfBounds thrown
*/

#ifndef __eutl_dynarray_impl
/* This will convert short exported symbols to 
   the long symbols used in the eutl implementation.
   This reduces the chance of a collision in the symbol table while 
   linking, but doesn't force the programmer to use obnoxiously long
   names (they are still available) */

#define DynArray eutl_dynarray_DynArray
#define dyn_create eutl_dynarray_dyn_create
#define dyn_set eutl_dynarray_dyn_set
#define dyn_get eutl_dynarray_dyn_get
#define dyn_destroy eutl_dynarray_dyn_destroy
#endif

#endif
