#ifndef __chain_hash_h
#define __chain_hash_h

#include <errlib.h>
#include <inttypes.h>

typedef struct __chain_hash *HashTable;
typedef UM32B (*HashFunction)(register unsigned char *key,register xint len);
typedef void (*DestroyBucketFunc)(unsigned char *key,register xint keylen,
				  unsigned char *data,register xint datalen);
typedef struct __HashStatistics {
  xint bucketsused,nbuckets,nentries;
  xint lookups, comparisons;
} HashStatistics;

/* a negative tablesize will pick the smallest internally kept prime bigger 
   than the number specified.  Otherwise, the tablesize should be a prime */
   
HashTable CreateHashTable(xint tablesize,HashFunction hfunc);
void DestroyHashTable(HashTable table,DestroyBucketFunc func);

/* Insert will complain if the key already exists */
void HashInsert(HashTable table,void *key,xint keylen,void *data,xint datalen);
void SHashInsert(HashTable table,char *key,void *data,xint datalen);

/* Overwrite will overwrite the key/value if it exists, and otherwise
   will perform an insert */
void HashOverwrite(HashTable table,void *key,xint keylen,
		   void *data,xint datalen);
void SHashOverwrite(HashTable table,char *key,void *data,xint datalen);

void *HashLookup(HashTable table,void *key,xint keylen);
void *SHashLookup(HashTable table,char *key);
HashStatistics *GetStatistics(HashTable table);

extern char *chainhash_packagever;
extern char *chainhash_Ebadinsert;
extern char *chainhash_Ebadlookup;
#endif
