#ifndef __arglist_h
#define __arglist_h

#include <tcplib.h>

typedef struct __ArgList *ArgList;

/* 32 signed bits will be transfered for longs */
/* strings and buffers can be freed after the call. */

ArgList ArgList_create();
void ArgList_destroy(ArgList gone);
void ArgList_addChar(ArgList to,char val);
void ArgList_addLong(ArgList to,long val);
void ArgList_addString(ArgList to,char *val);
void ArgList_addBuf(ArgList to,void *buf,unsigned long len);
char ArgList_getChar(ArgList from,int posn);
long ArgList_getLong(ArgList from,int posn);
char *ArgList_getString(ArgList from,int posn);
void *ArgList_getBuf(ArgList from,int posn,unsigned long *len);
int ArgList_getLength(ArgList from);
void *ArgList_pack(ArgList from,unsigned long *size);
ArgList ArgList_unpack(void *from,unsigned long size);
void ArgList_send(TcpSocket to,ArgList val);
ArgList ArgList_receive(TcpSocket from);

extern char *arglist_packagever;
extern char *arglist_Eoutofbounds;
extern char *arglist_Etypemismatch;
extern char *arglist_Eunpackerror;
#endif
