/*
 * static char *rcsid_c_wiz_c =
 *   "$Id: c_wiz.c,v 1.9 1995/04/15 04:52:01 master Exp master $";
 */
/*
    CrossFire, A Multiplayer game for X-windows

    Copryight (C) 1994 Mark Wedel
    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to master@rahul.net
*/

/*
 * End of non-DM commands.  DM-only commands below.
 * (This includes commands directly from socket)
 */

/* Some commands not accepted from socket */

#include <global.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif
#include <version.h>
#include <main.h>
#include <spells.h>
#include <treasure.h>

int command_goto (object *op, char *params)
{
      mapstruct *m, *prev;
      char *name;
      object *dummy;

  if (!op)
    return 0;

  if(params == NULL) {
        new_draw_info(NDI_UNIQUE, 0,op,"Go to what level?");
        return 1;
      }
  name = params;
      m = has_been_loaded(name);
      prev = op->map;
      dummy=get_object();
      dummy->map = op->map;
      EXIT_PATH(dummy) = add_string (name);
      enter_exit(op,dummy);
      free_object(dummy);
      if(op->contr->loading == NULL) {
	new_draw_info_format(NDI_UNIQUE, 0, op,
	    "Difficulty: %d.",op->map->difficulty);
        /*
         * Now, if we entered a new, unloaded map, set the cheat-flag in
         * all objects here.
         */
#ifdef SET_WIZCHEAT
        if(op->map != prev && !m) {
          object *tmp;
          for(tmp = objects; tmp != NULL; tmp = tmp->next)
            if(tmp->map == op->map)
              SET_WAS_WIZ(tmp);
        }
#endif
      }
      return 1;
    }

/* is this function called from somewhere ? -Tero */
int command_generate (object *op, char *params)
{
      object *tmp;
      int nr = 1, i, retry;

  if (!op)
    return 0;

  if (params != NULL)
    sscanf(params, "%d", &nr);
      for(i = 0; i < nr; i++) {
        retry = 50;
        while((tmp=generate_treasure(0,op->map->difficulty))==NULL && --retry);
        if (tmp != NULL) {
          tmp = insert_ob_in_ob(tmp, op);
	  if (op->type == PLAYER && op->contr->eric_server > 0)
	      esrv_send_item (op, tmp);
        }
      }
      return 1;
    }

int command_summon (object *op, char *params)
{
      int i;
      object *dummy;
  player *pl;

  if (!op)
    return 0;

  if(params==NULL) {
         new_draw_info(NDI_UNIQUE, 0,op,"Usage: summon <player>.");
         return 1;
      }
      for(pl=first_player;pl!=NULL;pl=pl->next) 
    if(!strncmp(pl->ob->name, params, MAX_NAME)) 
          break;
      if(pl==NULL) {
        new_draw_info(NDI_UNIQUE, 0,op,"No such player.");
        return 1;
      }
      if(pl->state != ST_PLAYING) {
        new_draw_info(NDI_UNIQUE, 0,op,"That player can't be summoned right now.");
        return 1;
      }
      i=find_free_spot(op->arch,op->map,op->x,op->y,1,8);
      dummy=get_object();
      EXIT_PATH(dummy)=add_string(op->map->path);
      EXIT_X(dummy)=op->x+freearr_x[i];
      EXIT_Y(dummy)=op->y+freearr_y[i];
      enter_exit(pl->ob,dummy);
      free_object(dummy);
      new_draw_info(NDI_UNIQUE, 0,pl->ob,"You are summoned.");
      new_draw_info(NDI_UNIQUE, 0,op,"OK.");
      return 1;
    }

int command_create (object *op, char *params)
{
      object *tmp=NULL;
      int nrof,i, magic, set_magic = 0, set_nrof = 0;
      char buf[MAX_BUF], *cp, *bp = buf;
      archetype *at;
      artifact *art=NULL;

  if (!op)
    return 0;

  if (params == NULL) {
        new_draw_info(NDI_UNIQUE, 0,op, "Usage: create [nr] [magic] <archetype> [ of <artifact>]");
        return 1;
      }
  bp = params;
     
      if(sscanf(bp, "%d ", &nrof)) {
    if ((bp = strchr(params, ' ')) == NULL) {
          new_draw_info(NDI_UNIQUE, 0,op, "Usage: create [nr] [magic] <archetype> [ of <artifact>]");
          return 1;
        }
        bp++;
        set_nrof = 1;
        LOG(llevDebug, "(%d) %s\n", nrof, buf);
      }
      if (sscanf(bp, "%d ", &magic)) {
        if ((bp = strchr(bp, ' ')) == NULL) {
          new_draw_info(NDI_UNIQUE, 0,op, "Usage: create [nr] [magic] <archetype> [ of <artifact>]");
          return 1;
        }
        bp++;
        set_magic = 1;
        LOG(llevDebug, "(%d) (%d) %s\n", nrof, magic, buf);
      }
      if ((cp = strstr(bp, " of ")) != NULL) {
        *cp = '\0';
        cp += 4;
      }

      if((at=find_archetype(bp))==NULL) {
        new_draw_info(NDI_UNIQUE, 0,op,"No such archetype.");
        return 1;
      }

      if (cp) {
	if (find_artifactlist(at->clone.type)==NULL) {
	    new_draw_info_format(NDI_UNIQUE, 0, op,
		"No artifact list for type %d\n", at->clone.type);
	}
	else {
	    art = find_artifactlist(at->clone.type)->items;

	    do {
		if (!strcmp(art->item->name, cp)) break;
		art = art->next;
	    } while (art!=NULL);
            if (!art) {
		new_draw_info_format(NDI_UNIQUE, 0, op,
		    "No such artifact ([%d] of %s)", at->clone.type, cp);
	    }
	}
        LOG(llevDebug, "(%d) (%d) (%s) of (%s)\n",
            set_nrof ? nrof : 0, set_magic ? magic : 0 , bp, cp);
      }
      if(at->clone.nrof) {
        tmp=arch_to_object(at);
        tmp->x=op->x,tmp->y=op->y;
        if (set_nrof)
          tmp->nrof = nrof;
        tmp->map=op->map;
	SET_FLAG(tmp, FLAG_WAS_WIZ);
        if (set_magic)
          set_abs_magic(tmp, magic);
        if (art)
          give_artifact_abilities(tmp, art->item);
        if (need_identify(tmp)) {
	  SET_FLAG(tmp, FLAG_IDENTIFIED);
	  CLEAR_FLAG(tmp, FLAG_KNOWN_MAGICAL);
	}
        tmp = insert_ob_in_ob(tmp,op);
	if (op->contr->eric_server > 0)
	    esrv_send_item(op, tmp);
        return 1;
      } 
      D_LOCK(op);
      for (i=0 ; i < (set_nrof ? nrof : 1); i++) {
        archetype *atmp;
        object *prev=NULL,*head=NULL;
        for (atmp=at;atmp!=NULL;atmp=atmp->more) {
          tmp=arch_to_object(atmp);
	  SET_FLAG(tmp, FLAG_WAS_WIZ);
          if(head==NULL)
            head=tmp;
          tmp->x=op->x+tmp->arch->clone.x;
          tmp->y=op->y+tmp->arch->clone.y;
          tmp->map=op->map;
          if (set_magic)
            set_abs_magic(tmp, magic);
          if (art)
            give_artifact_abilities(tmp, art->item);
          if (need_identify(tmp)) {
	    SET_FLAG(tmp, FLAG_IDENTIFIED);
	    CLEAR_FLAG(tmp, FLAG_KNOWN_MAGICAL);
	  }
          if(head!=tmp)
            tmp->head=head,prev->more=tmp;
          prev=tmp;
        }
        if (QUERY_FLAG(head,FLAG_ALIVE))
          insert_ob_in_map(head,op->map);
        else
          head = insert_ob_in_ob(head,op);
        if (at->randomitems!=NULL)
          create_treasure(at->randomitems,head,GT_INVENTORY,
                          op->map->difficulty,0);
	if (op->contr->eric_server > 0) {
	    esrv_send_item(op, head);
	}
      }
      D_UNLOCK(op);
      if (op->contr->eric_server <= 0) {
	draw_all_inventory(op);
	draw_all_look(op);
      }
      return 1;
}

/* if(<not socket>) */

/*
 * Now follows dm-commands which are also acceptable from sockets
 */

int command_inventory (object *op, char *params)
{
    object *tmp;
    int i;

  if (!params) {
    inventory(op, NULL);
    return 0;
  }

  if(!sscanf(params, "%d", &i) || (tmp=find_object(i))==NULL) {
      new_draw_info(NDI_UNIQUE, 0,op,"Inventory of what object (nr)?");
      return 1;
    }
    inventory(op,tmp);
    return 1;
  }

/* just show player's their skills for now. Dm's can
 * already see skills w/ inventory command - b.t.
 */

int command_skills (object *op, char *params)
{
 	show_skills(op);
 	return 0;
}

int command_dump (object *op, char *params)
{
    int i;
  object *tmp;

  if(params!=NULL && !strcmp(params, "me"))
      tmp=op;
  else if(params==NULL || !sscanf(params, "%d", &i) ||
	  (tmp=find_object(i))==NULL) {
      new_draw_info(NDI_UNIQUE, 0,op,"Dump what object (nr)?");
      return 1;
    }
    dump_object(tmp);
    new_draw_info(NDI_UNIQUE, 0,op,errmsg);
    return 1;
  }

int command_patch (object *op, char *params)
{
    int i;
    char *arg,*arg2;
    char buf[MAX_BUF];
  object *tmp;

    tmp=NULL;
  if(params != NULL) {
    if(!strncmp(params, "me", 2))
        tmp=op;
    else if(sscanf(params, "%d", &i))
        tmp=find_object(i);
    else if(sscanf(params, "%s", buf))
        tmp=find_object_name(buf);
    }
    if(tmp==NULL) {
      new_draw_info(NDI_UNIQUE, 0,op,"Patch what object (nr)?");
      return 1;
    }
  arg=strchr(params, ' ');
    if(arg==NULL) {
      new_draw_info(NDI_UNIQUE, 0,op,"Patch what values?");
      return 1;
    }
    if((arg2=strchr(++arg,' ')))
      arg2++;
    SET_FLAG(tmp, FLAG_WAS_WIZ); /* To avoid cheating */
    if(set_variable(tmp,arg) == -1)
      new_draw_info(NDI_UNIQUE, 0,op,errmsg);
    else {
      new_draw_info_format(NDI_UNIQUE, 0, op,
	"(%s#%d)->%s=%s",tmp->name,tmp->count,arg,arg2);
    }
    return 1;
  }

int command_remove (object *op, char *params)
{
    int i;
  object *tmp;

  if(params==NULL || !sscanf(params, "%d", &i) || (tmp=find_object(i))==NULL) {
      new_draw_info(NDI_UNIQUE, 0,op,"Remove what object (nr)?");
      return 1;
    }
    remove_ob(tmp);
    return 1;
  }

int command_free (object *op, char *params)
{
    int i;
  object *tmp;

  if(params==NULL || !sscanf(params, "%d", &i) || (tmp=find_object(i))==NULL) {
      new_draw_info(NDI_UNIQUE, 0,op,"Free what object (nr)?");
      return 1;
    }
    free_object(tmp);
    return 1;
  }

int command_addexp (object *op, char *params)
{
    char buf[MAX_BUF];
    int i;
  player *pl;

  if(params==NULL || sscanf(params, "%s %d", buf, &i)!=2) {
       new_draw_info(NDI_UNIQUE, 0,op,"Usage: addexp [who] [how much].");
       return 1;
    }
    for(pl=first_player;pl!=NULL;pl=pl->next) 
      if(!strncmp(pl->ob->name,buf,MAX_NAME)) 
        break;
    if(pl==NULL) {
      new_draw_info(NDI_UNIQUE, 0,op,"No such player.");
      return 1;
    }
    pl->ob->stats.exp += i;
    add_exp(pl->ob,0);
    SET_FLAG(pl->ob, FLAG_WAS_WIZ);
    draw_stats(pl->ob);
    return 1;
  }

int command_speed (object *op, char *params)
{
    int i;
  if(params==NULL || !sscanf(params, "%d", &i)) {
      sprintf(errmsg,"Current speed is %ld",max_time);
      new_draw_info(NDI_UNIQUE, 0,op,errmsg);
      return 1;
    }
    set_max_time(i);
    reset_sleep();
    new_draw_info(NDI_UNIQUE, 0,op,"The speed is changed.");
    return 1;
  }


/**************************************************************************/
/* Mods made by Tyler Van Gorder, May 10-13, 1992.                        */
/* CSUChico : tvangod@cscihp.ecst.csuchico.edu                            */
/**************************************************************************/

int command_stats (object *op, char *params)
{
  char thing[20];
  player *pl;
  char buf[MAX_BUF];

    thing[0] = '\0';
  if(params==NULL || !sscanf(params, "%s", thing) || thing == NULL) {
       new_draw_info(NDI_UNIQUE, 0,op,"Who?");
       return 1;
    }
    for(pl=first_player;pl!=NULL;pl=pl->next) 
       if(!strcmp(pl->ob->name,thing)) {
         sprintf(buf,"Str : %-2d      H.P. : %-4d  MAX : %d",
                 pl->ob->stats.Str,pl->ob->stats.hp,pl->ob->stats.maxhp);
         new_draw_info(NDI_UNIQUE, 0,op,buf);
         sprintf(buf,"Dex : %-2d      S.P. : %-4d  MAX : %d",
                 pl->ob->stats.Dex,pl->ob->stats.sp,pl->ob->stats.maxsp) ;
         new_draw_info(NDI_UNIQUE, 0,op,buf);
         sprintf(buf,"Con : %-2d        AC : %-4d  WC  : %d",
                 pl->ob->stats.Con,pl->ob->stats.ac,pl->ob->stats.wc) ;
         new_draw_info(NDI_UNIQUE, 0,op,buf);
         sprintf(buf,"Wis : %-2d       EXP : %ld",
                 pl->ob->stats.Wis,pl->ob->stats.exp);
         new_draw_info(NDI_UNIQUE, 0,op,buf);
         sprintf(buf,"Cha : %-2d      Food : %d",
                 pl->ob->stats.Cha,pl->ob->stats.food) ;
         new_draw_info(NDI_UNIQUE, 0,op,buf);
         sprintf(buf,"Int : %-2d    Damage : %d",
                 pl->ob->stats.Int,pl->ob->stats.dam) ;
         new_draw_info(NDI_UNIQUE, 0,op,buf);
         break;
       }
    if(pl==NULL)
       new_draw_info(NDI_UNIQUE, 0,op,"No such player.");
    return 1;
  }

int command_abil (object *op, char *params)
{
  char thing[20], thing2[20];
  int iii;
  player *pl;
  char buf[MAX_BUF];

    iii = 0;
    thing[0] = '\0';
    thing2[0] = '\0';
  if(params==NULL || !sscanf(params, "%s %s %d", thing, thing2, &iii) ||
     thing==NULL) {
       new_draw_info(NDI_UNIQUE, 0,op,"Who?");
       return 1;
    }
    if (thing2==NULL){
       new_draw_info(NDI_UNIQUE, 0,op,"You can't change that.");
       return 1;
    }
    if (iii<MIN_STAT||iii>MAX_STAT) {
      new_draw_info(NDI_UNIQUE, 0,op,"Illegal range of stat.\n");
      return 1;
    }
    for(pl=first_player;pl!=NULL;pl=pl->next) 
       if(!strcmp(pl->ob->name,thing)){   
	  SET_FLAG(pl->ob, FLAG_WAS_WIZ);
          if(!strcmp("str",thing2))
            pl->ob->stats.Str = iii,pl->orig_stats.Str = iii;
          if(!strcmp("dex",thing2))   
            pl->ob->stats.Dex = iii,pl->orig_stats.Dex = iii;
          if(!strcmp("con",thing2))
            pl->ob->stats.Con = iii,pl->orig_stats.Con = iii;
          if(!strcmp("wis",thing2))
            pl->ob->stats.Wis = iii,pl->orig_stats.Wis = iii;
          if(!strcmp("cha",thing2))
            pl->ob->stats.Cha = iii,pl->orig_stats.Cha = iii;
          if(!strcmp("int",thing2))
            pl->ob->stats.Int = iii,pl->orig_stats.Int = iii;
          sprintf(buf,"%s has been altered.",pl->ob->name);
          new_draw_info(NDI_UNIQUE, 0,op,buf);
          fix_player(pl->ob);
         return 1;
       } 
    new_draw_info(NDI_UNIQUE, 0,op,"No such player.");
    return 1;
  }

int command_reset (object *op, char *params)
{
    mapstruct *m;
    object *dummy = NULL, *tmp = NULL;

  if (params == NULL) {
      new_draw_info(NDI_UNIQUE, 0,op,"Reset what map [name]?");
      return 1;	
    }
  if (strcmp(params, ".") == 0)
    params = op->map->path;
  m = has_been_loaded(params);
    if (m==NULL) {
      new_draw_info(NDI_UNIQUE, 0,op,"No such map.");
      return 1;	
    }

    if (m->in_memory != MAP_SWAPPED) {
      player *pl;

	if(m->in_memory != MAP_IN_MEMORY) {
	    LOG(llevError,"Tried to swap out map which was not in memory.\n");
	    return 0;
	}
	for(pl=first_player;pl!=NULL;pl=pl->next)
	    if(pl->ob == NULL || (!(QUERY_FLAG(pl->ob,FLAG_REMOVED)) && pl->ob->map == m))
		if (QUERY_FLAG(pl->ob,FLAG_WIZ)) {
		    /* does not work if there are several dms in same map */
		    tmp = pl->ob;
		    dummy=get_object();
		    dummy->map = m;
		    EXIT_X(dummy) = tmp->x;
		    EXIT_Y(dummy) = tmp->y;
	  EXIT_PATH(dummy) = add_string (params);
		    remove_ob (tmp);
		} else
		    break;
	swap_map(m);
      }

      if (m->in_memory == MAP_SWAPPED) {	
	LOG(llevDebug,"Resetting map %s.\n",m->path);
	clean_tmp_map(m);
	if (m->tmpname) free(m->tmpname);
	m->tmpname = NULL;
	m->reset_time = 0;
	
	if (tmp) {
	    enter_exit(tmp, dummy);
	    /* sigh - enter exit does not insert object 
	       if it is removed */
	    SET_FLAG(tmp, FLAG_NO_APPLY);
	    insert_ob_in_map(tmp,tmp->map);
	    CLEAR_FLAG(tmp, FLAG_NO_APPLY);
	    free_object(dummy);
	}

      new_draw_info(NDI_UNIQUE, 0,op,"OK.");
      return 1;	      
    }
    new_draw_info(NDI_UNIQUE, 0,op,"Reset failed, couldn't swap map.\n");
    return 1;
  }

int command_nowiz (object *op, char *params) /* 'noadm' is alias */
{
     if(op == NULL) {
       active_socket->wiz = 0;
       return 1;
     }
     CLEAR_FLAG(op, FLAG_WIZ);
     CLEAR_FLAG(op, FLAG_WIZPASS);
     CLEAR_FLAG(op, FLAG_FLYING);
     return 1;
  }
