#include <client.h>

/* This file handles various player related functions.  This includes
 * both things that operate on the player item, cpl structure, or
 * various commands that the player issues.
 */

/* This translates the numeric direction id's into the actual direction
 * commands.  This lets us send the actual command (ie, 'north'), which
 * makes handling on the server side easier.
 */

char *directions[9] = {"stay", "north", "northeast", "east", "southeast",
		"south","southwest", "west", "northwest"};


/*
 *  Initialiazes player item, information is received from server
 */
void new_player (long tag, char *name, long weight, long face)
{
    cpl.ob->tag    = tag;
    cpl.ob->nrof   = 1;
    copy_name (cpl.ob->name, name);
    cpl.ob->weight = (float) weight / 1000;
    cpl.ob->face   = face;
}

#if 0
/* Following should not be needed any more */

static long lotso_keysyms[] = {
#include "eatme.h"
};


#define NKEYSYMS (sizeof(lotso_keysyms)/sizeof(long))

void SendKeyConversion(TcpSocket conn)
{
  int i;
  long kc,ks;
  ArgList msg;

/*  printf("skc\n");*/
  msg = ArgList_create();
  ArgList_addLong(msg,STRINGCOMMAND);
  ArgList_addString(msg,"keyconversion");
  ArgList_addLong(msg,NKEYSYMS);
  for(i=0;i<NKEYSYMS;i++) {
    ks = lotso_keysyms[i];
    kc = display_ks2kc(ks);
    ArgList_addLong(msg,ks);
    ArgList_addLong(msg,kc);
  }
  ArgList_send(conn,msg);
  ArgList_destroy(msg);
/*  printf("skc-done%d\n",NKEYSYMS);*/
}


void client_send_keypress(unsigned int keycode,unsigned long keysym,char key)
{
  ArgList msg;

  msg = ArgList_create();
  ArgList_addLong(msg,STRINGCOMMAND);
  ArgList_addString(msg,"keypress");
  ArgList_addLong(msg,keycode);
  ArgList_addLong(msg,keysym);
  ArgList_addLong(msg,key);
  ArgList_send(conns[0],msg);
  ArgList_destroy(msg);
}

void client_send_keyrelease(unsigned int keycode,unsigned long keysym,char key)
{
  ArgList msg;

  msg = ArgList_create();
  ArgList_addLong(msg,STRINGCOMMAND);
  ArgList_addString(msg,"keyrelease");
  ArgList_addLong(msg,keycode);
  ArgList_addLong(msg,keysym);
  ArgList_addLong(msg,key);
  ArgList_send(conns[0],msg);
  ArgList_destroy(msg);
}
#endif

void client_send_apply (long tag)
{
    ArgList msg;

    msg = ArgList_create();
    ArgList_addLong (msg, STRINGCOMMAND);
    ArgList_addString (msg, "apply");
    ArgList_addLong (msg, tag);
    ArgList_send (conns[0],msg);
    ArgList_destroy (msg);
}

void client_send_examine (long tag)
{
    ArgList msg;

    msg = ArgList_create();
    ArgList_addLong (msg, STRINGCOMMAND);
    ArgList_addString (msg, "examine");
    ArgList_addLong (msg, tag);
    ArgList_send (conns[0],msg);
    ArgList_destroy (msg);
}

void client_send_move (long loc, long tag, long nrof)
{
    ArgList msg;

    msg = ArgList_create();
    ArgList_addLong (msg, STRINGCOMMAND);
    ArgList_addString (msg, "move");
    ArgList_addLong (msg, loc);
    ArgList_addLong (msg, tag);
    ArgList_addLong (msg, nrof);
    ArgList_send (conns[0],msg);
    ArgList_destroy (msg);
}



void move_player(int dir) {
    ArgList msg;

    msg = ArgList_create();
    ArgList_addLong (msg, STRINGCOMMAND);
    ArgList_addString (msg, "command");
    ArgList_addLong(msg, 0);
    ArgList_addString(msg,directions[dir]);
    ArgList_send (conns[0],msg);
    ArgList_destroy (msg);
}

/* Fires in a specified direction.  Note that direction 0 is a valid
 * case - the fire is centered on the player.
 */


void stop_fire()
{
    ArgList msg;

    msg = ArgList_create();
    ArgList_addLong (msg, STRINGCOMMAND);
    ArgList_addString (msg, "command");
    ArgList_addLong(msg,0);
    ArgList_addString(msg,"fire_stop");
    ArgList_send (conns[0],msg);
    ArgList_destroy (msg);
}

void stop_run()
{
    ArgList msg;

    msg = ArgList_create();
    ArgList_addLong (msg, STRINGCOMMAND);
    ArgList_addString (msg, "command");
    ArgList_addLong(msg,0);
    ArgList_addString(msg,"run_stop");
    ArgList_send (conns[0],msg);
    ArgList_destroy (msg);
}

void fire_dir(int dir) {
    ArgList msg;
    char buf[MAX_BUF];

    msg = ArgList_create();
    ArgList_addLong (msg, STRINGCOMMAND);
    ArgList_addString (msg, "command");
    ArgList_addLong(msg,0);
    sprintf(buf,"fire %d\n", dir);
    ArgList_addString(msg,buf);
    ArgList_send (conns[0],msg);
    ArgList_destroy (msg);
}

void run_dir(int dir) {
    ArgList msg;
    char buf[MAX_BUF];

    msg = ArgList_create();
    ArgList_addLong (msg, STRINGCOMMAND);
    ArgList_addString (msg, "command");
    ArgList_addLong(msg,0);
    sprintf(buf,"run %d\n", dir);
    ArgList_addString(msg,buf);
    ArgList_send (conns[0],msg);
    ArgList_destroy (msg);
}

void send_command(char *command) {
    ArgList msg;

    msg = ArgList_create();
    ArgList_addLong (msg, STRINGCOMMAND);
    ArgList_addString (msg, "command");
    ArgList_addLong(msg, cpl.count);
    ArgList_addString(msg,command);
    ArgList_send (conns[0],msg);
    ArgList_destroy (msg);
    cpl.count=0;
}

/* This is an extended command (ie, 'who, 'whatever, etc).  In general,
 * we just send the command to the server, but there are a few that
 * we care about (bind, unbind)
 */

void extended_command(char *command) {
    ArgList msg;
    char *cp = command, *cpnext;

    if ((cpnext = strchr(cp, ' '))!=NULL)
	*cpnext++ = '\0';


    if (!strcmp(cp, "bind"))
	bind_key(cpnext);
    else if (!strcmp(cp,"unbind"))
	unbind_key(cpnext);
    else if (!strcmp(cp,"showicons"))
	set_show_icon (cpnext);
    else if (!strcmp(cp,"showweight"))
	set_show_weight (cpnext);
    else if (!strcmp(cp,"inv")) /* inventory command is sended to server
				   for debugging purposes */
	print_inventory (cpl.ob);
    else {
	/* reconstruct the string */
	if (cpnext) *(--cpnext) = ' ';

	msg = ArgList_create();
	ArgList_addLong (msg, STRINGCOMMAND);
	ArgList_addString (msg, "command");
	ArgList_addLong(msg,0);
	ArgList_addString(msg,cp);
	ArgList_send (conns[0],msg);
	ArgList_destroy (msg);
    }
}
 
