/* Header file for new client. */

#include <cconfig.h>
#include <includes.h>
#include <newclient.h>
#include <item.h>
#include <arglist.h>
#include <proto.h>

/* Just some handy ones I like to use */
#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#define ECLIENT_VERSION 1002
#define STRINGCOMMAND 0
#define MAX_BUF 256

/* Some global variables */
extern TcpSocket conns[2];

extern int port_num,
	basenrofpixmaps;	/* needed so that we know where to
				 * start when creating the additional
				 * images in x11.c
				 */

extern int fdin,fdout,		/* file descriptors for the socket */
    pending_images,		/* number of images we have requested
				 * but not received.
				 */
    pending_archs,		/* Same as pending images, but
				 * archetypes instead
				 */
    maxfiledescriptor;		/* Max file descriptor allowed for the
				 * system.  Used for the select calls.
				 */

extern char
    *server, *client_libdir,
    *client_archfile,		/* Name (full path) of the file
				 * that stores local client
				 * archetypes.  New ones that are
				 * downloaded will also be stored in this
				 * file
				 */
    init_load_image,		/* If true, download all images from
				 * server at startup
				 */
    init_load_arch,		/* As per init_load_image, but for
				 * archetypes
				 */
    save_new_data;		/* IF true, then when we get new image
				 * or archetype data, we save it to
				 * disk, so that we don't have to
				 * download it each time.
				 */

typedef enum Input_State {Playing, Reply_One, Reply_Many,
	Configure_Keys, Command_Mode} Input_State;

typedef enum inventory_show {
  show_all = 0, show_applied = 1, show_unapplied = 2, show_unpaid = 3,
  show_cursed = 4, show_magical = 5, show_nonmagical = 6
} inventory_show;

typedef enum rangetype {
  range_bottom = -1, range_none = 0, range_bow = 1, range_magic = 2,
  range_wand = 3, range_rod = 4, range_scroll = 5, range_horn = 6,
  range_steal = 7,
  range_size = 8
} rangetype;

typedef struct Stat_struct {
  sint8 Str,Dex,Con,Wis,Cha,Int;
  sint8 wc,ac;    /* Weapon Class and Armour Class */
  sint8 armor;
  sint8 level;
  sint16 hp;      /* Hit Points. */
  sint16 maxhp;
  sint16 sp;      /* Spell points.  Used to cast spells. */
  sint16 maxsp;   /* Max spell points. */
  sint32 exp;      /* Experience.  Killers gain 1/10. */
  sint16 food;    /* How much food in stomach.  0 = starved. */
  sint8 dam;      /* How much damage this object does when hitting */
  sint32 speed;	/* Gets converted to a float for display*/
  sint32 weapon_sp;	/* Gets converted to a float for display */
} Stats;


typedef struct Player_Struct {
    item	*ob;		/* Player object */
    item	*below;		/* Items below the player (pl.below->inv) */
    inventory_show show_what;	/* What to show in inventory */
    item	*container;	/* open container */
    uint16	count_left;	/* count for commands */
    Input_State input_state;	/* What the input state is */
    uint32	no_echo:1;	/* If TRUE, don't echo keystrokes */
    char	input_text[MAX_BUF];	/* keys typed (for long commands) */
    char	name[40];	/* name and password.  Only used while */
    char	password[40];	/* logging in. */
    rangetype	shoottype;	/* What type of range attack player has */
    item	*ranges[range_size];	/* Object that is used for that */
				/* range type */
    uint8	ready_spell;	/* Index to spell that is readied */
    char	spells[255][40];	/* List of all the spells the */
				/* player knows */
    uint8	map_x, map_y;	/* These are offset values.  See object.c */
				/* for more details */
    Stats	stats;		/* Player stats */
    char	title[MAX_BUF];	/* Title of character */
    char	range[MAX_BUF];	/* Range attack chosen */
    uint32	fire_on:1;	/* True if fire key is pressed */
    uint32	run_on:1;	/* True if run key is on */
    uint32	echo_bindings:1;/* If true, echo the command that the key */
				/* is bound to */
    uint32	count;		/* Repeat count on command */

} Client_Player;

extern Client_Player cpl;		/* Player object. */

/* To handle XPM display mode, #ifdef Xpm_Pix are only used in areas
 * that make XPM function calls, or areas where using certain display
 * methods is a lot more efficient.
 *
 * Xpm_Display can only be set if Xpm_Pix is defined.  Thus, a lot
 * of the #ifdefs can be removed - those functions will never be called,
 * or values used, because Display_Mode will never be set to Xpm_Display
 */

typedef enum Display_Mode {Font_Display, Pix_Display, Xpm_Display}
	Display_Mode;

extern Display_Mode display_mode;
