/* This is a config file for the client.  Many of the options are
 * taken from the standard config.h file.  However, a few new ones unique
 * to the client are here.  Also, if the client ever became a totally
 * seperate distibution, this would be needed in any case.
 */


/* This is the program name that gets sent with the LOGIN command.
 * It can be anything, and the server only uses it for information
 * on what clients are being used.
 */

#define PROG_NAME "cfclient 1.0 (X11)"

/* X_PROG_NAME is the name that is used to read X resources. */
#define X_PROG_NAME "cfclient"


/* This is where the files used by the client lives.  This is in addition
 * to the standard LIBDIR used by crossfire.
 * Standard LIBDIR files are used for a first pass in the loading
 * of certain values (archetypes, bitmaps & pixmaps).  In general,
 * the standard LIBDIR should contain a lot of what is needed.
 * 
 * CLIENT_LIBDIR is where the extra details live - things like
 * files downloaded from the server, additional archetypes, etc.
 * This can also be set with the environment variable CFCLIENT_LIBDIR
 * Changing the information in this directory is not a security
 * risk (like changing LIBDIR for the server is).
 *
 * If it is not set, then information can not be downloaded for permanent
 * storage.  It CAN NOT be the same as LIBDIR - this would very
 * likely corrupt data, read data twice, etc.
 *
 * Files in this directory (whether set here, or changed via enviromental
 * variable): 
 * bmaps (file - names of bitmaps stored - in same format as the normal
 *	bmaps file)
 * images (directory).  This is where image files (both xpm and
 *	pixmap) are stored.
 */

/*
#define CLIENT_LIBDIR
*/


/* The number of chances the client waits for requested data to
 * actually show up.  This is used during startup, when we have
 * requested certain information and are just waiting for it all to
 * arrive before going to the next step.
 */
#define MAX_RETRIES	5


/* CLIENT_ARCHFILE is the local archetype file.  This contains
 * various archetypes that the client are missing (they are downloaded
 * and stored in this file.)  This file is stored in the
 * CLIENT_LIBDIR directory.  This value can be overridden with
 * the CFCLIENT_ARCHFILE environmental variable.
 */

#define CLIENT_ARCHFILE "archetypes.bak"

/* This is how often the client checks for X events, as well as how often
 * it performs animations (or will).  This value can be most anything.
 * IT is only configurable because the exact value it needs to be set to
 * has to be figured out.
 */

#define MAX_TIME 100000


/* This is the default port to connect to the server with. */
#define EPORT 17399

/* The name of the font that contains the special graphical characters */
#define FONTNAME "crossfire"

/* Where the font can be found.  Note that wherever it is, mkfontdir
 * still needs to be run for that directory.
 */
#define FONTDIR "/usr/lib/X11R6/lib/fonts/misc/"
