/*
 * static char *rcsid_shop_c =
 *   "$Id: shop.c,v 1.3 1993/04/22 06:04:57 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.

*/

#include <global.h>
#include <spells.h>
#include <living.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif

/* Added F_TRUE flag to define.h to mean that the price should not
 * be adjusted by players charisma. With F_TRUE, it returns the amount
 * that the item is worth, if it was sold, but unadjusted by charisma.
 * This is needed for alchemy, to to determine what value of gold nuggets
 * should be given (the gold nuggets, when sold, will have the adjustment
 * by charisma done at that time).  NULL could have been passed as the
 * who parameter, but then the adjustment for expensive items (>10000)
 * would not be done.
 * Mark Wedel (master@cats.ucsc.edu)
 */
int query_cost(object *tmp, object *who, int flag) {
  int i=tmp->value;
  if(tmp->magic&&(tmp->arch==NULL||!tmp->arch->clone.magic))
    if(tmp->magic>0)
      i*=(3*tmp->magic*tmp->magic*tmp->magic); /* Don't multiply artifacts. */
    else
      i/=(1-tmp->magic);
  if(flag==F_BUY)
    i*=6; /* For charisma 25, the price is now x1.5 */
  if(tmp->type==WAND)
    i=(i*tmp->stats.food)/spells[tmp->stats.sp].charges;
  if ((flag==F_TRUE) && (i>10000))
	i=8000+isqrt(i)*20;
  else if (who!=NULL)
    if(flag==F_BUY)
      i=(i*(100-cha_bonus[who->stats.Cha]))/100;
    else {
      if(i>10000)
        i=8000+isqrt(i)*20;
      i=(i*100)/(100-cha_bonus[who->stats.Cha]);
    }
  if(tmp->nrof)
    i*=tmp->nrof;
  if(i<0)
    i=1000000;
  return i;
}

char *query_cost_string(object *tmp,object *who,int flag) {
  static char buf[MAX_BUF];
  int i=query_cost(tmp,who,flag),gold=i/10,silver=i%10;

  if(!gold&&!silver)
    strcpy(buf,"nothing");
  else if(gold&&!silver)
    sprintf(buf,"%d gold coins",gold);
  else if(gold&&silver)
    sprintf(buf,"%d gold coins and %d silver coins",gold,silver);
  else
    sprintf(buf,"%d silver coins",silver);
  return buf;
}

int query_money(object *op) {
  object *platina_ob=present_in_ob(PLATINACOIN,op);
  object *gold_ob=present_in_ob(GOLDCOIN,op);
  object *silver_ob=present_in_ob(SILVERCOIN,op);
  return (platina_ob==NULL?0:platina_ob->nrof*50)+
         (gold_ob==NULL?0:gold_ob->nrof*10)+
         (silver_ob==NULL?0:silver_ob->nrof);
}

int pay_for_item(object *op,object *pl) {
  int i=query_cost(op,pl,F_BUY),paid=0;
  object *platina_ob=present_in_ob(PLATINACOIN,pl);
  object *gold_ob=present_in_ob(GOLDCOIN,pl);
  object *silver_ob=present_in_ob(SILVERCOIN,pl);
  object *tmp;

  if(!i||i>query_money(pl))
    return 0;
 
  if(silver_ob!=NULL) {
    if(silver_ob->nrof>=i) {
      tmp=get_split_ob(silver_ob,i);
      if(tmp!=NULL)
        free_object(tmp);
      return 1;
    } else if (silver_ob->nrof >= i%10) {
      paid= i%10 + ((silver_ob->nrof - i%10)/10)*10;
      tmp=get_split_ob(silver_ob, paid);
      if(tmp!=NULL)
        free_object(tmp);
    }
  }
  tmp=get_split_ob(gold_ob,(i-paid+9)/10);
  if(tmp!=NULL) {
    paid+=tmp->nrof*10;
    free_object(tmp);
  }
  if(paid>i) {
    tmp=clone_arch(SILVERCOIN);
    tmp->nrof=paid-i;
    insert_ob_in_ob(tmp,pl);
    paid=i;
  }
  if(paid<i) {
    tmp=get_split_ob(platina_ob,(i-paid+49)/50);
    if(tmp!=NULL) {
      paid+=tmp->nrof*50;
      free_object(tmp);
    }
    if(paid>i) {
      if((paid-i)%10) {
        tmp=clone_arch(SILVERCOIN);
        tmp->nrof=(paid-i)%10;
        paid+=tmp->nrof;
        insert_ob_in_ob(tmp,pl);
      }
      if((paid-i)/10) {
        tmp=clone_arch(GOLDCOIN);
        tmp->nrof=(paid-i)/10;
        paid+=tmp->nrof*10;
        insert_ob_in_ob(tmp,pl);
      }
    }
  }
  if(WAS_WIZ(op))
    SET_WAS_WIZ(tmp);
  return 1;
}

/* Eneq(@csd.uu.se): Better get_payment, descends containers looking for
   unpaid items. get_payment is now used as a link. To make it simple
   we need the player-object here. */

int get_payment2 (object *pl, object *op) {
    char buf[MAX_BUF],buf2[MAX_BUF];
    int ret=1;

    if (op!=NULL&&op->inv)
        ret = get_payment2(pl, op->inv);

    if (!ret) 
        return 0;

    if (op!=NULL&&op->below) 
        ret = get_payment2 (pl, op->below);

    if (!ret) 
        return 0;
   
    if(op!=NULL&&IS_UNPAID(op)) {
        strncpy(buf,query_cost_string(op,pl,F_BUY),MAX_BUF);
        if(!pay_for_item(op,pl)) {
#if 0
            sprintf(buf2,"You can't afford %s.",query_name(op));
#else
            int i=query_cost(op,pl,F_BUY) - query_money(pl);
            UNSET_UNPAID(op);
            sprintf(buf2,"You lack %d.%1d gold to by %s.",
                    i/10,i%10,query_name(op));
            SET_UNPAID(op);
#endif
            draw_info(pl,buf2);
            D_UNLOCK(pl);
            draw_all_inventory(pl);
            return 0;
        } else {
            UNSET_UNPAID(op);
            sprintf(buf2,"You paid %s for %s.",buf,query_name(op));
            merge_ob(op,NULL);
            draw_info(pl,buf2);
        }
    }
    return 1;
}

int get_payment(object *pl) {
  int ret;

  D_LOCK(pl);

  ret = get_payment2 (pl, pl->inv);

  D_UNLOCK(pl);
  draw_all_inventory(pl);
  return ret;
}

void sell_item(object *op, object *pl) {
  int i=query_cost(op,pl,F_SELL),silver=i%10,gold=i/10;
  char buf[MAX_BUF];
  object *tmp, *otmp2;

  if(pl==NULL||pl->type!=PLAYER) {
    LOG(llevDebug,"Object other than player tried to sell something.\n");
    return;
  }
  if(!i) {
    sprintf(buf,"We're not interested in %s.",query_name(op));
    draw_info(pl,buf);
    return;
  }

  otmp2=pl->container;
  pl->container=NULL;

  if(silver) {
    tmp=clone_arch(SILVERCOIN);
    tmp->nrof=silver;
    insert_ob_in_ob(tmp,pl);
  }
  if(gold) {
    tmp=clone_arch(GOLDCOIN);
    tmp->nrof=gold;
    insert_ob_in_ob(tmp,pl);
  }

  pl->container=otmp2;

  sprintf(buf,"You receive %s for %s.",query_cost_string(op,pl,1),
          query_name(op));
  SET_UNPAID(op);
  draw_info(pl,buf);
}


#ifdef SHOP_LISTINGS
/* SHOP_LISTINGS code added by Mark Wedel (master@cats.ucsc.edu)
 *
 * I put the code here, because it did seem shop related.  I suppose it
 * could also be put in the apply.c file.
 *
 * Various thoughts:
 *
 * Perhaps the location of the item relative to the menu sign should be given?
 *
 * Perhaps a better ordering/sorting of the objects could be done? (group
 * all chain armor together, and then order by magic plus value, for
 * example.)
 *
 * Tell the price of the item also?
 */

void shop_listing_more(object *op)
{
	object *tmp,*old;
	int lines = 7;
	char buf[MAX_BUF];

	tmp = op->contr->menu->inv;
        if (tmp == (object *) NULL) {
                draw_info(op, "The Shop is currently empty.");
	        op->contr->state = ST_PLAYING;	/* reset to normal state */
                return;
        }
#if 0
	draw_info(op, "");  /* add a blank line for readability */
#else
	clear_win_info(op); /* Seems more readable and faster to me.  -Frank */
#endif
	if (op->contr->state==ST_MENU_MORE)
		draw_info(op, "The Shop contains (continued):");
	else
		draw_info(op, "The Shop contains:");
	do {
		/* mark object as being paid, so that '(unpaid)' isn't
		added to the end -- By definition, an object being
		viewed in the shop listing is unpaid.
		*/
		UNSET_UNPAID(tmp);
		/* Give a little more detail on some items.
		 * After all, telling the person that there is 5
		 * rings in the shop isn't especially useful.
		 */
		switch (tmp->type) {
		    case RING:
		    case BRACERS:
		    case BOOTS:
		    case GLOVES:
		    case AMULET:
		    case GIRDLE:
			sprintf(buf,"%s %s",query_name(tmp),
				describe_item(tmp));
			draw_info(op, buf);
			break;
		    default:
			draw_info(op, query_name(tmp));
			break;
		}
		old = tmp;
		tmp = tmp->below;
		remove_ob(old);
		free_object(old);
		if (++lines>op->contr->infolines)  {
			draw_info(op,"Press any key to continue list");
			op->contr->state = ST_MENU_MORE;
			return;	/* let the routine in player.c handle the rest */
		}

	} while (tmp);
	free_object(op->contr->menu);
	op->contr->menu=NULL;	/* just in case free_object doesn't set it */
	op->contr->state = ST_PLAYING;	/* reset to normal state */
}


void shop_listing(object *op)
{
	int i,j;
	char *map_mark = (char *) calloc
	    (op->map->mapx * op->map->mapy, 1);
	object	*tmp,*stack;

	magic_mapping_mark_recursive(op, map_mark, op->x, op->y);

	if (op->contr->menu!=NULL) {
		fprintf(stderr,"Shop listing being called with non null menu point in player\n");
		return;
	}
	op->contr->menu = get_object();
	for (i=0; i<op->map->mapx; i++)
	    for (j=0; j<op->map->mapy; j++) {
		if (map_mark[i + op->map->mapx * j]) {
		    stack  =get_map_ob(op->map,i,j);
		    while (stack) {
			if (IS_UNPAID(stack)) {
				tmp = get_object();
				copy_object(stack, tmp);
				insert_ob_in_ob(tmp, op->contr->menu);
			}
			stack = stack->above;
		    }
		}
	    }
	free (map_mark);
	shop_listing_more(op);
}

#endif
