/*
 * static char *rcsid_obwin_c =
 *   "$Id: obwin.c,v 1.1.1.1 1993/03/07 08:31:08 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif

/*
 * This file contains the routines needed for having a generic
 * object-window which can display the items in a location of a
 * map, or the items inside an object.
 */

obwin *get_empty_obwin() {
#ifdef OBWIN
  obwin *o = (obwin *) malloc(sizeof(obwin));

  if(o==NULL)
    fatal(OUT_OF_MEMORY);

  o->inventory=0;
  o->x=0; o->y=0;
  o->map=NULL;
  o->ob=0;
  strcpy(o->format,"%-24.24ss%-6s");
  o->chars=30;
  o->scroll=0;
  o->last_scroll=0;
  o->nrofdrawn=0;
  o->barlength=0;
  o->size=0;
  o->scrollsize=0;
  o->scrollstart=0;
  o->faces=NULL;
  o->names=NULL;
  return o;
#else
  return NULL;
#endif
}

void resize_obwin(obwin *o,int width,int height) {
#ifdef OBWIN
  int i,chars=(width-60)/FONTWIDTH,lines=(y-FONTHEIGHT-8)/24;
  Fontindex *new_faces;
  char **new_names;
  if(o->faces!=NULL)
    free(o->faces);
  if(o->names!=NULL) {
    for(i=0;i<o->lines;i++)
      free(o->names[i]);
    free(o->names);
  }
  if(chars<10)
    chars=10;
  if(lines<2)
    lines=2;
  o->chars=chars;
  o->lines=lines;
  o->faces = (Fontindex *) malloc(sizeof(Fontindex) * lines);
  o->names = (char **) malloc(sizeof(char *) * lines);
  for(i=0;i<lines;i++)
    o->names[i] = (char *) malloc(sizeof(char) * (chars + 1));
  o->barlength=lines*24;
#endif
}

obwin *
create_obwin(player *p,int x,int y,int width,int height,int standalone,
             char *name)
{
#ifdef OBWIN
  int i;
  object *o=get_empty_obwin();
  char buf1[32],buf2[32];

  sprintf(o->format,"%%-%d.%ds%%-6s",chars-6,chars-6);
  resize_obwin(o,width,height);

  o->hint.x=x; o->hint.y=y;
  o->hint.width=width; o->hint.y=height;
  o->hint.flags=PPosition | PSize;
  o->window=XCreateSimpleWindow(
    standalone?DefaultRootWindow(p->gdisp):p->win_root,
    o->hint.x,o->hint.y,o->hint.width,o->hint.height,2,
    p->gforeground,p->gbackground);
  p->pixmap=XCreateBitmapFromData(p->gdisp,o->window,crossfire_bits,
                                  crossfire_width,crossfire_height);
  sprintf(buf1,"Crossfire - %s",name);
  sprintf(buf2,"cross%s",name);
  XSetStandardProperties(p->gdisp,o->window,buf1,buf2,p->pixmap,gargv,gargc,
                         &(o->hint));
  XSelectInput(p->gdisp,o->window,
               ButtonPressMask|KeyPressMask|KeyReleaseMask|ExposureMask|
               StructureNotifyMask);
  XMapRaised(p->gdisp,o->window);
  o->gc_text=XCreateGC(p->gdisp,o->window,0,0);
  o->gc_icon=XCreateGC(p->gdisp,o->window,0,0);
  XSetForeground(p->gdisp,o->gc_text,p->gforeground);
  XSetForeground(p->gdisp,o->gc_icon,p->gforeground);
  XSetBackground(p->gdisp,o->gc_text,p->gbackground);
  XSetBackground(p->gdisp,o->gc_icon,p->gbackground);
  p->font=XLoadFont(p->gdisp,font_inv_text); /* Will fix this in future */
  XSetFont(p->gdisp,o->gc_text,p->font);
  p->font=XLoadFont(p->gdisp,font_graphic);
  XSetFont(p->gdisp,o->gc_icon,p->font);
  return o;
#else
  return NULL;
#endif
}
