/*
 * static char *rcsid_main_c =
 *    "$Id: main.c,v 1.7 1993/04/12 18:58:04 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <version.h>
#include <global.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif
#include <main.h>
#include <object.h>
#if defined (_IBMR2) || defined (___IBMR2) /* Which is correct? */
#include <time.h>
#endif

static char days[7][4] = {
  "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};


void version(object *op) {
  if(op!=NULL)
    clear_win_info(op);
  sprintf(errmsg,"This is Crossfire v%s%s",VERSION,PATCH);
  draw_info(op,errmsg);
  draw_info(op,"Authors and contributors to this program:");
  draw_info(op,"frankj@ifi.uio.no (Frank Tore Johansen)");
  draw_info(op,"kjetilho@ifi.uio.no (Kjetil Torgrim Homme)");
  draw_info(op,"tvangod@ecst.csuchico.edu (Tyler)");
  draw_info(op,"elmroth@cd.chalmers.se (Tony Elmroth)");
  draw_info(op,"dougal.scott@fcit.monasu.edu.au (Dougal Scott)");
  draw_info(op,"wchuang@athena.mit.edu (William)");
  draw_info(op,"ftww@cs.su.oz.au (Geoff Bailey)");
  draw_info(op,"jorgens@flipper.pvv.unit.no (Kjetil Wiekhorst Jorgensen)");
  draw_info(op,"c.blackwood@rdt.monash.edu.au (Cameron Blackwood)");
  draw_info(op,"jtraub+@cmu.edu (Joseph L. Traub)");
  draw_info(op,"rgg@aaii.oz.au (Rupert G. Goldie)");
  draw_info(op,"eanders+@cmu.edu (Eric A. Anderson)");
  draw_info(op,"eneq@Prag.DoCS.UU.SE (Rickard Eneqvist)");
  draw_info(op,"Jarkko.Sonninen@lut.fi (Jarkko Sonninen)");
  draw_info(op,"kholland@sunlab.cit.cornell.du (Karl Holland)");
  draw_info(op,"vick@bern.docs.uu.se (Mikael Lundgren)");
  draw_info(op,"mol@meryl.csd.uu.se (Mikael Olsson)");
  draw_info(op,"haatanen@cc.lut.fi (Tero Haatanen)");
  draw_info(op,"ylitalo@student.docs.uu.se (Lasse Ylitalo)");
  draw_info(op,"anipa@pulmunen.cs.tut.fi (Niilo Neuvo)");
  draw_info(op,"mta@modeemi.cs.tut.fi (Markku J{rvinen)");
  draw_info(op,"master@cats.UCSC.EDU (Mark Wedel)");
  draw_info(op,"meunier@inf.enst.fr (Sylvain Meunier)");
  draw_info(op,"jfosback@darmok.uoregon.edu (Jason Fosback)");
  draw_info(op,"cedman@capitalist.princeton.edu (Carl Edman)");
  draw_info(op,"henrich@crh.cl.msu.edu (Charles Henrich)");
}

void info_keys(object *op) {
  clear_win_info(op);
  draw_info(op,"Push `hjklynub' to walk in a direction.");
  draw_info(op,"Shift + dir = fire, Ctrl + dir = run.");
  draw_info(op,"To attack, walk into the monsters.");
  draw_info(op,"\"  = speak        ' = extended command");
  draw_info(op,"i  = inventory    , = get         : = look");
  draw_info(op,"<> = rotate       d = drop        ? = help");
  draw_info(op,"a  = apply        A = apply below t = throw");
  draw_info(op,"e  = examine      E = exa below   @ = autopick");
  draw_info(op,"+- = change range [run]+<tab> = browse spells");
  draw_info(op,"C  = configure    s = brace       v = version");
#ifdef SAVE_WINDOW_POSITIONS
  draw_info(op,"X  = Toggle window position saving");
#endif /* SAVE_WINDOW_POSITIONS */
  draw_info(op,"Mouse: L = exam,  M = apply,  R = drop/get");
  draw_info(op,"'help  = info about extended commands.");
  draw_info(op,"Ctrl-R = refresh   Ctrl-C = clear.");
  draw_info(op,"You can type a number before most commands.");
  draw_info(op,"(For instance 3d drops 3 items.)");
}

void start_info(object *op) {
  char buf[MAX_BUF];

  sprintf(buf,"Welcome to Crossfire, v%s%s!",VERSION,PATCH);
  draw_info(op,buf);
  draw_info(op,"Press `?' for help");
  draw_info(op," ");
  (void) sprintf(buf,"%s entered the game.",op->name);
  info_all(buf,5);
  info_flush();
  if(!op->contr->name_changed) {
    draw_info(op,"Note that you must set your name with the name");
    draw_info(op,"command to enter the highscore list.");
    draw_info(op,"(You can also use the crossfire.name X-resource.)");
  }
}

char *crypt_string(char *str, char *salt) {
  static char *c=
    "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./";
  char s[2];
  if(salt==NULL)
    s[0]= c[RANDOM()%strlen(c)],
    s[1]= c[RANDOM()%strlen(c)];
  else
    s[0]= salt[0],
    s[1]= salt[1];
#ifdef __sun__
  return _crypt(str,s);
#else
  return ((char *) crypt(str,s));
#endif
}

int check_password(char *typed,char *crypted) {
  return !strcmp(crypt_string(typed,crypted),crypted);
}

char *normalize_path (char *src, char *dst) {
    char *p, *q;
    char buf[MAX_BUF];
    static char path[MAX_BUF];

    /* LOG(llevDebug,"path before normalization >%s<>%s<\n", src, dst); */

    if (*dst == '/') {
	strcpy (buf, dst);

    } else {
	strcpy (buf, src);
	if ((p = strrchr (buf, '/')))
	    p[1] = '\0';
	else
	    strcpy (buf, "/");
	strcat (buf, dst);
    }

    q = p = buf;
    while ((q = strstr (q, "//")))
	p = ++q;	

    *path = '\0';
    q = path;
    p = strtok (p, "/");
    while (p) {
	if (!strcmp (p, "..")) {
	    q = strrchr (path, '/');
	    if (q)
		*q = '\0';
	    else {
		*path = '\0';
		LOG (llevError, "Illegal path.\n");
	    }
	} else {
	    strcat (path, "/");
	    strcat (path, p);
	}
	p = strtok (NULL, "/");
    }
    /* LOG(llevDebug,"path after normalization >%s<\n", path); */

    return (path);
}


void enter_exit(object *op, object *exit_ob) {
  char buf[MAX_BUF];
  mapstruct *m;
    int x=0, y=0, removed=IS_REMOVED(op);
    char *newpath=NULL, *lastlevel;
  static mapstruct dummy_map;

  dummy_map.pending = (objectlink *) NULL;

    if(exit_ob) {
	x=EXIT_X(exit_ob);
	y=EXIT_Y(exit_ob);

	if (EXIT_PATH(exit_ob)) {
	    newpath = normalize_path (exit_ob->map->path, EXIT_PATH(exit_ob));
	} else {
	    if (EXIT_LEVEL (exit_ob) > 0)
		LOG(llevError,"Number Map levels are no more supported\n");
	}
	
    } else
	newpath = op->contr->maplevel;

    if(!newpath)
	newpath = op->map->path;

    op->direction=0;
    op->contr->count=0;
    op->contr->count_left=0;

  if(exit_ob!=NULL) {
    if(exit_ob->name)
      sprintf(buf,"%s enters %s.",op->name,exit_ob->name);
    else
      sprintf(buf,"%s teleports to level %s.",op->name, newpath + 1);
    info_all(buf,3);
    info_flush();
  }
    
  m=op->map;
  if(!removed) {/* When logging in, object is already removed */
    remove_ob(op);

    lastlevel = m->path;

    op->map = NULL;

    if(strcmp (newpath, m->path)) {
	if(op->contr->golem) {
      remove_friendly_object(op->contr->golem);
      remove_ob(op->contr->golem);
      free_object(op->contr->golem);
      op->contr->golem=NULL;
    }

    /* This stuff should probably be moved to ready_map: */
    op->map = &dummy_map;
    if(MAP_TIMEOUT) {
      m->timeout = MAP_TIMEOUT;
	    swap_below_max (newpath);
	    /* Swap out the oldest map if low on mem */
    } else
      swap_map(m);
    }
    m->players--;
  }
  op->map = ready_map_name(newpath,0);

  if (op->map==NULL) { /* Something went wrong, try to go back */
	LOG(llevError,"Error, couldn't open map %s.\n", newpath);
	op->map = ready_map_name (lastlevel, 0);
    if (op->map==NULL)
      fatal(MAP_ERROR);
  }
  op->map->players++;
  if(dummy_map.pending != (objectlink *) NULL) {
    objectlink *obl;
	for(obl = op->map->pending; obl!= NULL && obl->next != NULL; 
	    obl=obl->next);
    if(obl == NULL)
      op->map->pending = dummy_map.pending;
    else
      obl->next = dummy_map.pending;
  }
    
  op->contr->loading = op->map;
  op->contr->new_x = x;
  op->contr->new_y = y;
  op->contr->removed = removed;
  op->map->timeout = 0;
  if(op->map->in_memory == MAP_LOADING)
    return; /* This will block the player until map has been loaded */
  enter_map(op);
}

/*
 *  enter_map():  handles the final stages of entering a new map.
 */

void enter_map(object *op) {
  op->map = op->contr->loading;
  op->contr->loading = NULL;
  if((op->contr->new_x || op->contr->new_y) &&
     !out_of_map(op->map,op->contr->new_x,op->contr->new_y))
    op->x = op->contr->new_x, op->y = op->contr->new_y;
  else {
    int i = find_free_spot(op->arch,op->map,
                           EXIT_X(op->map->map_object),
			   EXIT_Y(op->map->map_object),1,9);
    op->x = EXIT_X(op->map->map_object) + freearr_x[i];
    op->y = EXIT_Y(op->map->map_object) + freearr_y[i];
  }
  if(!op->contr->removed) {
    SET_NO_APPLY(op);
    insert_ob_in_map(op,op->map);
    UNSET_NO_APPLY(op);
  }
#if 0
  draw_map_message(op);
#endif
  op->enemy = NULL;
  enter_pending_objects(op->map);
}

/*
 * process_active_maps(): Works like process_events(), but it only
 * processes maps which are loaded and readied.
 * It will check that it isn't called too often, and abort
 * if time since last call is less than MAX_TIME.
 */

void process_active_maps() {
  mapstruct *map;

  if(first_player==NULL || first_player->next==NULL)
    return; /* No point in the following in one-player modus */

/*
 * If enough time has elapsed, do some work.
 */
  if(enough_elapsed_time())
    for(map=first_map;map!=NULL;map=map->next)
      if(map->in_memory == MAP_IN_MEMORY) {
        if(players_on_map(map)==0)
          continue;
        process_map(map);
      }
}

/*
 * process_map(map): works like process_events(), but it only processes
 * objects within the map 'map'.
 */

void process_map(mapstruct *map) {
  int flag;
  object *op, *next;
  player *pl, *plnext;

  for(flag=1;flag!=0;) {
    flag=0;
    for(pl=first_player;pl!=NULL;pl=plnext) {
      plnext=pl->next; /* In case a player exits the game in handle_player() */
      if(pl->ob == NULL || pl->ob->map != map)
        continue;
      if(pl->ob->speed_left>0) {
        if(--(pl->ob->speed_left)>0) /* Another loop needed */
          flag=1;
        handle_player(pl->ob);
      }
    }
  }
  for(pl=first_player;pl!=NULL;pl=pl->next) {
    if(pl->ob == NULL || pl->ob->map!=map || pl->loading != NULL)
      continue;
    do_some_living(pl->ob);
    draw(pl->ob);
  }
  for(op=objects;op!=NULL;op=next) {
    if(IS_FREED(op)) { /* Was this object somehow freed as a result of */
                       /* the actions of the previous object? */ 
      flag=0;
      break;
    }
    next=op->next;

    if(op->map!=map || op->type == PLAYER)
      continue;

    if (op->last_anim>=op->anim_speed && op->anim_speed != 0) {
      animate_object(op);
      op->last_anim=1;
    } else op->last_anim++; 

    if(op->speed_left>0) {
      --op->speed_left;
      if(process_object(op))
        continue;
    }
  }
/* Now go through all objects and give them new speed */
  for(op=objects;op!=NULL;op=op->next)
    if(op->map==map&&op->speed&&op->speed_left<=0)
      op->speed_left+=op->speed>0?op->speed:-op->speed;

/* Then check if any players should use weapon-speed instead of speed */
  for(pl=first_player;pl!=NULL;pl=pl->next)
    if(pl->ob == NULL || IS_REMOVED(pl->ob))
      continue;
    else if(pl->loading != NULL) /* Player is blocked */
      pl->ob->speed_left -= pl->ob->speed;
    else if(pl->ob->map==map&&pl->has_hit)
      pl->ob->speed_left+=pl->ob->speed/pl->weapon_sp - pl->ob->speed;

/* Then synchronize the different screens to avoid jerky movement */
  if(synchronize)
    for(pl=first_player;pl!=NULL;pl=pl->next)
      XSync(pl->gdisp,False);
  else
    for(pl=first_player;pl!=NULL;pl=pl->next)
      XFlush(pl->gdisp);
}

void process_events() {
  int flag;
  object *op, *next;
  player *pl, *plnext;

  for(flag=1;flag!=0;) {
    flag=0;
    for(pl=first_player;pl!=NULL;pl=plnext) {
      plnext=pl->next; /* In case a player exits the game in handle_player() */
      if(pl->ob->speed_left>0) {
        if(--(pl->ob->speed_left)>0) /* Another loop needed */
          flag=1;
        handle_player(pl->ob);
      }
    }
  }
  for(pl=first_player;pl!=NULL;pl=pl->next) {
    do_some_living(pl->ob);
    draw(pl->ob);
  }
  for(op=objects;op!=NULL;op=next) {
    if(IS_FREED(op)) { /* Was this object somehow freed as a result of */
                       /* the actions of the previous object? */ 
      flag=0;
      break;
    }

    next=op->next;

    if (op->map == NULL && op->env == NULL && op->name &&
        strcmp(op->name, "map"))
    {
      LOG(llevError, "Object without map or inventory: %s (%d)\n",
              op->name, op->count);
      continue;
    }

    if(!op->speed)
      continue;

/* Eneq(@csd.uu.se): Handle archetype-field anim_speed differently when
   it comes to the animation. If we have a value on this we don't animate it
   at speed-events. */

    if (op->anim_speed && op->last_anim>=op->anim_speed) {
      animate_object(op);
      op->last_anim=1;
    } else op->last_anim++; 

    if(op->speed_left>0) {
      --op->speed_left;
      process_object(op);
    }

    op->speed_left+=(op->speed>0?op->speed:-op->speed);
  }

/* Then check if any players should use weapon-speed instead of speed */
  for(pl=first_player;pl!=NULL;pl=pl->next)
    if(pl->has_hit)
      pl->ob->speed_left+=pl->ob->speed/pl->weapon_sp - pl->ob->speed;

/* Then synchronize the different screens to avoid jerky movement */
  if(synchronize)
    for(pl=first_player;pl!=NULL;pl=pl->next)
      XSync(pl->gdisp,False);
  else
    for(pl=first_player;pl!=NULL;pl=pl->next)
      XFlush(pl->gdisp);
}

void clean_tmp_files() {
  mapstruct *m;
  player *pl;

  LOG(llevError,"Cleaning up...\n");
  for(pl=first_player;pl!=NULL;pl=pl->next)
    remove_lock(pl);
  for(m=first_map;m!=NULL;m=m->next)
    clean_tmp_map(m);
}

void leave(player *pl) {
  char buf[MAX_BUF];

  XSync(pl->gdisp, False);
  XFreeGC(pl->gdisp,pl->gc_game);
  XDestroyWindow(pl->gdisp,pl->win_game);
  XCloseDisplay(pl->gdisp);
  (void) sprintf(buf,"%s left the game.",pl->name);
  pl->ob->map->timeout = MAP_TIMEOUT;
  pl->ob->map->players--;
  pl->ob->map=NULL;
  pl->ob->type = DEAD_OBJECT; /* To avoid problems with inventory window */
  free_player(pl);
#ifdef SERVER
  if(server_mode != SERVER_ENABLED)
#endif
  if(first_player==NULL) { /* Last player left the game */
    clean_tmp_files();
    exit(0);
  }
  info_all(buf,5);
  info_flush();
}

int forbid_play()
{
#if !defined(_IBMR2) && !defined(___IBMR2) && defined(PERM_FILE)
    char buf[MAX_BUF], day[MAX_BUF];
    FILE *fp;
    time_t clock;
    struct tm *tm;
    int i, start, stop, forbit=0;

    clock = time (NULL);
    tm = (struct tm *) localtime (&clock);

    sprintf (buf, "%s/%s", LibDir, PERM_FILE);
    if ((fp = fopen(buf, "r")) == NULL)
	return 0;

    while (fgets (buf, MAX_BUF, fp)) {
	if (!strncmp (buf, "msg", 3)) {
	    if (forbit)
		while (fgets (buf, MAX_BUF, fp))  /* print message */
		    fputs (buf, logfile);
	    break;

	} else if (sscanf (buf, "%s %d%*c%d\n", day, &start, &stop) != 3) {
	    LOG(llevDebug,
                     "Warning: Incomplete line in permission file ignored.\n");
	    continue;
	}

	for (i=0; i< 7; i++) {
	    if (!strncmp (buf, days[i], 3) && (tm->tm_wday == i) && 
		(tm->tm_hour >= start) && (tm->tm_hour < stop))
		forbit = 1;
	}
    }

    return forbit;
#else
    return 0;
#endif
}

/*
 *  do_specials() is a collection of functions to call from time to time.
 */

int special_count = 0;

void do_specials() {
  if(++special_count < 500)
    return;
  special_count = 0;
  flush_old_maps();    /* Clears the tmp-files of maps which have reset */
  if(!(RANDOM()%5)) {
    fix_weight();        /* Hack to fix weightproblems caused by bugs */
    if (!(RANDOM()%5))
      fix_luck();
  }
}

/*
 * last_time is when the last tick was executed.
 * We don't need to know the timezone since we're only interested in
 * the delta time since the last 'tick' .
 */
struct timeval last_time;
struct timezone dummy_timezone;

int main(int argc,char **argv,char **env) {

 /*
  * Set up some global pointers, to make things easy:
  */
  gargc=argc, gargv=argv, genv=env;

  init();
  
  for(;;) {
    nroferrors = 0;
    setjmp(jump_addr);

    check_socket();      /* Check for new connections/data */
    process_events();    /* "do" something with objects with speed */
    check_active_maps(); /* Removes unused maps after a certain timeout */
    do_specials();       /* Routines called from time to time. */

    sleep_delta();
  }
}
