/*
 * static char *rcsid_init_c =
 *   "$Id: init.c,v 1.6 1993/04/22 06:04:51 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#include <loader.h>
#include <main.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif
#include <version.h>
#include <X11/keysym.h>

#define XKsTKc(xx) XKeysymToKeycode(pl->gdisp,xx)

int init_flag = 0;
int become_daemon = 0;
char *logfilename = LOGFILE;

/*
 * init() is called only once, when starting the program.
 */

void init() {
  char *di;

  init_done=0;		/* Must be done before init_signal() */
  init_library();	/* Must be called early */
  (void) umask(0);	/* We don't want to be affected by players' umask */
  SRANDOM(time(NULL));

  init_startup();	/* Write (C), check shutdown/forbid files */
  init_signals();	/* Sets up signal interceptions */
  setup_library();	/* Set up callback function pointers */
  setuperrors();	/* Sets up X11 error-handlers */
  /*init_archetypes();  If not called before, reads all archetypes from file */
 /* init_locals();*/	/* Initialize "local" global variables */

  di = (char *) getenv("DISPLAY");
  parse_args(di);

  if((!init_flag)&&di!=NULL&& server_mode != SERVER_ENABLED) {
    if(add_player(di,first_map))
      LOG(llevError,"%s\n",errmsg);
  }
  if(first_player==NULL && server_mode != SERVER_ENABLED) {
    usage();
    exit(1);
  }
  if (server_mode == SERVER_ENABLED && become_daemon)
    logfile = BecomeDaemon(logfilename);
  init_socket();
  reset_sleep();
  init_done=1;
}

void usage() {
  char *c=strrchr(gargv[0],'/');
  (void) fprintf(logfile,
                 "Usage: %s [-h] [-<flags>]... [display1] [display2]...\n",
                 (c==NULL?gargv[0]:c+1));
}

void help() {
  usage();
  printf("Flags:\n");
  printf(" -b   Black/white instead of colors.\n");
  printf(" -d   Turns on some debugging.\n");
  printf(" -f   Only Flush, don't Synchronize.\n");
  printf("      This makes the game crash if someone kills their window,\n");
  printf("      but the game won't lock if someone freezes it.  This speeds\n");
  printf("      the game up when there are several players.\n");
  printf(" -h   Display this information.\n");
  printf(" -l   Removes local player (Won't try to add player $DISPLAY).\n");
  printf(" -m   Lists out suggested experience for all monsters.\n");
  printf(" -mon Turns on monster debugging.\n");
  printf(" -o   Prints out info on what was defined at compile time.\n");
  printf(" -p   Don't try to fix the fontpath.\n");
  printf(" -pix Uses pixmaps instead of fonts.\n");
  printf(" -s   Display the high-score list.\n");
  printf(" -v   Print version and contributors.\n");
  printf(" -w   Makes split-windows default.\n");
#ifdef CHRFONT
/* Eneq(@csd.uu.se): Added -chrfont <fontname> */
  printf(" -chrfont    Followed by fontname; will replace character\n");
  printf("             rep. by that font.\n");
#endif
#ifdef SERVER
  printf(" -server     Puts crossfire into server mode.\n");
  printf(" -detatch    The server will go in the background, closing all\n");
  printf("             connections to the tty.\n");
  printf(" -log <file> Specifies which file to send output to.\n");
  printf("             Only has meaning if -detatch is specified.\n");
#endif
  exit(0);
}

void parse_flag(char *flag) {
#ifdef SERVER
  if(!strcmp(flag, "-server"))
    server_mode = SERVER_ENABLED;
  else
#endif
  if(!strcmp(flag,"-p"))
    fix_fontpath=0;
  else if(!strcmp(flag,"-pix"))
    use_pixmaps = 1;
  else if(!strcmp(flag,"-f"))
    synchronize=0;
  else if(!strcmp(flag,"-h"))
    help();
  else if(!strcmp(flag,"-v")) {
    version(NULL);
    exit(0);
  } else if(!strcmp(flag,"-s")) {
    display_high_score(NULL,9999);
    exit(0);
  } else if(!strcmp(flag,"-b"))
    no_color=1;
  else if(!strcmp(flag,"-l"))
    init_flag= -1;
  else if(!strcmp(flag,"-d"))
    debug = llevDebug;
  else if(!strcmp(flag,"-mon"))
    debug = llevMonster;
  else if(!strcmp(flag,"-o"))
    compile_info();
  else if(!strcmp(flag,"-w"))
    default_split_window=1;
  else if(!strcmp(flag,"-m"))
    dump_monsters=1;
  else if(!strcmp(flag,"-m2"))
    dump_monsters=2;
  else if(!strcmp(flag,"-detatch"))
    become_daemon=1;
  else if(!strcmp(flag,"-e")) {
    fprintf(logfile,
            "The editor has been moved into a separate program: xledit.\n");
    exit(0);
  } else {
    LOG(llevError,"Unknown flag: %s\n",flag);
    usage();
    exit(-1);
  }
}

void parse_args(char *di) {
  int i;

  for(i=1;i<gargc;i++) {
#ifdef CHRFONT
    if (!strncmp(gargv[i], "-chrfont", 8))  {
      chrfont=gargv[i+1]; /* Eneq(@csd.uu.se): Handle -chrfont <fontname> */
      i++;
    } else
#endif
    if (!strcmp(gargv[i], "-log")) {
      if (++i == gargc) {
        fprintf(logfile,"Another argument needed after -log.\n");
        exit(-1);
      }
      logfilename=gargv[i];
    } else
    if (gargv[i][0]=='-') {
      parse_flag(gargv[i]);
    } else {
      if(di!=NULL&&!strncmp(gargv[i],di,MAX_NAME))
        init_flag=1;
      init_archetypes();	/* Reads all archetypes from file */
      if(add_player(gargv[i],first_map))
        LOG(llevDebug,"%s\n",errmsg);
    }
  }
}
/*
void init_locals() {
    int i;

    strcpy(ann_last, "");
    for (i = 0; i < NROFPFACES; i++) {
	classarch[i] = find_archetype (classname [i]);
	if (!classarch[i])
	    LOG(llevError,"cannot find archetype for class %s\n", 
		classname [i]);

    }
}
*/
void init_startup() {
  char buf[MAX_BUF];
  FILE *fp;
  fprintf(logfile,
    "Welcome to CrossFire, v%s%s, copyright (C) 1992 Frank Tore Johansen.\n",
     VERSION,PATCH);
#ifdef DM_MAIL
  fprintf(logfile,"Maintained locally by: %s\n",DM_MAIL);
  fprintf(logfile,"Questions and bugs should be mailed to above address.\n");
#endif
#ifdef SHUTDOWN_FILE
  sprintf(buf,"%s/%s",LibDir,SHUTDOWN_FILE);
  if ((fp = fopen(buf,"r")) != NULL) {
    while (fgets(buf, MAX_BUF-1, fp) != NULL)
      printf("%s", buf);
    fclose(fp);
    exit(1);
  }
#endif

  if (forbid_play()) { /* Maybe showing highscore should be allowed? */
      LOG(llevError, "CrossFire: Playing not allowed.\n");
      exit(-1);
  }
}

/*
 * compile_info(): activated with the -o flag.
 * It writes out information on how Imakefile and config.h was configured
 * at compile time.
 */

void compile_info() {
  int i=0;
  printf("Non-standard include files:\n");
#if !defined (__STRICT_ANSI__) || defined (__sun__)
#if !defined (Mips)
  printf("<stdlib.h>\n");
  i=1;
#endif
#if !defined (MACH) && !defined (sony)
  printf("<malloc.h>\n");
  i=1;
#endif
#endif
#ifndef __STRICT_ANSI__
#ifndef MACH
  printf("<memory.h\n");
  i=1;
#endif
#endif
#ifndef sgi
  printf("<sys/timeb.h>\n");
  i=1;
#endif
  if(!i)
    printf("(none)\n");
#ifdef SECURE
  printf("Secure:\t\t<true>\n");
#else
  printf("Secure:\t\t<false>\n");
#endif
#ifdef NO_LOG
  printf("Logging:\t\t<false>\n");
#else
  printf("Logging:\t\t<true>\n");
#endif
  printf("Libdir:\t\t%s\n",LibDir);
#ifdef PERM_FILE
  printf("Perm file:\t<LIB>/%s\n",PERM_FILE);
#endif
#ifdef SHUTDOWN_FILE
  printf("Shutdown file:\t<LIB>/%s\n",SHUTDOWN_FILE);
#endif
#ifdef SAVE_PLAYER
  printf("Save player:\t<true>\n");
  printf("Save mode:\t%4.4o\n",SAVE_MODE);
#ifdef SAVE_HOMEDIR
  printf("Playerdir:\t%s/%s\n",(char *) getenv("HOME"),PlayerDir);
#else
  printf("Playerdir:\t<LIB>/%s\n",PlayerDir);
#endif
#else
  printf("Save player:\t<false>\n");
#endif
#ifdef SAVE_HOMEDIR
  printf("Save homedir:\t<true>\n");
#else
  printf("Save homedir:\t<false>\n");
#endif
#ifdef LOCK_PLAYER
  printf("Lock player:\t<true>\n");
#else
  printf("Lock player:\t<false>\n");
#endif
#ifdef USE_CHECKSUM
  printf("Use checksum:\t<true>\n");
#else
  printf("Use checksum:\t<false>\n");
#endif
  printf("Tmpdir:\t\t%s\n",TMPDIR);
  printf("Fontdir:\t%s\n",FontDir);
  printf("Compress:\t%s\n",COMPRESS);
  printf("Uncompress:\t%s\n",UNCOMPRESS);
  printf("Map timeout:\t%d\n",MAP_TIMEOUT);
  printf("Map reset:\t%d\n",MAP_RESET);
  printf("Max objects:\t%d\n",MAX_OBJECTS);
#ifdef USE_CALLOC
  printf("Use_calloc:\t<true>\n");
#else
  printf("Use_calloc:\t<false>\n");
#endif
#ifdef SPEED_GAME
  printf("Speed_game:\t<true>\n");
#else
  printf("Speed_game:\t<false>\n");
#endif
#ifdef USE_LOS
  printf("Use_los:\t<true>\n");
#else
  printf("Use_los:\t<false>\n");
#endif
#ifdef CD_LINE_OF_SIGHT
  printf("CD los:\t\t<true>\n");
#else
  printf("CD los:\t\t<false>\n");
#endif
#ifdef CHRFONT
  printf("CHRFONT:\t<true>\n");
#else
  printf("CHRFONT:\t<false>\n");
#endif

#ifdef USE_SWAP_STATS
  printf("Use_swap_stats:\t<true>\n");
#else
  printf("Use_swap_stats:\t<false>\n");
#endif
#ifdef DM_MAIL
  printf("DM mail:\t%s\n",DM_MAIL);
#endif
#ifdef X_EDITOR
  printf("Editor:\t\t%s\n",X_EDITOR);
#endif
#ifdef SERVER
  printf("Server:\t\t<true>\n");
  printf("Port:\t\t%d\n",PORT);
#else
  printf("Server:\t\t<false>\n");
#endif
#ifdef EXPLORE_MODE
  printf("Explore mode:\t<true>\n");
#else
  printf("Explore mode:\t<false>\n");
#endif
#ifdef SHOP_LISTINGS
  printf("Shop listings:\t<true>\n");
#else
  printf("Shop listings:\t<false>\n");
#endif
  printf("Max_time:\t%d\n",MAX_TIME);
  execl("/bin/uname", "uname", "-a", NULL);
  LOG(llevError, "Opps, should't have gotten here.");
  perror("execl");
  exit(-1);
}

void reset_keysyms(player *pl) {
  pl->keys[K_QUIT]=XKsTKc(XK_Q);
  pl->keys[K_MOVE_0]=XKsTKc(XK_period);
  pl->keys[K_MOVE_1]=XKsTKc(XK_Up);
  pl->keys[K_MOVE_2]=XKsTKc(XK_R9);
  pl->keys[K_MOVE_3]=XKsTKc(XK_Right);
  pl->keys[K_MOVE_4]=XKsTKc(XK_R15);
  pl->keys[K_MOVE_5]=XKsTKc(XK_Down);
  pl->keys[K_MOVE_6]=XKsTKc(XK_R13);
  pl->keys[K_MOVE_7]=XKsTKc(XK_Left);
  pl->keys[K_MOVE_8]=XKsTKc(XK_R7);
  pl->keys[K_FIRE]=XKsTKc(XK_Shift_L);
  pl->keys[K_FIRE2]=XKsTKc(XK_Shift_R);
  pl->keys[K_RUN]=XKsTKc(XK_Control_L);
  pl->keys[K_RUN2]=XKsTKc(XK_Control_R);
  pl->keys[K_ROTATE_RIGHT]=XKsTKc(XK_greater);
  pl->keys[K_ROTATE_LEFT]=XKsTKc(XK_less);
  pl->keys[K_SPELL_UP]=XKsTKc(XK_plus);
  pl->keys[K_SPELL_DOWN]=XKsTKc(XK_minus);
  pl->keys[K_APPLY]=XKsTKc(XK_a);
  pl->keys[K_LOOK]=XKsTKc(XK_colon);
  pl->keys[K_DROP]=XKsTKc(XK_d);
  pl->keys[K_PICKUP]=XKsTKc(XK_comma);
  pl->keys[K_PICKUP_MODE]=XKsTKc(XK_at);
  pl->keys[K_COMMAND]=XKsTKc(XK_acute);
  pl->keys[K_WRITE]=XKsTKc(XK_diaeresis);
  pl->keys[K_UNWEAR]=XKsTKc(XK_D);
  pl->keys[K_THROW]=XKsTKc(XK_t);
  pl->keys[K_EXIT]=XKsTKc(XK_x);
  pl->keys[K_WIZ]=XKsTKc(XK_W);
  pl->keys[K_WIZ_COUNT]=XKsTKc(XK_s);
  pl->keys[K_WIZ_INVIS]=XKsTKc(XK_I);
}

/* Signal handlers: */

void rec_sigsev(int i) {
  LOG(llevError,"\nSIGSEGV received.\n");
  fatal_signal(1, 1);
}

void rec_sigint(int i) {
  LOG(llevError,"\nSIGINT received.\n");
  fatal_signal(0, 1);
}

void rec_sighup(int i) {
  LOG(llevError,"\nSIGHUP received\n");
  fatal_signal(0, 1);
}

void rec_sigquit(int i) {
  LOG(llevError,"\nSIGQUIT received\n");
  fatal_signal(1, 1);
}

void rec_sigpipe(int i) {
  LOG(llevError,"\nSIGPIPE received\n");
  fatal_signal(0, 0);
}

void rec_sigbus(int i) {
#ifdef SIGBUS
  LOG(llevError,"\nSIGBUS received\n");
  fatal_signal(1, 1);
#endif
}

void rec_sigterm(int i) {
  LOG(llevError,"\nSIGTERM received\n");
  fatal_signal(0, 1);
}

void fatal_signal(int make_core, int close_sockets) {
  if(init_done) {
    emergency_save(0);
    clean_tmp_files();
    if(close_sockets)
      close_all_sockets();
  }
  if(make_core)
    abort();
  exit(0);
}

void init_signals() {
  signal(SIGHUP,rec_sighup);
  signal(SIGINT,rec_sigint);
  signal(SIGQUIT,rec_sigquit);
  signal(SIGSEGV,rec_sigsev);
  signal(SIGPIPE,rec_sigpipe);
#ifdef SIGBUS
  signal(SIGBUS,rec_sigbus);
#endif
  signal(SIGTERM,rec_sigterm);
}

/*
 * init_library: Set up the function pointers which will point
 * back from the library into the server.
 */
void setup_library() {
  set_emergency_save((void *)emergency_save);
  set_clean_tmp_files((void *)clean_tmp_files);
  set_fix_auto_apply((void *)fix_auto_apply);
  set_remove_friendly_object((void *)remove_friendly_object);
  set_process_active_maps((void *)process_active_maps);
  set_update_buttons((void *)update_buttons);
  set_draw_info((void *)draw_info);
  set_draw_stats((void *)draw_stats);
  set_draw_inventory((void *)draw_inventory);
  set_draw_look((void *)draw_look);
  set_apply((void *)apply);
  set_draw((void *)draw);
  set_monster_check_apply((void *)monster_check_apply);
  set_draw_inventory_faces((void *)draw_inventory_faces);
  set_draw_look_faces((void *)draw_look_faces);
  set_init_blocksview_players((void *)init_blocksview_players);
  set_info_map((void *)info_map);
}
