#include <global.h>
#include <graphics.h>
#include <living.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif

void save_throw_object(object *op, int type) {
  int i;
  if(op->immune&type||op->protected&type)
    return;
  if(type&AT_CANCELLATION)
    type=15;
  else if(type&AT_COLD)
    type=4;
  else if(type&AT_ELECTRICITY)
    type=3;
  else if(type&AT_FIRE)
    type=2;
  else if(type&AT_PHYSICAL)
    type=0;                     /* This was 1 before... */
  else if(type==AT_MAGIC) /* Only pure magic, not paralyze, etc */
    type=1;                     /* This was 0 before... */
  else return;
  for(i=0;i<NROFMATERIALS;i++)
    if(op->material&((2<<i)/2)) {
      int flag=0,j;
      for(j=0;j<5;j++)
        if(RANDOM()%20+1>=object_saves[type][i]-op->magic)
          flag=1;
      if(!flag) {
        int x=op->x,y=op->y;
        mapstruct *m=op->map;
        if(type==15) {          /* Cancellation. */
          cancellation(op);
          return;
        }
        while(op->inv) {
          object *tmp=op->inv;
          remove_ob(tmp);
          tmp->x=x,tmp->y=y;
          insert_ob_in_map(tmp,op->map);
        }
        if(op->nrof>1)
          decrease_ob_nr(op,RANDOM()%op->nrof);
        else {
          remove_ob(op);
          free_object(op);
        }
        if(type==2||type==3) {
          op=get_archetype("burnout");
          op->x=x,op->y=y;
          insert_ob_in_map(op,m);
        }
        return;
      }
      if(type==4&&(RANDOM()&1)) {
        object *tmp;
        archetype *at = find_archetype("icecube");
        if (at == NULL)
          return;
        if ((tmp = present_arch(at,op->map,op->x,op->y)) == NULL) {
          tmp = arch_to_object(at);
          tmp->x=op->x,tmp->y=op->y;
          insert_ob_in_map(tmp,op->map);
        }
        remove_ob(op);
        insert_ob_in_ob(op,tmp);
        return;
      }
    }
}

int hit_map(object *op,int dir,int type) {
  object *tmp,*next;

  if(out_of_map(op->map,op->x+freearr_x[dir],op->y+freearr_y[dir]))
      return 0;
  for(tmp=get_map_ob(op->map,op->x+freearr_x[dir],op->y+freearr_y[dir]);
      tmp!=NULL;tmp=next)
  {
    next=tmp->above;
    if(IS_ALIVE(tmp))
      hit_player(tmp,op->stats.dam,op,type);
    else if(tmp->material)
      save_throw_object(tmp,type);
  }
  if(tmp==NULL) return 0; /* This doesn't work, of course */
  return 1;
}

att_msg *attack_message(int dam) {
  static att_msg messages;
  static char buf1[MAX_BUF],buf2[MAX_BUF];
  if(dam==-1) {
    strcpy(buf1,"hit");
    buf2[0]='\0';
  } else if(dam==0) {
    strcpy(buf1,"missed");
    buf2[0]='\0';
  } else if(dam<3) {
    strcpy(buf1,"grazed");
    buf2[0]='\0';
  } else if(dam<6) {
    strcpy(buf1,"hit");
    buf2[0]='\0';
  } else if(dam<9) {
    strcpy(buf1,"hit");
    strcpy(buf2," hard");
  } else if(dam<12) {
    strcpy(buf1,"hit");
    strcpy(buf2," very hard");
  } else if(dam<16) {
    strcpy(buf1,"hit");
    strcpy(buf2," extremely hard");
  } else if(dam<20) {
    strcpy(buf1,"crush");
    strcpy(buf2," very hard");
  } else if(dam<25) {
    strcpy(buf1,"smash");
    strcpy(buf2," with a bonecrunching sound");
  } else if(dam<35) {
    strcpy(buf1,"grind");
    strcpy(buf2," to dust");
  } else {
    strcpy(buf1,"shred");
    strcpy(buf2," to pieces");
  }
  messages.msg1=buf1,messages.msg2=buf2;
  return &messages;
}

/*
 * attack_ob() returns 1 on a hit, and 0 on a miss.
 */

int attack_ob(object *op,object *hitter) {
  int roll,dam=0;
  char buf[MAX_BUF];
  unsigned int type,type_extra,ghosthit;
  att_msg *msg;
  char *op_name;
  signed char luck=0;

  if(op->head!=NULL)
    op=op->head;
  if(op->name==NULL) {
    if(debug) {
      dump_object(op);
      LOG(llevDebug,"Object without name tried to attack.\n%s\n",errmsg);
    }
    if(IS_REMOVED(op) && !IS_FREED(op))
      free_object(op);
    return 1;
  }
  add_refcount(op_name = op->name);
  if(hitter->head!=NULL)
    hitter=hitter->head;
  if(op->stats.luck)
    luck=RANDOM()%abs(op->stats.luck);
  if(op->stats.luck<0)
    luck= -luck;
  if((int)luck < -5)
    roll= -20;
  else
    roll=RANDOM()%20+1+luck;
  if(roll==(20+luck)||op->stats.ac>=hitter->stats.wc-roll) {
    int hitdam=hitter->stats.dam+luck;

/* Vick's (vick@bern.docs.uu.se) patch 921101 to make it
   possible to create non-hitting monsters. */
/* Originally was ..hitdam<=0....hitdam=1 */

    if (hitdam<0) hitdam=0;

    type=hitter->attacktype;
    if(!type) type=AT_PHYSICAL;
    ghosthit=type&AT_GHOSTHIT,type&=~AT_GHOSTHIT;
    if((type_extra=type&~AT_PHYSICAL)) {
      hitdam=hitdam/2+1;
      dam+=hit_player(op,RANDOM()%(hitdam)+1,hitter,
                      type_extra|ghosthit);
      if (IS_FREED(op))
        goto leave;
    }
    if(type&~type_extra) {
      if(HITBACK(op) && IS_ALIVE(hitter)) {
        if(op->attacktype&AT_ACID&&hitter->type==PLAYER)
          draw_info(hitter,"You are splashed by acid!\n");
        hit_player(hitter,RANDOM()%(op->stats.dam+1),op,op->attacktype);
        if (IS_FREED(op))
          goto leave;
      }
/* Vick's (vick@bern.docs.uu.se) patch 921101 for non-hitter critters.. */
      if (hitdam>0)
      dam+=hit_player(op,RANDOM()%(hitdam)+1,hitter,
                      (type&~type_extra)|ghosthit);
      if (IS_FREED(op))
        goto leave;
    }
  }
  msg=attack_message(dam);

  /* Did a player hurt another player?  Inform both! */
  if(op->type==PLAYER&&
     (get_owner(hitter)==NULL?hitter->type:hitter->owner->type)==PLAYER)
    {
    if(get_owner(hitter)!=NULL)
      sprintf(buf,"%s %ss you%s with %s.",
              hitter->owner->name,msg->msg1,msg->msg2,hitter->name);
    else
      sprintf(buf,"%s %ss you%s.",hitter->name,msg->msg1,msg->msg2);
    draw_info(op,buf);
  }
  if(hitter->type==PLAYER) {
    sprintf(buf,"You %s %s%s.",msg->msg1,op_name,msg->msg2);
    draw_info(hitter,buf);
  } else if(get_owner(hitter)!=NULL&&hitter->owner->type==PLAYER) {
    sprintf(buf,"You %s %s%s with %s.",
            msg->msg1,op_name,msg->msg2,hitter->name);
    draw_info(hitter->owner,buf);
  }
 leave:
  free_string(op_name);
  return dam;
}

int hit_player(object *op,int dam, object *hitter, int type) {
  char buf[MAX_BUF];

  if(op->head!=NULL) {
    if(op->head==op) {
      LOG(llevError,"Recursive head error!\n");
      return 0;
    }
    if(type&AT_PARALYZE || type&AT_SLOW)
      return 0;
    op=op->head;
  }
  if(IS_WIZ(op)||!IS_ALIVE(op)||op->stats.hp<0)
    return 0;
  if(type&AT_ACID) {
    object *tmp;
    int flag=0;
    for(tmp=op->inv;tmp!=NULL;tmp=tmp->below) {
      if(!IS_APPLIED(tmp)||tmp->immune&AT_ACID||
         (tmp->protected&AT_ACID&&RANDOM()&1))
        continue;
      if(!(tmp->material&M_IRON))
        continue;
      if(tmp->magic< -4) /* Let's stop at -5 */
        continue;
      if(tmp->type==RING||tmp->type==GLOVES||tmp->type==BOOTS||
         tmp->type==GIRDLE||tmp->type==AMULET)
        continue; /* To avoid some strange effects */
      if(RANDOM()%(dam+5)>RANDOM()%40) {
        if(op->type==PLAYER) {
          strcpy(buf,"The ");
          strcat(buf,query_name(hitter));
          strcat(buf,"'s acid corrodes your ");
          strcat(buf,query_name(tmp));
          strcat(buf,"!");
          draw_info(op,buf);
          flag=1;
        }
        tmp->magic--;
      }
    }
    if(flag) {
      draw_all_inventory(op);
      fix_player(op);
    }
  }
  if ((op->race != NULL && op->race == hitter->slaying)||
     (hitter->slaying == undead_name && UNDEAD(op)))
  {
    dam *= 3; /* Ouch 8) */
  }
  else if (op->immune&type)
  {
    int newtype = type & ~op->immune;
    /*
     * Magic is special, if immune to it, immune to everything containing it
     * Otherwise, only immune if immune to every attacktype included.
     */
    if (!newtype || (newtype == AT_MAGIC && newtype != type) || (op->immune & AT_MAGIC && type & AT_MAGIC))
      return 0;
    type = newtype;
  }
  if(type&AT_TURN_UNDEAD&&!UNDEAD(op))
    return 0;
  if(type&(AT_PARALYZE|AT_FEAR|AT_POISON|AT_CONFUSION|AT_SLOW|AT_CANCELLATION|AT_DEPLETE))
    if(!op->speed||(!IS_MONSTER(op)&&op->type!=PLAYER)||
       RANDOM()%((type&AT_SLOW)?6:3)||
       (RANDOM()%20+((op->protected&type)?5:1) >= savethrow[op->level]))
      return 0;
  UNSET_SCARED(op); /* Or the monster won't hit back */
  if(get_owner(hitter))
    op->enemy=hitter->owner;
  else
    if(IS_ALIVE(hitter))
      op->enemy=hitter;
  if(UNAGGRESSIVE(op) && op->type != PLAYER) {
    /* The unaggressives look after themselves 8) */
    UNSET_UNAGGRESSIVE(op);
    npc_call_help(op);
  }
  if(dam > 0) {
    if(op->vulnerable&type)
      dam*=2;
    if(op->protected&type)
      dam/=2;
    if(op->armour&&type&AT_PHYSICAL)
      dam=((100-op->armour)*dam)/100;
    if(dam < 1)
      dam = RANDOM()&1;
  }
  if(type&AT_POISON) {
    archetype *at = find_archetype("poisoning");
    object *tmp=present_arch_in_ob(at,op);
    if(tmp==NULL) {
      if((tmp=arch_to_object(at))==NULL)
        LOG(llevError,"Failed to clone arch poisoning.\n");
      else {
        insert_ob_in_ob(tmp,op);
        if(op->type==PLAYER) {
          tmp->stats.Con= -(dam/4+1);
          tmp->stats.Str= -(dam/3+2);
          tmp->stats.Dex= -(dam/6+1);
          tmp->stats.Int= -dam/7;
          SET_APPLIED(tmp);
          fix_player(op);
          draw_info(op,"You suddenly feel very ill.");
        }
      }
      tmp->speed_left=0;
    }
    else
      tmp->stats.food++;
    type &=~(AT_POISON|AT_MAGIC);
  }
  if(type&AT_SLOW) {
    archetype *at = find_archetype("slowness");
    object *tmp;
    if(at == NULL) {
      LOG(llevError,"Can't find slowness archetype.\n");
      return 0;
    }
    if((tmp=present_arch_in_ob(at,op)) == NULL) {
      tmp = arch_to_object(at);
      insert_ob_in_ob(tmp,op);
      draw_info(op,"The world suddenly moves very fast!");
    } else
      tmp->stats.food++;
    SET_APPLIED(tmp);
    tmp->speed_left=0;
    fix_player(op);
    type &=~(AT_SLOW|AT_MAGIC);
  }
  if(type&AT_CONFUSION) {
    object *tmp;
    tmp = present_in_ob(CONFUSION,op);
    if(!tmp) {
      tmp = get_archetype("confusion");
      insert_ob_in_ob(tmp,op);
    }
    tmp->stats.food += 5;
    if( tmp->stats.food > 20)
      tmp->stats.food = 20;
    if(op->type == PLAYER && !IS_CONFUSED(op))
      draw_info(op,"You suddenly feel very confused!");
    SET_CONFUSED(op);
    type &=~(AT_CONFUSION|AT_MAGIC);
  }
  if(type&AT_TURN_UNDEAD) {
    object *owner=get_owner(hitter)==NULL?hitter:get_owner(hitter);
    if(op->level<turn_bonus[owner->stats.Wis]+owner->level)
      SET_SCARED(op);
    if(!(type&~(AT_TURN_UNDEAD|AT_MAGIC)))
      return 0;
  }
  if(type&AT_FEAR) {
    SET_SCARED(op);
    if(!(type&~(AT_FEAR|AT_MAGIC)))
      return 0;
  }
  if(type&AT_DRAIN) {
    if(op->stats.exp==0) {
      type=type|AT_PHYSICAL;
      if(op->type==GOLEM)
        dam=999; /* It's force is "sucked" away. 8) */
      else
        dam=1;
    } else {
      if(hitter->stats.hp>hitter->stats.maxhp&&
         op->level>hitter->level&&
         RANDOM()%(op->level-hitter->level+3)>3)
        hitter->stats.hp++;
      if(!WAS_WIZ(op))
        add_exp(hitter,op->stats.exp/(50+(op->protected&type)?50:0));
      add_exp(op,-op->stats.exp/(50+(op->protected&type)?50:0));
    }
    if(hitter->type==GRIMREAPER&&hitter->value++>10) {
      remove_ob(hitter);
      free_object(hitter);
    }
    if(!(type&AT_PHYSICAL))
      return 0;
  }
  if(type&AT_PARALYZE) {
    object *tmp;
    if((tmp=present(PARAIMAGE,op->map,op->x,op->y))==NULL) {
      tmp=clone_arch(PARAIMAGE);
      tmp->x=op->x,tmp->y=op->y;
      insert_ob_in_map(tmp,op->map);
    }
    op->speed_left-=(float)FABS(op->speed)*(dam*3);
    tmp->stats.food+=(signed short) (dam*3)/op->speed;
    if(op->speed_left< -(op->speed*40)) {
      op->speed_left  = (float) -(op->speed*40);
      tmp->stats.food = (signed short) (40/op->speed);
    }
    type&=~(AT_PARALYZE|AT_MAGIC);
  }

  if(!type) /* We've done everything */
    return 0;
  if(type&AT_MAGIC && (RANDOM()%20+1)>=savethrow[op->level])
    dam=dam/2;
  op->stats.hp-=dam;

/* Eneq(@csd.uu.se): Check to see if monster runs away */

  if ((IS_MONSTER(op) || op->type == PLAYER) &&
      op->stats.hp<(signed short)(((float)op->run_away/(float)100)*
      (float)op->stats.maxhp))
    if (IS_MONSTER(op))
      SET_RUN_AWAY(op);
    else
      SET_SCARED(op);

  if(TEAR_DOWN(op)) {
    int perc=op->arch->animations
             -op->arch->animations*op->stats.hp/op->stats.maxhp;
    if(perc>=op->arch->animations)
      perc=op->arch->animations-1;
    else if(perc<1)
      perc=1;
    op->face.number=op->arch->faces[perc];
    update_object(op);
    if(perc==op->arch->animations-1) { /* Reached the last animation */
      if(op->face.number==blank_face.number) { 
	  /* If the last face is blank, remove the ob */
	  int x = op->x, y = op->y;
	  mapstruct *m = op->map;
	  remove_ob (op); /* Should update LOS */
	  free_object (op);
	  update_position (m, x, y);

      } else { /* The last face was not blank, leave an image */
        UNSET_BLOCKSVIEW(op);
        update_all_los(op->map);
        UNSET_NO_PASS(op);
        UNSET_ALIVE(op); /* Now anyone can walk through it. */
      }
      return dam;
    }
  }
  if(op->stats.hp<0) {
    object *owner=NULL;
    dam+=op->stats.hp+1;
    if(BLOCKSVIEW(op))
      update_all_los(op->map);
    if(op->type==DOOR) {
      op->speed=0.1;
      op->speed_left= -0.05;
      return dam;
    }
    if(op->type==GOLEM) {
      remove_friendly_object(op);
      if(get_owner(op)!=NULL)
        op->owner->contr->golem=NULL;
      else
        LOG(llevDebug,"Encountered golem without owner.\n");
      remove_ob(op);
      free_object(op);
      return dam;
    }
    owner=get_owner(hitter);
    if(owner==NULL)
      owner=hitter;
    if(owner->type==PLAYER&&(owner->level/2<op->level||op->stats.exp>1000)) {
      if(owner!=hitter)
        (void) sprintf(buf,"You killed %s with %s.",op->name,hitter->name);
      else
        (void) sprintf(buf,"You killed %s.",op->name);
      draw_info(owner,buf);
      if(op->type == PLAYER)
        change_luck(op, -1);
    }
    if(get_owner(hitter)!=NULL) {
      (void) sprintf(buf,"%s killed %s with %s.",hitter->owner->name,op->name,
              hitter->name);
      hitter=hitter->owner;
    }
    else
      (void) sprintf(buf,"%s killed %s.",hitter->name,op->name);
    if(hitter!=op&&!WAS_WIZ(op)) {
      int exp=op->stats.exp;
      if(hitter->level>op->level)
        exp=(exp*(op->level+1))/(hitter->level+1);
#ifdef SIMPLE_PARTY_SYSTEM
      exp=exp/2;
      if(hitter->type!=PLAYER || hitter->contr->party_number<=0)
	add_exp(hitter,exp);
      else {
	int shares=0,count=0;
	player *pl;
	int no=hitter->contr->party_number;
	for(pl=first_player;pl!=NULL;pl=pl->next)
	  if(pl->ob->contr->party_number==no)
	    {
	      count++;
	      shares+=(pl->ob->level+4);
	    }
	if(count==1 || shares>exp)
	  add_exp(hitter,exp);
	else {
	  int share=exp/shares,given=0,nexp;
	  for(pl=first_player;pl!=NULL;pl=pl->next)
	    if(pl->ob->contr->party_number==no)
	      {
		nexp=(pl->ob->level+4)*share;
		add_exp(pl->ob,nexp);
		given+=nexp;
		if(pl->ob!=hitter)
		  draw_stats(pl->ob);
	      }
	  exp-=given;
	  add_exp(hitter,exp);
	}
      }
#else /* SIMPLE_PARTY_SYSTEM */
      add_exp(hitter,exp/2);
#endif /* SIMPLE_PARTY_SYSTEM */
    }
    if(hitter->type==PLAYER)
      draw_stats(hitter);
    if(op->type!=PLAYER) {
      info_all(buf,10);
      if(IS_FRIENDLY(op)) {
        object *owner = get_owner(op);
        if(owner!= NULL && owner->type == PLAYER) {
          sprintf(buf,"Your pet, the %s, is killed by %s.",
                  op->name,hitter->name);
          draw_info(owner,buf);
        }
        remove_friendly_object(op);
      }
      remove_ob(op);
      free_object(op);
    }
    else {
      info_all(buf,1);
      if(hitter->type==PLAYER) {
        sprintf(buf,"%s the %s",hitter->name,hitter->contr->title);
        strncpy(op->contr->killer,buf,BIG_NAME);
      } else {
        strncpy(op->contr->killer,hitter->name,BIG_NAME);
        op->contr->killer[BIG_NAME-1]='\0';
      }
    }
  }
  if(type&AT_GHOSTHIT) {
    if(IS_FRIENDLY(hitter))
      remove_friendly_object(hitter);
    remove_ob(hitter);
    free_object(hitter);
  } else if(type&AT_PHYSICAL&&!IS_FREED(op)&&SPLITTING(op)) {
    int i;
    int friendly = IS_FRIENDLY(op);
    int unaggressive = UNAGGRESSIVE(op);
    object *owner = get_owner(op);
    if(!op->other_arch) {
      LOG(llevError,"SPLITTING without other_arch error.\n");
      return dam;
    }
    remove_ob(op);
    for(i=0;i<NROFNEWOBJS(op);i++) { /* This doesn't handle op->more yet */
      object *tmp=arch_to_object(op->other_arch);
      int j;
      tmp->stats.hp=op->stats.hp;
      if (friendly) {
        SET_FRIENDLY(tmp);
        add_friendly_object(tmp);
        tmp->move_type = PETMOVE;
        if (owner!=NULL)
          set_owner(tmp,owner);
      }
      if (unaggressive)
        SET_UNAGGRESSIVE(tmp);
      j=find_first_free_spot(tmp->arch,op->map,op->x,op->y);
      tmp->x=op->x+freearr_x[j],tmp->y=op->y+freearr_y[j];
      insert_ob_in_map(tmp,op->map);
    }
    if(friendly)
      remove_friendly_object(op);
    free_object(op);
  }
  if(type&AT_CANCELLATION) {
    cancellation(op);
  }
  if (type & AT_DEPLETE)
    drain_stat(op);
  return dam;
}

/*
 * Stat draining by Vick 930307
 * (Feeling evil, I made it work as well now.  -Frank 8)
 */

void drain_stat(object *op) {
  int deplete_stats;
  object *tmp;
  archetype *at;

  LOG(llevDebug, "depletion in %s.\n", op->name);

  at = find_archetype("depletion");
  if (!at) {
    LOG(llevError, "Couldn't find archetype depletion.\n");
    return;
  } else {
    tmp = present_arch_in_ob(at, op);
    if (!tmp) {
      tmp = arch_to_object(at);
      insert_ob_in_ob(tmp, op);
      SET_APPLIED(tmp);
    }
  }

  deplete_stats = RANDOM() % 6;

  switch (deplete_stats) {
  case STR:
    tmp->stats.Str--;
    draw_info(op, "Oh no! You are weakened!");
    break;
  case DEX:
    tmp->stats.Dex--;
    draw_info(op, "You're feeling slower!");
    break;
  case CON:
    tmp->stats.Con--;
    draw_info(op, "You feel less healthy");
    break;
  case WIS:
    tmp->stats.Wis--;
    draw_info(op, "You suddenly begin to lose your memory!");
    break;
  case CHA:
    tmp->stats.Cha--;
    draw_info(op, "Your face gets distorted!");
    break;
  case INT:
    tmp->stats.Int--;
    draw_info(op, "Watch out, your mind is going!");
    break;
  }
  fix_player(op);
  (void)draw_stats(op);
}

/*
 * A value of 0 indicates timeout, otherwise change the luck of the object.
 * via an applied bad_luck object.
 */

void change_luck(object *op, int value) {
  object *tmp;
  archetype *at;
  at = find_archetype("luck");
  if (!at)
    LOG(llevError, "Couldn't find archetype luck.\n");
  else {
    tmp = present_arch_in_ob(at, op);
    if (!tmp) {
      if (!value)
        return;
      tmp = arch_to_object(at);
      insert_ob_in_ob(tmp, op);
      SET_APPLIED(tmp);
    }
    if (value) {
      op->stats.luck+=value;
      tmp->stats.luck+=value;
    } else {
      if (!tmp->stats.luck) {
        LOG(llevDebug, "Internal error in change_luck().\n");
        return;
      }
      if (RANDOM()%(FABS(tmp->stats.luck)) > RANDOM()%30)
        tmp->stats.luck += tmp->stats.luck>0?-1:1;
    }
  }
}
