/*
 * static char *rcsid_define_h =
 *   "$Id: define.h,v 1.8 1993/04/22 06:04:36 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

/*
 * Crossfire requires ANSI-C, but some compilers "forget" to define it.
 * Thus the prototypes made by cextract don't get included correctly.
 */
#ifndef __STDC__
#define __STDC__ 1
#endif

/* The offsetof macro is part of ANSI C, but many compilers lack it, for
 * example "gcc -ansi"
 */
#if !defined (offsetof) && !defined(sgi)
#define offsetof(type, member) (int)&(((type *)0)->member)
#endif

/* Decstations have trouble with fabs()... */
#define FABS(x) (x<0?-x:x)

#define MAX_BUF 256	/* Used for all kinds of things */
#define VERY_BIG_BUF 1024

#define FONTSIZE 2048	/* Max chars in font */

#define MAX_ANIMATIONS 64

/* Fatal variables: */
#define OUT_OF_MEMORY		0
#define MAP_ERROR		1
#define ARCHTABLE_TOO_SMALL	2
#define TOO_MANY_ERRORS		3

#define PLAYER 1
#define BULLET 2
#define MAP 3
#define TREASURE 4
#define POTION 5
#define FOOD 6
#define POISON 7
#define BOOK 8
#define CLOCK 9
#define FBULLET 10
#define FBALL 11
#define LIGHTNING 12
#define ARROW 13
#define BOW 14
#define WEAPON 15
#define ARMOUR 16
#define PEDESTAL 17
#define ALTAR 18
#define CONFUSION 19

#define LOCKED_DOOR 20
#define SPECIAL_KEY 21

#define DOOR 23
#define KEY 24
#define MMISSILE 25

#define TIMED_GATE 26
#define TRIGGER 27

#define GRIMREAPER 28

#define MAGIC_EAR 29

#define TRIGGER_BUTTON 30
#define TRIGGER_ALTAR 31
#define TRIGGER_PEDESTAL 32

#define SHIELD 33
#define HELMET 34

#define AMULET 39
/*
#define OLD_SCROLL 40
*/
#define TELEPORTER 41
/*#define EXIT 42*/

#define EARTHWALL 45
#define GOLEM 46
#define BOMB 47

#define SPEEDBALL 52
#define DEAD_OBJECT 53
#define DRINK 54
#define GOLDCOIN 55
#define SILVERCOIN 56

#define GUARD 59
#define GEM 60 
#define FIRECHEST 61 
#define FIREWALL 62
#define SHOP 63

#define EXIT 66

#define SHOP_FLOOR 68
#define SHOP_MAT 69
#define RING 70

#define SPELLBOOK 85
#define BOLT 86

#define CONE 88

#define SPINNER 90
#define GATE 91
#define BUTTON 92
#define HANDLE 93
#define HOLE 94
#define TRAPDOOR 95
#define WORD_OF_RECALL 96
#define PARAIMAGE 97
#define SIGN 98
#define BOOTS 99
#define GLOVES 100

#define PLATINACOIN 102
#define CONVERTER 103
#define BRACERS 104
#define POISONING 105
#define SAVEBED 106
#define POISONCLOUD 107
#define FIREHOLES 108
#define WAND 109
#define ABILITY 110
#define SCROLL 111
#define DIRECTOR 112
#define GIRDLE 113
#define FORCE 114
/* Vick's (vick@bern.docs.uu.se) patch 921101 for additional monsters. */
#define BLOB 115
#define XAN 116
#define GENXAN 117
/* Vick's (vick@bern.docs.uu.se) patch 921102 for more monsters.*/
#define ACIDSPHERE 118
#define ACIDGEN 119

/* Eneq(@csd.uu.se): Id for close_container archetype. */

#define CLOSE_CON 121
#define CONTAINER 122

/* Mol(mol@meryl.csd.uu.se) Dark Elf date:921120, uses can_apply feature */
#define DARK_ELF 123
#define WEAPON_IMPROVER 124
#define MONEY_CHANGER 125

/* elmroth@cd.chalmers.se */

#define SMALL_TROLL 126
#define VAMPIRE 127
#define GENVAMPIRE 128
#define FUNGI 129
#define SPIDER 130
#define GENSPIDER 131
#define SPIDER_WEB 132
#define GIANT_BAT 133
#define SNAKE 134
#define CENTIPIDE 135
#define KILLER_BEE 136
#define GENKILLER_BEE 137
#define DEEP_SWAMP 138

#define CANCELLATION 141
/* Vick(vick@bern.docs.uu.se) DemiLich 930307 Uses depletion */
#define DEMILICH 142
/* Ylle(ylitalo@Student.DoCS.UU.SE) 930308 Uses depletion >:-) */
#define NIGHTMARE 143

/* Mark Wedel (master@cats.ucsc.edu) Shop inventories */
#define MENU 150

#define UNDO op->speed++,flag=1
#define WINUPPER (-5)
#define WINLOWER 5
#define WINLEFT (-5)
#define WINRIGHT 5
#define BARLENGTH_INV 281
#define BARLENGTH_LOOK 146
#define MAX_NAME 16
#define BIG_NAME 32
#define SIZEOFFREE 49
#define INFOLINES 36
#define INFOCHARS 50 /* Note that this is only the default */
#define FONTWIDTH 8  /* Note that this is only the default */
#define FONTHEIGHT 13
#define S_BULLET 0
#define S_FIREBALL 1
#define S_LIGHTNING 2

/*
 * Attacktypes:
 * If this ever exceeds 16, rmember to change all the short's in global.h.
 * (Already done, Vick 930307 :)
 */

#define NROFATTACKS 17

#define AT_PHYSICAL	0x00000001 /*     1 */
#define AT_MAGIC	0x00000002 /*     2 */
#define AT_FIRE		0x00000004 /*     4 */
#define AT_ELECTRICITY	0x00000008 /*     8 */
#define AT_COLD		0x00000010 /*    16 */
#define AT_CONFUSION	0x00000020 /*    32 The spell will use this one */
#define AT_ACID		0x00000040 /*    64 Things might corrode when hit */
#define AT_DRAIN	0x00000080 /*   128 */
#define AT_WEAPONMAGIC	0x00000100 /*   256 Very special, use with care */
#define AT_GHOSTHIT	0x00000200 /*   512 Attacker dissolves */
#define AT_POISON	0x00000400 /*  1024 */
#define AT_SLOW		0x00000800 /*  2048 */
#define AT_PARALYZE	0x00001000 /*  4096 */
#define AT_TURN_UNDEAD	0x00002000 /*  8192 */
#define AT_FEAR		0x00004000 /* 16384 */
#define AT_CANCELLATION 0x00008000 /* 32768 ylitalo@student.docs.uu.se */
#define AT_DEPLETE      0x00010000 /* 65536 vick@bern.docs.uu.se */

#define NROFREALSPELLS	73

#define NROFMATERIALS	8
#define M_PAPER		1
#define M_IRON		2
#define M_GLASS 	4
#define M_LEATHER	8
#define M_WOOD		16
#define M_ORGANIC	32
#define M_STONE		64
#define M_CLOTH		128

/*
 * Sometime in the future, all keys will be configurable.
 * Right now, only the arrow keys (K_MOVE) and FIRE/RUN (1/2)
 * are configuralbe (hit C)
 */
#ifndef DEFINED_KEYS
#define DEFINED_KEYS
enum key_defs {
  K_QUIT,K_MOVE_0,
  K_MOVE_1,K_MOVE_2,K_MOVE_3,K_MOVE_4,K_MOVE_5,K_MOVE_6,K_MOVE_7,K_MOVE_8,
  K_FIRE,K_FIRE2,K_RUN,K_RUN2,
  K_ROTATE_RIGHT,K_ROTATE_LEFT,K_SPELL_UP,K_SPELL_DOWN,K_APPLY,K_LOOK,
  K_DROP,K_PICKUP,K_PICKUP_MODE,K_COMMAND,K_WRITE,K_UNWEAR,K_THROW,K_EXIT,
  K_WIZ,K_WIZ_COUNT,K_WIZ_INVIS,
  NROFKEYS
};
#endif

#define NROF_T 28   /* Types of treasure to generate, used from treasure.[ch] */
#define MAX_T 20    /* Max in each list */

#define T_RANDOM 0
#define T_SHOP 1
#define T_WEAPON 2
#define T_ARMOUR 3
#define T_FOOD 4
#define T_SPECIAL 5

#define F_ALIVE		0x00000001 /* Object can fight (or be fought) */
#define F_WIZ		0x00000002 /* Object has special privilegies */
#define F_REMOVED	0x00000004 /* Object is not in any map or invenory */
#define F_FREED		0x00000008 /* Object is in the list of free objects */
#define F_WAS_WIZ	0x00000010 /* Player was once a wiz */
#define F_APPLIED	0x00000020 /* Object is ready for use by living */
#define F_UNPAID	0x00000040 /* Object hasn't been paid for yet */
#define F_AN		0x00000080 /* Name must be prepended by "an", not "a"*/
#define F_NO_PICK	0x00000100 /* Object can't be picked up */
#define F_WALK_ON	0x00000200 /* Applied when it's walked upon */
#define F_NO_PASS	0x00000400 /* Nothing can pass (wall() is true) */
#define F_ANIMATE	0x00000800 /* The object looks at archetype for faces */
#define F_SLOW_MOVE	0x00001000 /* Uses the stats.exp/1000 to slow down */
#define F_FLYING	0x00002000 /* Not affected by WALK_ON or SLOW_MOVE) */
#define F_MONSTER	0x00004000 /* Will attack players */
#define F_FRIENDLY	0x00008000 /* Will help players */
#define F_GENERATOR	0x00010000 /* Will generate type ob->stats.food */
#define F_THROWN	0x00020000 /* Will continue to fly through the air... */
#define F_AUTO_APPLY	0x00040000 /* Will be applied when created */
#define F_TREASURE	0x00080000 /* Will generate treasure when applied */
#define F_APPLY_ONCE	0x00100000 /* Will dissapear when applied */
#define F_SEE_INVISIBLE 0x00200000 /* Will see invisible player */
#define F_CAN_ROLL	0x00400000 /* Object can be rolled */
#define F_IS_TURNING	0x00800000 /* Object will turn after player */
#define F_IS_TURNABLE	0x01000000 /* Object can change face with direction */
#define F_WALK_OFF	0x02000000 /* Object is applied when left */
#define F_FLY_ON	0x04000000 /* As WALK_ON, but only with F_FLYING */
#define F_FLY_OFF	0x08000000 /* As WALK_OFF, but only with F_FLYING */
#define F_IS_USED_UP	0x10000000 /* When (--food<0) the object will exit */
#define F_IDENTIFIED	0x20000000 /* Not implemented yet */
#define F_REFLECTING	0x40000000 /* Object reflects from walls (lightning) */
#define F_CHANGING	0x80000000 /* Changes to other_arch when anim is done*/
#define F_SPLITTING	0x00000001	/* Object splits into stats.food other objs */
#define F_HITBACK	0x00000002 /* Object will hit back when hit */
#define F_STARTEQUIP	0x00000004 /* Object was given to player at start */
#define F_BLOCKSVIEW	0x00000008 /* Object blocks view */

#define F_UNDEAD	0x00000020 /* Monster is undead */
#define F_SCARED	0x00000040 /* Monster is scared (mb player in future)*/
#define F_UNAGGRESSIVE	0x00000080 /* Monster doesn't attack players */
#define F_REFL_MISSILE	0x00000100 /* Arrows will reflect from object */
#define F_REFL_SPELL	0x00000200 /* Spells (some) will reflect from object */
#define F_NO_MAGIC	0x00000400 /* Spells (some) can't pass this object */
#define F_NO_FIX_PLAYER	0x00000800 /* fix_player() won't be called */
#define F_NEED_IE	0x00001000 /* 1 ruby -> 2 rubies */
#define F_TEAR_DOWN	0x00002000 /* at->faces[hp*animations/maxhp] at hit */
#define F_RUN_AWAY	0x00004000 /* Object runs away from nearest player \
				      but can still attack at a distance */
#define F_PASS_THRU	0x00008000 /* Objects with can_pass_thru can pass \
				      thru this object as if it wasn't there */
#define F_CAN_PASS_THRU	0x00010000 /* Can pass thru... */
#define F_PICK_UP	0x00020000 /* Can pick up */
#define F_CONTAINER	0x00040000 /* Can hold items */
#define F_NO_DROP	0x00080000 /* Object can't be dropped */
#define F_NO_PRETEXT	0x00100000 /* No text is added before name. */
#define F_CAST_SPELL	0x00200000 /* (Monster) can learn and cast spells */
#define F_USE_SCROLL	0x00400000 /* (Monster) can read scroll */
#define F_USE_WAND	0x00800000 /* (Monster) can apply and use wands */
#define F_USE_BOW	0x01000000 /* (Monster) can apply and fire bows */
#define F_USE_ARMOUR	0x02000000 /* (Monster) can wear armour/shield/helmet */
#define F_USE_WEAPON	0x04000000 /* (Monster) can wield weapons */
#define F_USE_RING	0x08000000 /* (Monster) can use rings, boots, gauntlets, etc */
#define F_READY_WAND	0x10000000 /* (Monster) has a wand readied... 8) */
#define F_READY_BOW	0x20000000 /* not implemented yet */
#define F_XRAYS		0x40000000 /* X-ray vision */
#define F_NO_APPLY	0x80000000 /* Avoids step_on/fly_on to this object */
#define F_IS_FLOOR	0x00000001 /* Can't see what's underneath this object */
#define F_LIFESAVE	0x00000002 /* Saves a players' life once, then destr. */
#define F_NO_STRENGTH	0x00000004 /* Strength-bonus not added to wc/dam */
#define F_SLEEP		0x00000008 /* NPC is sleeping */
#define F_STAND_STILL	0x00000010 /* NPC will not (ever) move */
#define F_RANDOM_MOVE	0x00000020 /* NPC will move randomly */
#define F_ONLY_ATTACK	0x00000040 /* NPC will evaporate if there is no enemy */
#define F_CONFUSED	0x00000080 /* Will also be unable to cast spells */
#define F_STEALTH	0x00000100 /* Will wake monsters with less range */
#define F_WIZPASS	0x00000200 /* The wizard can go through walls */
#define F_IS_LINKED	0x00000400 /* The object is linked with other objects */

/* flags in Face */
#define P_BLOCKSVIEW   0x00000001
#define P_NO_MAGIC	0x00000002 /* Spells (some) can't pass this object */
#define P_NO_PASS	0x00000004 /* Nothing can pass (wall() is true) */
#define P_PASS_THRU	0x00000008 /* */
#define P_IS_ALIVE	0x00000010 /* */

#define NROFNEWOBJS(xyz)	((xyz)->stats.food)

#define SLOW_PENALTY(xyz)	((xyz)->stats.exp)/1000.0
#define SET_SLOW_PENALTY(xyz,fl)	(xyz)->stats.exp=(fl)*1000
#define SET_GENERATE_TYPE(xyz,va)	(xyz)->stats.sp=(va)
#define GENERATE_TYPE(xyz)	((xyz)->stats.sp)
#define GENERATE_SPEED(xyz)	((xyz)->stats.maxsp) /* if(!RANDOM()%<speed>) */

#define IS_ALIVE(xyz)		((xyz)->flags&F_ALIVE)
#define IS_WIZ(xyz)		((xyz)->flags&F_WIZ)
#define IS_REMOVED(xyz)		((xyz)->flags&F_REMOVED)
#define IS_FREED(xyz)		((xyz)->flags&F_FREED)
#define WAS_WIZ(xyz)		((xyz)->flags&F_WAS_WIZ)
#define IS_APPLIED(xyz)		((xyz)->flags&F_APPLIED)
#define IS_UNPAID(xyz)		((xyz)->flags&F_UNPAID)
#define NEED_AN(xyz)		((xyz)->flags&F_AN)
#define NO_PICK(xyz)		((xyz)->flags&F_NO_PICK)
#define WALK_ON(xyz)		((xyz)->flags&F_WALK_ON)
#define NO_PASS(xyz)		((xyz)->flags&F_NO_PASS)
#define ANIMATED(xyz)		((xyz)->flags&F_ANIMATE)
#define SLOW_MOVE(xyz)		((xyz)->flags&F_SLOW_MOVE)
#define IS_FLYING(xyz)		((xyz)->flags&F_FLYING)
#define IS_MONSTER(xyz)		((xyz)->flags&F_MONSTER)
#define IS_FRIENDLY(xyz)	((xyz)->flags&F_FRIENDLY)
#define IS_GENERATOR(xyz)	((xyz)->flags&F_GENERATOR)
#define IS_THROWN(xyz)		((xyz)->flags&F_THROWN)
#define AUTO_APPLY(xyz)		((xyz)->flags&F_AUTO_APPLY)
#define IS_TREASURE(xyz)	((xyz)->flags&F_TREASURE)
#define APPLY_ONCE(xyz)		((xyz)->flags&F_APPLY_ONCE)
#define SEE_INVISIBLE(xyz)	((xyz)->flags&F_SEE_INVISIBLE)
#define CAN_ROLL(xyz)		((xyz)->flags&F_CAN_ROLL)
#define IS_TURNING(xyz)		((xyz)->flags&F_IS_TURNING)
#define IS_TURNABLE(xyz)	((xyz)->flags&F_IS_TURNABLE)
#define WALK_OFF(xyz)		((xyz)->flags&F_WALK_OFF)
#define FLY_ON(xyz)		((xyz)->flags&F_FLY_ON)
#define FLY_OFF(xyz)		((xyz)->flags&F_FLY_OFF)
#define IS_USED_UP(xyz)		((xyz)->flags&F_IS_USED_UP)
#define IDENTIFIED(xyz)		((xyz)->flags&F_IDENTIFIED)
#define REFLECTING(xyz)		((xyz)->flags&F_REFLECTING)
#define CHANGING(xyz)		((xyz)->flags&F_CHANGING)
#define SPLITTING(xyz)		((xyz)->flags2&F_SPLITTING)
#define HITBACK(xyz)		((xyz)->flags2&F_HITBACK)
#define STARTEQUIP(xyz)		((xyz)->flags2&F_STARTEQUIP)
#define BLOCKSVIEW(xyz)		((xyz)->flags2&F_BLOCKSVIEW)
#define UNDEAD(xyz)		((xyz)->flags2&F_UNDEAD)
#define SCARED(xyz)		((xyz)->flags2&F_SCARED)
#define UNAGGRESSIVE(xyz)	((xyz)->flags2&F_UNAGGRESSIVE)
#define REFL_MISSILE(xyz)	((xyz)->flags2&F_REFL_MISSILE)
#define REFL_SPELL(xyz)		((xyz)->flags2&F_REFL_SPELL)
#define NO_MAGIC(xyz)		((xyz)->flags2&F_NO_MAGIC)
#define NO_FIX_PLAYER(xyz)	((xyz)->flags2&F_NO_FIX_PLAYER)
#define NEED_IE(xyz)		((xyz)->flags2&F_NEED_IE)
#define TEAR_DOWN(xyz)		((xyz)->flags2&F_TEAR_DOWN)
#define PASS_THRU(xyz)		((xyz)->flags2&F_PASS_THRU)
#define CAN_PASS_THRU(xyz)	((xyz)->flags2&F_CAN_PASS_THRU)
#define RUN_AWAY(xyz)		((xyz)->flags2&F_RUN_AWAY)
#define PICKUP(xyz)           ((xyz)->flags2&F_PICK_UP)
#define IS_CONTAINER(xyz)     ((xyz)->flags2&F_CONTAINER)
#define NO_DROP(xyz)          ((xyz)->flags2&F_NO_DROP)
#define NO_PRETEXT(xyz)               ((xyz)->flags2&F_NO_PRETEXT)
#define CAN_CAST_SPELL(xyz)	((xyz)->flags2&F_CAST_SPELL)
#define CAN_USE_SCROLL(xyz)	((xyz)->flags2&F_USE_SCROLL)
#define CAN_USE_WAND(xyz)	((xyz)->flags2&F_USE_WAND)
#define CAN_USE_BOW(xyz)	((xyz)->flags2&F_USE_BOW)
#define CAN_USE_ARMOUR(xyz)	((xyz)->flags2&F_USE_ARMOUR)
#define CAN_USE_WEAPON(xyz)	((xyz)->flags2&F_USE_WEAPON)
#define CAN_USE_RING(xyz)	((xyz)->flags2&F_USE_RING)
#define HAS_READY_WAND(xyz)	((xyz)->flags2&F_READY_WAND)
#define HAS_READY_BOW(xyz)	((xyz)->flags2&F_READY_BOW)
#define XRAYS(xyz)		((xyz)->flags2&F_XRAYS)
#define NO_APPLY(xyz)		((xyz)->flags2&F_NO_APPLY)
#define IS_FLOOR(xyz)		((xyz)->flags3&F_IS_FLOOR)
#define LIFESAVE(xyz)		((xyz)->flags3&F_LIFESAVE)
#define NO_STRENGTH(xyz)	((xyz)->flags3&F_NO_STRENGTH)
#define SLEEP(xyz)		((xyz)->flags3&F_SLEEP)
#define STAND_STILL(xyz)	((xyz)->flags3&F_STAND_STILL)
#define RANDOM_MOVE(xyz)	((xyz)->flags3&F_RANDOM_MOVE)
#define ONLY_ATTACK(xyz)	((xyz)->flags3&F_ONLY_ATTACK)
#define IS_CONFUSED(xyz)	((xyz)->flags3&F_CONFUSED)
#define STEALTH(xyz)		((xyz)->flags3&F_STEALTH)
#define WIZPASS(xyz)		((xyz)->flags3&F_WIZPASS)
#define IS_LINKED(xyz)		((xyz)->flags3&F_IS_LINKED)

#define SET_ALIVE(xyz)		((xyz)->flags|=F_ALIVE)
#define UNSET_ALIVE(xyz)	((xyz)->flags&=~F_ALIVE)
#define SET_WIZ(xyz)		((xyz)->flags|=(F_WIZ|F_WAS_WIZ),(xyz)->flags3|=F_WIZPASS)
#define SET_WAS_WIZ(xyz)	((xyz)->flags|=F_WAS_WIZ)
#define SET_ONLY_WIZ(xyz)	((xyz)->flags|=F_WIZ)
#define UNSET_WIZ(xyz)		((xyz)->flags&=~F_WIZ,(xyz)->flags3&=~F_WIZPASS)
#define SET_REMOVED(xyz)	((xyz)->flags|=F_REMOVED)
#define UNSET_REMOVED(xyz)	((xyz)->flags&=~F_REMOVED)
#define SET_FREED(xyz) 		((xyz)->flags|=F_FREED)
#define UNSET_FREED(xyz)	((xyz)->flags&=~F_FREED)
#define SET_APPLIED(xyz)	((xyz)->flags|=F_APPLIED)
#define UNSET_APPLIED(xyz)	((xyz)->flags&=~F_APPLIED)
#define SET_UNPAID(xyz)		((xyz)->flags|=F_UNPAID)
#define UNSET_UNPAID(xyz)	((xyz)->flags&=~F_UNPAID)
#define SET_AN(xyz)		((xyz)->flags|=F_AN)
#define UNSET_AN(xyz)		((xyz)->flags&=~F_AN)
#define SET_NO_PICK(xyz)	((xyz)->flags|=F_NO_PICK)
#define UNSET_NO_PICK(xyz)	((xyz)->flags&=~F_NO_PICK)
#define SET_WALK_ON(xyz)	((xyz)->flags|=F_WALK_ON)
#define UNSET_WALK_ON(xyz)	((xyz)->flags&=~F_WALK_ON)
#define SET_NO_PASS(xyz)	((xyz)->flags|=F_NO_PASS)
#define UNSET_NO_PASS(xyz)	((xyz)->flags&=~F_NO_PASS)
#define SET_ANIMATE(xyz)	((xyz)->flags|=F_ANIMATE)
#define UNSET_ANIMATE(xyz)	((xyz)->flags&=~F_ANIMATE)
#define SET_SLOW_MOVE(xyz)	((xyz)->flags|=F_SLOW_MOVE)
#define UNSET_SLOW_MOVE(xyz)	((xyz)->flags&=~F_SLOW_MOVE)
#define SET_FLY(xyz)		((xyz)->flags|=F_FLYING)
#define UNSET_FLY(xyz)		((xyz)->flags&=~F_FLYING)
#define SET_MONSTER(xyz)	((xyz)->flags|=F_MONSTER)
#define UNSET_MONSTER(xyz)	((xyz)->flags&=~F_MONSTER)
#define SET_FRIENDLY(xyz)	((xyz)->flags|=F_FRIENDLY)
#define UNSET_FRIENDLY(xyz)	((xyz)->flags&=~F_FRIENDLY)
#define SET_GENERATOR(xyz)	((xyz)->flags|=F_GENERATOR)
#define UNSET_GENERATOR(xyz)	((xyz)->flags&=~F_GENERATOR)
#define SET_THROWN(xyz)		((xyz)->flags|=F_THROWN)
#define UNSET_THROWN(xyz)	((xyz)->flags&=~F_THROWN)
#define SET_AUTO_APPLY(xyz)	((xyz)->flags|=F_AUTO_APPLY)
#define UNSET_AUTO_APPLY(xyz)	((xyz)->flags&=~F_AUTO_APPLY)
#define SET_TREASURE(xyz)	((xyz)->flags|=F_TREASURE)
#define UNSET_TREASURE(xyz)	((xyz)->flags&=~F_TREASURE)
#define SET_APPLY_ONCE(xyz)	((xyz)->flags|=F_APPLY_ONCE)
#define UNSET_APPLY_ONCE(xyz)	((xyz)->flags&=~F_APPLY_ONCE)
#define SET_SEE_INVISIBLE(xyz)	((xyz)->flags|=F_SEE_INVISIBLE)
#define UNSET_SEE_INVISIBLE(xyz)	((xyz)->flags&=~F_SEE_INVISIBLE)
#define SET_CAN_ROLL(xyz)	((xyz)->flags|=F_CAN_ROLL)
#define UNSET_CAN_ROLL(xyz)	((xyz)->flags&=~F_CAN_ROLL)
#define SET_IS_TURNING(xyz)	((xyz)->flags|=F_IS_TURNING)
#define UNSET_IS_TURNING(xyz)	((xyz)->flags&=~F_IS_TURNING)
#define SET_IS_TURNABLE(xyz)	((xyz)->flags|=F_IS_TURNABLE)
#define UNSET_IS_TURNABLE(xyz)	((xyz)->flags&=~F_IS_TURNABLE)
#define SET_WALK_OFF(xyz)	((xyz)->flags|=F_WALK_OFF)
#define UNSET_WALK_OFF(xyz)	((xyz)->flags&=~F_WALK_OFF)
#define SET_FLY_ON(xyz)		((xyz)->flags|=F_FLY_ON)
#define UNSET_FLY_ON(xyz)	((xyz)->flags&=~F_FLY_ON)
#define SET_FLY_OFF(xyz)	((xyz)->flags|=F_FLY_OFF)
#define UNSET_FLY_OFF(xyz)	((xyz)->flags&=~F_FLY_OFF)
#define SET_IS_USED_UP(xyz)	((xyz)->flags|=F_IS_USED_UP)
#define UNSET_IS_USED_UP(xyz)	((xyz)->flags&=~F_IS_USED_UP)
#define SET_IDENTIFIED(xyz)	((xyz)->flags|=F_IDENTIFIED)
#define UNSET_IDENTIFIED(xyz)	((xyz)->flags&=~F_IDENTIFIED)
#define SET_REFLECTING(xyz)	((xyz)->flags|=F_REFLECTING)
#define UNSET_REFLECTING(xyz)	((xyz)->flags&=~F_REFLECTING)
#define SET_CHANGING(xyz)	((xyz)->flags|=F_CHANGING)
#define UNSET_CHANGING(xyz)	((xyz)->flags&=~F_CHANGING)
#define SET_SPLITTING(xyz)	((xyz)->flags2|=F_SPLITTING)
#define UNSET_SPLITTING(xyz)	((xyz)->flags2&=~F_SPLITTING)
#define SET_HITBACK(xyz)	((xyz)->flags2|=F_HITBACK)
#define UNSET_HITBACK(xyz)	((xyz)->flags2&=~F_HITBACK)
#define SET_STARTEQUIP(xyz)	((xyz)->flags2|=F_STARTEQUIP)
#define UNSET_STARTEQUIP(xyz)	((xyz)->flags&=~F_STARTEQUIP)
#define SET_BLOCKSVIEW(xyz)	((xyz)->flags2|=F_BLOCKSVIEW)
#define UNSET_BLOCKSVIEW(xyz)	((xyz)->flags2&=~F_BLOCKSVIEW)
#define SET_UNDEAD(xyz)		((xyz)->flags2|=F_UNDEAD)
#define UNSET_UNDEAD(xyz)	((xyz)->flags2&=~F_UNDEAD)
#define SET_SCARED(xyz)		((xyz)->flags2|=F_SCARED)
#define UNSET_SCARED(xyz)	((xyz)->flags2&=~F_SCARED)
#define SET_UNAGGRESSIVE(xyz)	((xyz)->flags2|=F_UNAGGRESSIVE)
#define UNSET_UNAGGRESSIVE(xyz)	((xyz)->flags2&=~F_UNAGGRESSIVE)
#define SET_REFL_MISSILE(xyz)	((xyz)->flags2|=F_REFL_MISSILE)
#define UNSET_REFL_MISSILE(xyz)	((xyz)->flags2&=~F_REFL_MISSILE)
#define SET_REFL_SPELL(xyz)	((xyz)->flags2|=F_REFL_SPELL)
#define UNSET_REFL_SPELL(xyz)	((xyz)->flags2&=~F_REFL_SPELL)
#define SET_NO_MAGIC(xyz)	((xyz)->flags2|=F_NO_MAGIC)
#define UNSET_NO_MAGIC(xyz)	((xyz)->flags2&=~F_NO_MAGIC)
#define SET_NO_FIX_PLAYER(xyz)	((xyz)->flags2|=F_NO_FIX_PLAYER)
#define UNSET_NO_FIX_PLAYER(xyz)	((xyz)->flags2&=~F_NO_FIX_PLAYER)
#define SET_IE(xyz)		((xyz)->flags2|=F_NEED_IE)
#define UNSET_IE(xyz)		((xyz)->flags2&=~F_NEED_IE)
#define SET_TEAR_DOWN(xyz)	((xyz)->flags2|=F_TEAR_DOWN)
#define UNSET_TEAR_DOWN(xyz)	((xyz)->flags2&=~F_TEAR_DOWN)
#define SET_PASS_THRU(xyz)	((xyz)->flags2|=F_PASS_THRU)
#define UNSET_PASS_THRU(xyz)	((xyz)->flags2&=~F_PASS_THRU)
#define SET_CAN_PASS_THRU(xyz)	((xyz)->flags2|=F_CAN_PASS_THRU)
#define UNSET_CAN_PASS_THRU(xyz)	((xyz)->flags2&=~F_CAN_PASS_THRU)
#define SET_RUN_AWAY(xyz)	((xyz)->flags2|=F_RUN_AWAY)
#define UNSET_RUN_AWAY(xyz)	((xyz)->flags2&=~F_RUN_AWAY)
#define SET_PICKUP(xyz)               ((xyz)->flags2|=F_PICK_UP)
#define UNSET_PICKUP(xyz)	((xyz)->flags2&=~F_PICK_UP)
#define SET_CONTAINER(xyz)	((xyz)->flags2|=F_CONTAINER)
#define UNSET_CONTAINER(xyz)	((xyz)->flags2&=~F_CONTAINER)
#define SET_NO_DROP(xyz)	((xyz)->flags2|=F_NO_DROP)
#define UNSET_NO_DROP(xyz)	((xyz)->flags2&=~F_NO_DROP)
#define SET_NO_PRETEXT(xyz)	((xyz)->flags2|=F_NO_PRETEXT)
#define UNSET_NO_PRETEXT(xyz)	((xyz)->flags2&=~F_NO_PRETEXT)
#define SET_CAST_SPELL(xyz)	((xyz)->flags2|=F_CAST_SPELL)
#define UNSET_CAST_SPELL(xyz)	((xyz)->flags2&=~F_CAST_SPELL)
#define SET_USE_SCROLL(xyz)	((xyz)->flags2|=F_USE_SCROLL)
#define UNSET_USE_SCROLL(xyz)	((xyz)->flags2&=~F_USE_SCROLL)
#define SET_USE_WAND(xyz)	((xyz)->flags2|=F_USE_WAND)
#define UNSET_USE_WAND(xyz)	((xyz)->flags2&=~F_USE_WAND)
#define SET_USE_BOW(xyz)	((xyz)->flags2|=F_USE_BOW)
#define UNSET_USE_BOW(xyz)	((xyz)->flags2&=~F_USE_BOW)
#define SET_USE_ARMOUR(xyz)	((xyz)->flags2|=F_USE_ARMOUR)
#define UNSET_USE_ARMOUR(xyz)	((xyz)->flags2&=~F_USE_ARMOUR)
#define SET_USE_WEAPON(xyz)	((xyz)->flags2|=F_USE_WEAPON)
#define UNSET_USE_WEAPON(xyz)	((xyz)->flags2&=~F_USE_WEAPON)
#define SET_USE_RING(xyz)	((xyz)->flags2|=F_USE_RING)
#define UNSET_USE_RING(xyz)	((xyz)->flags2&=~F_USE_RING)
#define SET_READY_WAND(xyz)	((xyz)->flags2|=F_READY_WAND)
#define UNSET_READY_WAND(xyz)	((xyz)->flags2&=~F_READY_WAND)
#define SET_READY_BOW(xyz)	((xyz)->flags2|=F_READY_BOW)
#define UNSET_READY_BOW(xyz)	((xyz)->flags2&=~F_READY_BOW)
#define SET_XRAYS(xyz)		((xyz)->flags2|=F_XRAYS)
#define UNSET_XRAYS(xyz)	((xyz)->flags2&=~F_XRAYS)
#define SET_NO_APPLY(xyz)	((xyz)->flags2|=F_NO_APPLY)
#define UNSET_NO_APPLY(xyz)	((xyz)->flags2&=~F_NO_APPLY)
#define SET_IS_FLOOR(xyz)	((xyz)->flags3|=F_IS_FLOOR)
#define UNSET_IS_FLOOR(xyz)	((xyz)->flags3&=~F_IS_FLOOR)
#define SET_LIFESAVE(xyz)	((xyz)->flags3|=F_LIFESAVE)
#define UNSET_LIFESAVE(xyz)	((xyz)->flags3&=~F_LIFESAVE)
#define SET_NO_STRENGTH(xyz)	((xyz)->flags3|=F_NO_STRENGTH)
#define UNSET_NO_STRENGTH(xyz)	((xyz)->flags3&=~F_NO_STRENGTH)
#define SET_SLEEP(xyz)		((xyz)->flags3|=F_SLEEP)
#define UNSET_SLEEP(xyz)	((xyz)->flags3&=~F_SLEEP)
#define SET_STAND_STILL(xyz)	((xyz)->flags3|=F_STAND_STILL)
#define UNSET_STAND_STILL(xyz)	((xyz)->flags3&=~F_STAND_STILL)
#define SET_RANDOM_MOVE(xyz)	((xyz)->flags3|=F_RANDOM_MOVE)
#define UNSET_RANDOM_MOVE(xyz)	((xyz)->flags3&=~F_RANDOM_MOVE)
#define SET_ONLY_ATTACK(xyz)	((xyz)->flags3|=F_ONLY_ATTACK)
#define UNSET_ONLY_ATTACK(xyz)	((xyz)->flags3&=~F_ONLY_ATTACK)
#define SET_CONFUSED(xyz)	((xyz)->flags3|=F_CONFUSED)
#define UNSET_CONFUSED(xyz)	((xyz)->flags3&=~F_CONFUSED)
#define SET_STEALTH(xyz)	((xyz)->flags3|=F_STEALTH)
#define UNSET_STEALTH(xyz)	((xyz)->flags3&=~F_STEALTH)
#define SET_WIZPASS(xyz)	((xyz)->flags3|=F_WIZPASS)
#define UNSET_WIZPASS(xyz)	((xyz)->flags3&=~F_WIZPASS)
#define SET_IS_LINKED(xyz)	((xyz)->flags3|=F_IS_LINKED)
#define UNSET_IS_LINKED(xyz)	((xyz)->flags3&=~F_IS_LINKED)

/* Note: These values are only a default value, resizing can change them */
#define INV_SIZE	12	/* How many items can be viewed in inventory */
#define LOOK_SIZE	6	/* ditto, but for the look-winwow */
#define MAX_INV_SIZE	40	/* For initializing arrays */
#define MAX_LOOK_SIZE	40	/* ditto for the look-window */

#define EDITABLE(xyz)		((xyz)->arch->editable)

#define E_MONSTER		0x00000001
#define E_EXIT			0x00000002
#define E_TREASURE		0x00000004
#define E_BACKGROUND		0x00000008
#define E_DOOR			0x00000010
#define E_SPECIAL		0x00000020
#define E_SHOP			0x00000040
#define E_NORMAL		0x00000080
#define E_FALSE_WALL		0x00000100
#define E_WALL			0x00000200
#define E_EQUIPMENT		0x00000400
#define E_OTHER			0x00000800
#define E_ARTIFACT		0x00001000

#define EXIT_PATH(xyz)	(xyz)->slaying
#define EXIT_LEVEL(xyz) (xyz)->stats.food
#define EXIT_X(xyz)     (xyz)->stats.hp
#define EXIT_Y(xyz)     (xyz)->stats.sp

#define F_BUY 0
#define F_SELL 1
#define F_TRUE 2	/* True value of item, unadjusted */

#define DIRX(xyz)	freearr_x[(xyz)->direction]
#define DIRY(xyz)	freearr_y[(xyz)->direction]

#define D_LOCK(xyz)	(xyz)->contr->freeze_inv=(xyz)->contr->freeze_look=1;
#define D_UNLOCK(xyz)	(xyz)->contr->freeze_inv=(xyz)->contr->freeze_look=0;

#define ARMOUR_SPEED(xyz)	(xyz)->last_sp
#define ARMOUR_SPELLS(xyz)	(xyz)->last_heal
#define WEAPON_SPEED(xyz)	(xyz)->last_sp

#define STR 0
#define DEX 1
#define CON 2
#define WIS 3
#define CHA 4
#define INT 5

/* Mol(mol@meryl.csd.uu.se) 921121 Patch to get players back to a predefined
   position when an emergency save occurs.
 */
#define EMERGENCY_MAPLEVEL 4 /* the village */
#define EMERGENCY_MAPPATH "/map.04"
#define EMERGENCY_X 5 
#define EMERGENCY_Y 12

#ifndef NUMDIRBUTTS
#define NUMDIRBUTTS 9
#define NW_button 0
#define NO_button 1
#define NE_button 2
#define WE_button 3
#define BR_button 4
#define EA_button 5
#define SW_button 6
#define SO_button 7
#define SE_button 8
#define NUMOPBUTTS 4
#define CHANGE_button 0
#define APPLY_button 1
#define PEACE_button 2
#define TALK_button 3
#endif

#define MAP_IN_MEMORY 1
#define MAP_SWAPPED 2
#define MAP_LOADING 3

/*
 * Check nrof variable *before* calling CAN_MERGE()
 * stats.sp is used in wands, spellbooks and scrolls.
 */


#define CAN_MERGE(ob1,ob2) \
  ((ob1) != (ob2) && \
   (ob1)->type == (ob2)->type && \
   ((ob1)->speed == (ob2)->speed) && \
   (ANIMATED((ob1)) || FABS((ob1)->speed) < 0.001 ) && \
   (ob1)->arch == (ob2)->arch && \
   (ob1)->stats.sp == (ob2)->stats.sp && \
   (ob1)->flags == (ob2)->flags && \
   (ob1)->flags2 == (ob2)->flags2 && \
   (ob1)->flags3 == (ob2)->flags3 && \
   (ob1)->magic == (ob2)->magic && \
   (ob1)->name == (ob2)->name && \
   (ob1)->msg == (ob2)->msg)

/*
 * Flags to generate_treasures():
 */

#define GT_INVENTORY	0
#define GT_ENVIRONMENT	1
#define GT_INVISIBLE	2

/******************************************************************************/
/* Monster Movements added by kholland@sunlab.cit.cornell.edu                 */
/******************************************************************************/
/* if your monsters start acting wierd, mail me                               */
/******************************************************************************/
/* the following definitions are for the attack_movement variable in monsters */
/* if the attack_variable movement is left out of the monster archetype, or is*/
/* set to zero                                                                */
/* the standard mode of movement from previous versions of crossfire will be  */
/* used. the upper four bits of movement data are not in effect when the monst*/
/* er has an enemy. these should only be used for non agressive monsters.     */
/* to program a monsters movement add the attack movement numbers to the movem*/
/* ment numbers example a monster that moves in a circle until attacked and   */
/* then attacks from a distance:                                              */
/*                                                      CIRCLE1 = 32          */
/*                                              +       DISTATT = 1           */
/*                                      -------------------                   */
/*                      attack_movement = 33                                  */
/******************************************************************************/
#define DISTATT  1 /* move toward a player if far, but mantain some space,  */
                   /* attack from a distance - good for missile users only  */
#define RUNATT   2 /* run but attack if player catches up to object         */
#define HITRUN   3 /* run to then hit player then run away cyclicly         */
#define WAITATT  4 /* wait for player to approach then hit, move if hit     */
#define RUSH     5 /* Rush toward player blindly, similiar to dumb monster  */
#define ALLRUN   6 /* always run never attack good for sim. of weak player  */
#define DISTHIT  7 /* attack from a distance if hit as recommended by Frank */
#define WAIT2    8 /* monster does not try to move towards player if far    */
                   /* maintains comfortable distance                        */
#define PETMOVE 16 /* if the upper four bits of move_type / attack_movement */
                   /* are set to this number, the monster follows a player  */
                   /* until the owner calls it back or off                  */
                   /* player followed denoted by 0b->owner                  */
                   /* the monster will try to attack whatever the player is */
                   /* attacking, and will continue to do so until the owner */
                   /* calls off the monster - a key command will be         */
                   /* inserted to do so                                     */
#define CIRCLE1 32 /* if the upper four bits of move_type / attack_movement */
                   /* are set to this number, the monster will move in a    */
                   /* circle until it is attacked, or the enemy field is    */
                   /* set, this is good for non-aggressive monsters and NPC */ 
#define CIRCLE2 48 /* same as above but a larger circle is used             */
#define PACEH   64 /* The Monster will pace back and forth until attacked   */
                   /* this is HORIZONTAL movement                           */
#define PACEH2  80 /* the monster will pace as above but the length of the  */
                   /* pace area is longer and the monster stops before      */
                   /* changing directions                                   */
                   /* this is HORIZONTAL movement                           */
#define RANDO   96 /* the monster will go in a random direction until       */
                   /* it is stopped by an obstacle, then it chooses another */
                   /* direction.                                            */
#define RANDO2 112 /* constantly move in a different random direction       */
#define PACEV  128 /* The Monster will pace back and forth until attacked   */
                   /* this is VERTICAL movement                             */
#define PACEV2 144 /* the monster will pace as above but the length of the  */
                   /* pace area is longer and the monster stops before      */
                   /* changing directions                                   */
                   /* this is VERTICAL movement                             */
#define LO4     15 /* bitmasks for upper and lower 4 bits from 8 bit fields */
#define HI4    240

/*
 * Use of the global variable "server_mode":
 */

#define SERVER_OFF	0
#define SERVER_ENABLED	1
#define SERVER_ABORTED	2
#define SERVER_DISABLED	3

/*
 * Use of the state-variable in player objects:
 */

#define ST_PLAYING      0
#define ST_PLAY_AGAIN   1
#define ST_ROLL_STAT    2
#define ST_CHANGE_CLASS 3
#define ST_CONFIRM_QUIT 4
#define ST_CONFIGURE    5
#define ST_GET_NAME     6
#define ST_GET_PASSWORD 7
#define ST_CONFIRM_PASSWORD     8
#define ST_MENU_MORE	9

#define BLANK_FACE_NAME "blank.111"
#define BLOCKED_FACE_NAME "blocked.111"
#define STIPPLE1_FACE_NAME "blank.111"
#define STIPPLE2_FACE_NAME "blank.111"
 
