/*
 * static char *rcsid_config_h =
 *   "$Id: config.h,v 1.7 1993/04/22 06:04:35 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

/* SHOP_LISTINGS allows you to get a quick listing of what the shop has
 * in stock (unfortunately, it is still up to you to find the item.)
 * To get the listing, a 'menu' sign must be in the store, and then
 * must be A)pplied.
 * Mark Wedel (master@cats.ucsc.edu)
 */

#define SHOP_LISTINGS

/* if EXPLORE_MODE is defined, it allows players to enter explore mode,
 * where they can not die.  Unlike other games (nethack for instance) explore
 * modes, the only thing Crossfire explore mode does is prevent death.
 * Characters in explore mode will not be able to go on the scoreboard.  Also,
 * once explore mode is entered, there is no return.  Explore mode can
 * only be entered if the person doing so is the only player in the
 * game, and once done, that person can not add new players to the
 * game.  To get into explore mode, type 'explore
 * Explore mode code added by Mark Wedel (master@cats.ucsc.edu)
 * It's a good idea to turn of EXPLORE_MODE if you will only be running
 * one server, since it would block new players.
 */

/* #define EXPLORE_MODE */

/****************************************************************************/
/* Patch: NOT_PERMADEATH                Author: Charles Henrich             */
/* Email: henrich@crh.cl.msu.edu        Date  : April 9, 1993               */
/*                                                                          */
/* Purpose: This patch changes death from being a permanent, very painful   */
/*          thing, to a painful, but survivable thing.  More mudlike in     */
/*          nature.  With this patch defined, when a player dies, they will */
/*          permanently lose one point off of a random stat, as well as     */
/*          losing 20% of their experience points.  Then they are whisked   */
/*          to the start map.  Although this sounds very nice here, it is   */
/*          still REAL painful to die, 20% of a million is alot!            */
/*                                                                          */
/****************************************************************************/
/* Note from Frank: This really makes the game easier, and takes away
 * a lot of the nerve, but people have different tastes...
 * Default game is leaving it undefined
 */

/* #define NOT_PERMADEATH */

/*
 * Enables the 'search command; a method to find equipment
 * in shops.
 */

#define SEARCH_ITEMS

/*
 * If SECURE is defined, crossfire will not accept enviromental variables
 * as changes to the LIBDIR and other defines pointing to specific
 * directories.
 */

#define SECURE 

/*
 * SERVER:
 * Leave this in if you want the magic server stuff.  eanders@cmu.edu
 * It is now also able to accept new players via socket without
 * the -server switch.
 * LOGFILE specifies which file to log to when playing with the
 * -server option as well.
 */

#define SERVER
#ifdef SERVER
#define PORT 13326 /* Crossfire => 1cfe => 13326 (huh?) CrossFirE :)*/
#endif
#ifndef LOGFILE
#define LOGFILE "/tmp/cross.log"
#endif

/*
 *            The mighty Dungeon Master password.
 *
 * Change this if you want to have your personal DM password.
 * Added 16.12.92 by Kjetil W. J{\o}rgensen, jorgens@pvv.unit.no
 */
#ifndef DM_PASSWD
#define	DM_PASSWD	"nopw"
#endif
#define DM_FILE "/tmp/xyz" /* Experimental? */

/*
 * Where to send error-reports.  If you're hacking at the source, define
 * this as your mail-address.
 */

#ifndef DM_MAIL
/* #define DM_MAIL "frankj@ifi.uio.no" */
#endif

/*
 * If undefined, malloc is always used.
 * There is still a calloc() call in player.c which is not affected by this
 * definition due to a bug which hasn't been found yet.
 */
/* #define USE_CALLOC */

/*
 * This define exchanges some functions with macros.  If defined, a lot less
 * error-checking will be done, and the game will speed up, but it might crash
 * more often.
 * Unfortunately there are still bugs involved in defining SPEED_GAME.
 * If the game crashes often, you can try to undefine it.
 */

/*#define SPEED_GAME*/

/*
 * LOS means Line Of Sight.  If defined, players can't see through walls.
 * That adds a lot to the game, especially if you have claustrophobia 8)
 * It will be the standard from this version and the future, especially since
 * spells like magic mapping, listen, wizard-eye and clairvoiance will
 * mean little if it is not defined.
 * I expect to speed up the routine in the future.  For now, if crossfire is
 * very slow, you can try to undefine it.
 */

#define USE_LOS

/*
 * If you define CD_LINE_OF_SIGHT, your "sight" becomes better...
 * You can even see around some corners... 8)
 * If USE_LOS isn't defined, this will have no effect.
 * If crossfire is very slow, you can try to undefine it.
 */

#define CD_LINE_OF_SIGHT

/*
 * SWAP_STATS is fixed now - rgg.
 *
 * Swap stats allows players to swap the values for their stats around
 * in the "Roll again" phase of the character selection.  This should
 * hopefully make character selection quicker, allowing for quicker
 * game start ups. 
 * Bugs:    c.blackwood@rdt.monash.edu.au
 */ 

#define	USE_SWAP_STATS

/*
 * CHRFONT (Character-Font), if defined, enables the player to draw
 * themselves in their own font and include this in the game.
 * It is, as default, disabled, since it slows the game down.
 * Especially when you have a black/white screen, it slows the
 * game down heavily.
 * It also doesn't work with pixmaps (yet)
 */

#undef	CHRFONT

/*
 * You can restrict playing in certain times by creating a PERMIT_FILE
 * in LIBDIR. here is a sample:
 * -----
Mon 8-12
Mon 13-16
Tue 8-16
Wed 8-16
Thu 8-16
Fri 8-12
msg
Playing is forbidden during working hours.
 * -----
 * Unfortunately IBMR2 isn't supported by PERM_FILE yet.
 */

#ifndef _IBMR2
#define PERM_FILE "forbid"
#endif

/*
 * random() is much better than rand().  If you have random(), use it instead.
 */

#if defined (sgi) || defined (hpux) || defined(linux)
#define RANDOM() rand()
#define SRANDOM(xyz) srand(xyz)
#else
#if defined(SYSV) || defined(SVR4)
#define RANDOM() lrand48()
#define SRANDOM(xyz) srand48(xyz)
#else
#define RANDOM() random()
#define SRANDOM(xyz) srandom(xyz)
#endif
#endif

/*
 * If you feel the game is too fast or too slow, change MAX_TIME.
 * You can experiment with the 'speed <new_max_time> command first.
 * The length of a tick is MAX_TIME microseconds.  During a tick,
 * players, monsters, or items with speed 1 can do one thing.
 */

#define MAX_TIME	120000	/* How slow the game will go */

/*
 * MAP_TIMEOUT tells how many ticks until a map is swapped out
 * after a player has left it.  If it is set to 0, maps are
 * swapped out the instant the last player leaves it.
 * If you are low on memory, you should set this to 0.
 */

#define MAP_TIMEOUT	100	/* How many ticks till maps are swapped out */

/*
 * MAP_RESET is checked when a map which is swapped out is requested.
 * If it is MAP_RESET minutes since it was last reset, it will be reset again.
 * If it is set to 0, maps will never reset.
 * If you are low on space on the TMPDIR device, set this to something small.
 */

#define MAP_RESET	7200	/* How many seconds between resets */

/*
 * MAX_OBJECTS is no hard limit.  If this limit is exceeded, crossfire
 * will look for maps which are already scheldued for swapping, and
 * promptly swap them out before new maps are being loaded.
 */

#define MAX_OBJECTS	6000

/*
 * You must change LIBDIR to where you want your maps, highscore and
 * archetype file to be.  It's enough to change it in the Imakefile though.
 * The other files will be put in LIBDIR/MAPDIR, LIBDIR/PLAYERDIR, etc.
 * Remember to create the directory and move the needed files there.
 */

#ifndef LIBDIR
#define LIBDIR "/net/surukuku/wrk/hevi/crossfire/lib"
#endif

/*
 * If you want the players to be able to save their characters between
 * games, define SAVE_PLAYER and set PLAYERDIR to the directories
 * where the player-files will be put.
 * Remember to create the directory (make install might do that though).
 * (In the future it should be possible by a define to say that save-files
 * should be kept in each players' directory, though this isn't completely
 * in the spirit of the game (it's multiplayer))
 * If SAVE_HOMEDIR is defined, the players will be saved in the homedir
 * of the _invoking_ player instead of in LIBDIR/PLAYERDIR.
 * If LOCK_PLAYER is defined, a player will be unable to enter more
 * than one game of crossfire at the same time (stops some possible cheating).
 * If you intend to run a central server, and not allow the players to
 * start their own crossfire, you won't need to define this.
 * If USE_CHECKSUM is defined, a checksum will be calculated each time
 * a player saves a character.
 * If ENABLE_CHECKSUM is defined, the players will get the cheat-flag set
 * if the checksums don't match.  If your player-files don't have checksums,
 * you'll want to leave "USE_CHECKSUM" defined for a while so they all
 * get checksums, and then define "ENABLE_CHECKSUM" to utilize this.
 */

#define SAVE_PLAYER

#ifdef SAVE_PLAYER /* The following have no meaning without SAVE_PLAYER */
/* #define SAVE_HOMEDIR */
/* #define LOCK_PLAYER */
#define USE_CHECKSUM
/* #define ENABLE_CHECKSUM */ /* Will be default in distant future versions */
#endif

#ifndef PLAYERDIR
#define PLAYERDIR "players"
#endif

/*
 * If you have defined SAVE_PLAYER, you might want to change this, too.
 * This is the access rights for the players savefiles.
 * I think it is usefull to restrict access to the savefiles for the
 * game admin. So if you make crossfire set-uid, use 0600.
 * If you are running the game set-gid (to a games-group, for instance),
 * you must remember to make it writeable for the group (ie 0660).
 * Kjetil W. J{\o}rgensen, jorgens@pvv.unit.no
 * (Note: something should probably be done with lock-file permission)
 */
#ifdef SAVE_PLAYER
#define	SAVE_MODE	0660
#endif


/*
 * Make it possible for the players to define their own color.
 * (only of interest for color displays)
 * NOTE: This is very likely to consume a lot of cpu, thus it is
 * by default undefined.
 */

#define PLAYER_COLORS 

/*
 * Define if you want to see spell-point usage in the cast command (Anipa).
 */

#define SHOW_SP_USAGE

/*
 * Define the following if you wish to allow players to set their title
 * and to save it on the disk (if SAVE_PLAYER is defined).
 */

#define SET_TITLE

/*
 * Allow players to save their window postions with the 'X' command.
 * This only works in split window mode. If you have trouble with your
 * window manager when restoring saved positions (the windows shift
 * around slightly) try:
 * #define FUNNY_WINDOW_MANAGER
 * This bug seems to happen when using tvtwm (this has been tested to
 * work correctly on olvwm and mwm).
 */

#define SAVE_WINDOW_POSITIONS

/*
 * How often (in seconds) the player is saved if he drops things. Define
 * it to 0 to save every time (this is the way it used to be).
 */

#define SAVE_INTERVAL 5

/*
 * The following is only interesting if you run crossfire seteuid-flagged.
 * XOpenDisplay may want to read the .Xauthority file of the person who
 * runs the program. This can only be allowed if the system allows free
 * changing of the uid back and forth between invocation time uid
 * and the setuid uid. Otherwise we can't change euid back to suid after
 * setting it to invoking uid to read the xauth file. So far, only
 * POSIX-compatible systems and System-V derivates allow a process to
 * reset to a previous uid.
 * If this flag is left undefined, crossfire will not set uid back to
 * that of the invoking process while opening the first display connection.
 * In this case, you'll have to do xhost +machine before running crossfire,
 * 'machine' being the machine you run the program on.
 *    //magnuz@cd.chalmers.se
 */
/* #define HAVE_SAVE_UID */
#if (defined(hpux) || defined(sysv)) && !defined(HAVE_SAVE_UID)
#  define HAVE_SAVE_UID
#endif

/*
 * If you want to have a Message Of The Day file, define MOTD to be
 * the file with the message.  If the file doesn't exist or if it
 * is empty, no message will be displayed.
 * (It resides in the LIBDIR directory)
 */

#ifndef MOTD
#define MOTD "motd"
#endif

/*
 * If you want to take the game down while installing new versions, or
 * for other reasons, put a message into the SHUTDOWN_FILE file.
 * Remember to delete it when you open the game again.
 * (It resides in the LIBDIR directory)
 */

#ifndef SHUTDOWN_FILE
#define SHUTDOWN_FILE "shutdown"
#endif

/*
 * Your tmp-directory should be large enough to hold the uncompressed
 * map-files for all who are playing.
 * It ought to be locally mounted, since the function used to generate
 * unique temporary filenames isn't guaranteed to work over NFS or AFS
 */

#define TMPDIR "/tmp"

/*
 * This doesn't work yet, leave NO_LOG commented away.
 * If you want to save ram, and want absolutely _no_ output from the
 * game, even if something went very wrong, you can define NO_LOG.
 * If your system doesn't understand ANSI-C var-args, you can try
 * to define this to make it compile.
 */

/* #define NO_LOG */

/*
 * If you compress your files to save space, please define at least uncompress
 * If you change to gzip, change COMPRESS_SUFFIX to ".z".
 */

#ifndef COMPRESS_SUFFIX
#define COMPRESS_SUFFIX ".Z"
#endif
/* #define COMPRESS <whatever> */
/* #define UNCOMPRESS <whatever> */

#ifndef COMPRESS
#  if defined (linux) || defined(SVR4)
#    define COMPRESS	"/usr/bin/compress"
#  else
#    if defined(sgi)
#      define COMPRESS	"/usr/bsd/compress"
#    else
#      if defined(ultrix) || defined(BSD) || defined(_BSD)
#        define COMPRESS	"/usr/ucb/compress"
#      else
#        define COMPRESS	"/local/bin/compress"
#      endif
#    endif
#  endif
#endif
#ifndef UNCOMPRESS
#  if defined (linux) || defined(SVR4)
#    define UNCOMPRESS	"/usr/bin/uncompress"
#  else
#    if defined(sgi)
#      define UNCOMPRESS	"/usr/bsd/uncompress"
#    else
#      if defined(ultrix) || defined(BSD) || defined(_BSD)
#        define UNCOMPRESS	"/usr/ucb/uncompress"
#      else
#        define UNCOMPRESS	"/local/bin/uncompress"
#      endif
#    endif
#  endif
#endif

/*
 *  It shouldn't be neccessary to change the following constants, but you
 *  are free at have a look at them 8)
 */

/*
 * These defines tells where, relative to LIBDIR, the maps, the map-index,
 * archetypes highscore and treaures files and directories can be found.
 */

#define MAPDIR		"maps"
#define MAPINDEX	"mapindex"
#define ARCHETYPES	"archetypes"
#define HIGHSCORE	"highscore"
#define TREASURES	"treasures"

#define DEBUG_TIME		/* Enable the 'time command, and it's logs */
#define MAX_ERRORS	25	/* Bail out if more are received during tick */
#define NROFPUSHKEYS	32	/* How many programable push-keys there are */

#define STARTMAX        500     /* How big array of objects to start with */
#define OBJ_EXPAND      100     /* How big steps to use when expanding array */

#define HIGHSCORE_LENGTH 100	/* How many entries there are room for */

#define ARCHTABLE 2023		/* Used when hashing archetypes */
#define MAXSTRING 20

#define CHECK_ACTIVE_MAPS 50	/* See restore_map() */

#ifndef DEBUG
/* #define DEBUG */		/* You don't really want to define DEBUG... */
#endif

#define MAXMAPS		500

/*
 * 16-bit fonts.  Nowadays it's needed.  XDrawImageString16() should be
 * supported even by X11R3.
 */
#define TWO_BYTES_FONT

/*
 * Things which will be removed in the extremely near future is placed
 * below here.
 */

/*
 * X_EDITOR: set this to any editor you might wish to use
 * to edit object-messages in the map-editor.
 * Remember that the editor is required to open its own window.
 * 
 * NOTE: This no longer has any effect since the old editor has been
 * removed.  Good riddance 8)
 */

#ifndef X_EDITOR
#define X_EDITOR "/local/X11R5/bin/xterm -geometry 80x24+0+0 -e /usr/ucb/vi"
#endif

/*
 * The following is only interesting if you run crossfire seteuid-flagged.
 * If you do, you may want to prevent the general user from going about
 * editing the maps freely. If LET_ANYONE_EDIT is defined, anyone can invoke
 * the editor. If not, you can optionally define ALLOWFILE to be the name of
 * a file to reside in LIBDIR, in which you put the usernames of those who
 * are allowed to edit. You can define ALLOWER to be the email address of a
 * person (you) whom the denied user can talk to to get included in the
 * permission file. If you don't define ALLOWFILE, the editor will start
 * only if euid is equal to uid at invocation time (started by owner).
 *  //magnuz@cd.chalmers.se
 */
#undef LET_ANYONE_EDIT
#ifndef LET_ANYONE_EDIT
#  define ALLOWFILE "allowed2edit"
#  ifdef ALLOWFILE
#    define ALLOWER "frankj@ifi.uio.no"
#  endif
#endif

/* for suns with acc */

#if defined (sun) && !defined(__GNUC__)
#define FineSun 
#endif
