#ifndef _Attr_h
#define _Attr_h

#include <Defines.h>
#include <Cnv.h>


/**********************************************************************/

/*** variables, index ***/
#define I_Path      0
#define I_X         1
#define I_Y         2
#define I_Weight    3
#define I_Connect   4
#define I_Hp        5
#define I_Trigger   6
#define I_Sacrifice 7
#define I_Count     8
#define I_Lockcode  9
#define I_Direction 10
#define I_Rotation  11
#define I_Width     12
#define I_Height    13
#define I_Stacking  14
#define I_Overwrite 15
#define I_Choose    16  
#define I_ReadOnly  17


typedef void (*AttrFunc)(object *, char *, XtPointer);

typedef struct {
    String label;
    AttrFunc getValue;
    AttrFunc putValue;
} AttrDef;

typedef struct {
    Widget cont;
    Widget value;
} AttrTags;

struct _Attr {
    struct _Attr *attr;
    App app;
    Widget w;                /* not used */
    unsigned long flags;     /* editor-type T_<> */
    int attrnumber;
    object *op;              /* object to edit */
    Edit client;
    Widget shell;            /* popup-shell */
    struct {
	Widget name;         /* text */
	Widget msg;          /* command */
	Widget inv;          /* command */
	Widget exact;        /* for dumbing object data */
	Widget face;         /* face of object */
	Widget vars;         /* to get list of variables; command */
	Widget var;          /* variable name of object; text */
	Widget value;        /* value of variable; text */
    } iw;
    struct {
	Widget shell;
	Widget list;
    } vars;
    AttrTags *tags;
    AttrDef *desc;
    Boolean isup;            /* is window popped up  */
    Boolean modified;        /* should not used */
    CnvBrowse dump;          /* showing window for dump_object */  
};

/*
 * macro inteface
 */
#define AttrGetObject(self) (self->op)
#define AttrIsup(self)      (self->isup)
#define AttrSetIsup(self,b) {self->isup = b;}

/*
 * function inteface
 */
extern Attr AttrCreate ( char *name, App app, object *ob, 
			AttrDef *desc, unsigned long flags, Edit);
extern void AttrChange ( Attr self, object *ob, unsigned long flags, Edit);
extern void AttrDestroy ( Attr self );
extern void AttrApply ( Attr self );

extern int GetType (object *tmp);

extern AttrDef AttrDescription[];

#endif /* _Attr_h */
