/*
 * static char *rcsid_tempnam_c =
 *   "$Id: tempnam.c,v 1.3 1993/04/22 06:00:13 frankj Exp $";
 */

#if defined (MACH) || defined(vax) || defined(ibm032) || defined(NeXT)
#ifdef NeXT
#undef BSD
#endif
#include <sys/param.h>
#include <stdio.h>
#if !defined(vax) && !defined(ibm032) && !defined (NeXT)
#include <stdlib.h>
#include <unistd.h>
#endif

static unsigned int curtmp = 0;

/*
 * A replacement for the tempnam() function since it's not defined
 * at some unix variants.
 */

char *tempnam(char *dir, char *pfx)
{
  char *f, *name;

  if (!(name = (char *) malloc(MAXPATHLEN)))
    return(NULL);

  if (!pfx)
    pfx = "tmp.";

  if (f = (char *) getenv("TMPDIR")) {
#if !defined(MACH)
    (void)sprintf(name,"%s/%s%d", f, pfx, curtmp);
#else
    (void)snprintf(name, MAXPATHLEN, "%s/%s%d", f, pfx, curtmp);
#endif
    curtmp++;
    return(name);
  }
  if (f = (char *)dir) {
#if !defined(MACH)
    (void)sprintf(name,"%s/%s%d", f, pfx, curtmp);
#else
    (void)snprintf(name, MAXPATHLEN, "%s/%s%d", f, pfx, curtmp);
#endif
    curtmp++;
    return(name);
  }
  return(NULL);
}
#endif
