/*
 * static char *rcsid_item_c =
 *   "$Id: $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#include <funcpoint.h>
#include <living.h>

/*
 * Returns a pointer to a static buffer which contains a
 * description of the given object.
 * If it is a monster, lots of information about its abilities
 * will be returned.
 * If it is an item, lots of information about which abilities
 * will be gained about its user will be returned.
 * If it is a player, it writes out the current abilities
 * of the player, which is usually gained by the items applied.
 */

char *describe_item(object *op) {
  char buf[MAX_BUF];
  static char retbuf[VERY_BIG_BUF];

  retbuf[0]='\0';
  if(IS_MONSTER(op)) {
    if(FABS(op->speed)>0.01) {
      switch((int)((FABS(op->speed))*15)) {
      case 0:
        strcat(retbuf,"(very slow movement)");
        break;
      case 1:
        strcat(retbuf,"(slow movement)");
        break;
      case 2:
        strcat(retbuf,"(normal movement)");
        break;
      case 3:
      case 4:
        strcat(retbuf,"(fast movement)");
        break;
      case 5:
      case 6:
        strcat(retbuf,"(very fast movement)");
        break;
      case 7:
      case 8:
      case 9:
      case 10:
        strcat(retbuf,"(extremely fast movement)");
        break;
      default:
        strcat(retbuf,"(lightning fast movement)");
        break;
      }
    }
  }
  if(op->type!=PLAYER && !IS_MONSTER(op)) {
    if(op->stats.Str) {
      sprintf(buf,"(Str%+d)",op->stats.Str);
      strcat(retbuf,buf);
    }
    if(op->stats.Int) {
      sprintf(buf,"(Int%+d)",op->stats.Int);
      strcat(retbuf,buf);
    }
    if(op->stats.Dex) {
      sprintf(buf,"(Dex%+d)",op->stats.Dex);
      strcat(retbuf,buf);
    }
    if(op->stats.Con) {
      sprintf(buf,"(Con%+d)",op->stats.Con);
      strcat(retbuf,buf);
    }
    if(op->stats.Wis) {
      sprintf(buf,"(Wis%+d)",op->stats.Wis);
      strcat(retbuf,buf);
    }
    if(op->stats.Cha) {
      sprintf(buf,"(Cha%+d)",op->stats.Cha);
      strcat(retbuf,buf);
    }
    if(op->stats.wc) {
      sprintf(buf,"(wc%+d)",op->stats.wc);
      strcat(retbuf,buf);
    }
    if(op->stats.dam) {
      sprintf(buf,"(dam%+d)",op->stats.dam);
      strcat(retbuf,buf);
    }
    if(op->stats.ac) {
      sprintf(buf,"(ac%+d)",op->stats.ac);
      strcat(retbuf,buf);
    }
    if(op->stats.food) {
      if(op->stats.food>0)
        sprintf(buf,"(sustenance%+d)",op->stats.food);
      else
        sprintf(buf,"(hunger%+d)",op->stats.food);
      strcat(retbuf,buf);
    }
    if(op->stats.sp&&op->type!=BOW&&op->type!=WEAPON) {
      sprintf(buf,"(magic%+d)",op->stats.sp);
      strcat(retbuf,buf);
    }
    if(op->stats.hp) {
      sprintf(buf,"(regeneration%+d)",op->stats.hp);
      strcat(retbuf,buf);
    }
    if(op->stats.exp) {
      sprintf(buf,"(speed %+d)",op->stats.exp);
      strcat(retbuf,buf);
    }
  } else if(op->type == PLAYER) {
    if(op->contr->digestion) {
      if(op->contr->digestion>0)
        sprintf(buf,"(sustenance%+d)",op->contr->digestion);
      else
        sprintf(buf,"(hunger%+d)",op->contr->digestion);
      strcat(retbuf,buf);
    }
    if(op->contr->gen_sp) {
      sprintf(buf,"(magic%+d)",op->contr->gen_sp);
      strcat(retbuf,buf);
    }
    if(op->contr->gen_hp) {
      sprintf(buf,"(regeneration%+d)",op->contr->gen_hp);
      strcat(retbuf,buf);
    }
  }
  if(op->armour) {
    sprintf(buf,"(armour%+d)",op->armour);
    strcat(retbuf,buf);
  }
  if(op->stats.luck) {
    sprintf(buf,"(luck%+d)",op->stats.luck);
    strcat(retbuf,buf);
  }
  if(op->vulnerable&AT_PHYSICAL)
    strcat(retbuf,"(vulnerable physical)");
  if(op->protected&AT_PHYSICAL)
    strcat(retbuf,"(prot physical)");
  if(op->immune&AT_PHYSICAL)
    strcat(retbuf,"(immune physical)");

  if(op->vulnerable&AT_MAGIC)
    strcat(retbuf,"(vulnerable magic)");
  if(op->protected&AT_MAGIC)
    strcat(retbuf,"(prot magic)");
  if(op->immune&AT_MAGIC)
    strcat(retbuf,"(immune magic)");

  if(op->vulnerable&AT_ELECTRICITY)
    strcat(retbuf,"(vulnerable electricity)");
  if(op->protected&AT_ELECTRICITY)
    strcat(retbuf,"(prot electricity)");
  if(op->immune&AT_ELECTRICITY)
    strcat(retbuf,"(immune electricity)");

  if(op->vulnerable&AT_PARALYZE)
    strcat(retbuf,"(vulnerable paralyze)");
  if(op->protected&AT_PARALYZE)
    strcat(retbuf,"(protected paralyze)");
  if(op->immune&AT_PARALYZE)
    strcat(retbuf,"(free action)");

  if(op->vulnerable&AT_DRAIN)
    strcat(retbuf,"(vulnerable drain)");
  if(op->protected&AT_DRAIN)
    strcat(retbuf,"(prot drain)");
  if(op->immune&AT_DRAIN)
    strcat(retbuf,"(immune drain)");

  if(op->vulnerable&AT_SLOW)
    strcat(retbuf,"(vulnerable slow)");
  if(op->protected&AT_SLOW)
    strcat(retbuf,"(prot slow)");
  if(op->immune&AT_SLOW)
    strcat(retbuf,"(immune slow)");

  if(op->vulnerable&AT_COLD)
    strcat(retbuf,"(vulnerable cold)");
  if(op->protected&AT_COLD)
    strcat(retbuf,"(prot cold)");
  if(op->immune&AT_COLD)
    strcat(retbuf,"(immune cold)");

  if(op->vulnerable&AT_FIRE)
    strcat(retbuf,"(vulnerable fire)");
  if(op->protected&AT_FIRE)
    strcat(retbuf,"(prot fire)");
  if(op->immune&AT_FIRE)
    strcat(retbuf,"(immune fire)");

  if(op->vulnerable&AT_POISON)
    strcat(retbuf,"(vulnerable poison)");
  if(op->protected&AT_POISON)
    strcat(retbuf,"(prot poison)");
  if(op->immune&AT_POISON)
    strcat(retbuf,"(immune poison)");

  if(op->vulnerable&AT_CONFUSION)
    strcat(retbuf,"(vulnerable confusion)");
  if(op->protected&AT_CONFUSION)
    strcat(retbuf,"(prot confusion)");
  if(op->immune&AT_CONFUSION)
    strcat(retbuf,"(immune confusion)");

  if(op->vulnerable&AT_ACID)
    strcat(retbuf,"(vulnerable acid)");
  if(op->protected&AT_ACID)
    strcat(retbuf,"(prot acid)");
  if(op->immune&AT_ACID)
    strcat(retbuf,"(immune acid)");

  if(op->vulnerable&AT_FEAR)
    strcat(retbuf,"(vulnerable fear)");
  if(op->protected&AT_FEAR)
    strcat(retbuf,"(prot fear)");
  if(op->immune&AT_FEAR)
    strcat(retbuf,"(immune fear)");

  if(LIFESAVE(op))
    strcat(retbuf,"(lifesaving)");
  if(REFL_SPELL(op))
    strcat(retbuf,"(reflect spells)");
  if(REFL_MISSILE(op))
    strcat(retbuf,"(reflect missiles)");
  if(IS_FLYING(op))
    strcat(retbuf,"(levitate)");
  if(STEALTH(op))
    strcat(retbuf,"(stealth)");
  if(XRAYS(op))
    strcat(retbuf,"(xray-vision)");
  if(retbuf[0]=='\0'&&op->type==RING)
    strcat(retbuf,"(adorment +1)");
  if(op->slaying!=NULL) {
    strcat(retbuf,"(slay ");
    strcat(retbuf,op->slaying);
    strcat(retbuf,")");
  }
  if(IS_MONSTER(op)) {
    if(UNDEAD(op))
      strcat(retbuf,"(undead)");
    if(CAN_PASS_THRU(op))
      strcat(retbuf,"(pass through doors)");
    if(SEE_INVISIBLE(op))
      strcat(retbuf,"(see invisible)");
    if(CAN_USE_WEAPON(op))
      strcat(retbuf,"(wield weapon)");
    if(CAN_USE_BOW(op))
      strcat(retbuf,"(archer)");
    if(CAN_USE_ARMOUR(op))
      strcat(retbuf,"(wear armour)");
    if(CAN_USE_RING(op))
      strcat(retbuf,"(wear ring)");
    if(CAN_USE_SCROLL(op))
      strcat(retbuf,"(read scroll)");
    if(CAN_USE_WAND(op))
      strcat(retbuf,"(fire wand)");
    if(CAN_CAST_SPELL(op))
      strcat(retbuf,"(spellcaster)");
    if(IS_FRIENDLY(op))
      strcat(retbuf,"(friendly)");
    if(UNAGGRESSIVE(op))
      strcat(retbuf,"(unaggressive)");
    if(HITBACK(op))
      strcat(retbuf,"(hitback)");
    if(op->arch->randomitems != NULL) {
      treasure *t;
      int first = 1;
      for(t=op->arch->randomitems; t != NULL; t=t->next)
        if(t->item->clone.type == ABILITY) {
          if(first) {
            first = 0;
            strcat(retbuf,"(Spell abilities:)");
          }
          strcat(retbuf,"(");
          strcat(retbuf,t->item->clone.name);
          strcat(retbuf,")");
        }
    }
    if(op->attacktype && op->attacktype != 1) {
      int i;
      strcat(retbuf,"(Attacks:)");
      for(i=0;i<15;i++)
        if(op->attacktype & (2<<(i-1))) {
          strcat(retbuf,"(");
          strcat(retbuf,attacks[i]);
          strcat(retbuf,")");
        }
    }
  }
  return retbuf;
}
