/*
 * static char *rcsid_button_c =
 *   "$Id: button.c,v 1.3 1993/04/25 16:08:12 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#include <funcpoint.h>

/*
 * This code is no longer highly inefficient 8)
 */

/*
 * Push the specified object.  This can affect other buttons/gates/handles
 * altars/pedestals/holes in the whole map.
 * Changed the routine to loop through _all_ objects.
 * Better hurry with that linked list...
 */

void push_button(object *op) {
  object *tmp;
  objectlink *ol;
  for (ol = get_button_links(op); ol; ol = ol->next) {
    if (!ol->ob || ol->ob->count != ol->id) {
      LOG(llevError, "Internal error in push_button.\n");
      continue;
    }
    tmp = ol->ob;
    switch(tmp->type) {
    case GATE:
    case HOLE:
      tmp->value=tmp->stats.maxsp?!op->value:op->value,tmp->speed=0.5;
      break;
    case HANDLE:
      tmp->face.number=tmp->arch->faces[tmp->value=
                tmp->stats.maxsp?!op->value:op->value];
      update_object(tmp);
      break;
    case ALTAR:
      tmp->value = 1;
      tmp->face.number = tmp->arch->faces[tmp->value];
      update_object(tmp);
      break;
    case BUTTON:
    case PEDESTAL:
      tmp->value=op->value;
      tmp->face.number=tmp->arch->faces[tmp->value];
      update_object(tmp);
      break;
    }
  }
}

/*
 * Updates everything connected with the button op.
 * After changing the state of a button, this function must be called
 * to make sure that all gates and other buttons connected to the
 * button reacts to the (eventual) change of state.
 */

void update_button(object *op) {
  object *ab,*tmp;
  int tot,any_down=0;
  objectlink *ol;
  for (ol = get_button_links(op); ol; ol = ol->next) {
    if (!ol->ob || ol->ob->count != ol->id) {
      LOG(llevError, "Internal error in update_button.\n");
      continue;
    }
    tmp = ol->ob;
    if (tmp->type==BUTTON) {
      for(ab=tmp->above,tot=0;ab!=NULL;ab=ab->above)
        if(!IS_FLYING(ab)) /* Why was nrof removed? */
          tot+=ab->weight*(ab->nrof?ab->nrof:1)+ab->carrying;
      tmp->value=(tot>=tmp->weight)?1:0;
      if(tmp->value)
        any_down=1;
    } else if (tmp->type == PEDESTAL) {
      tmp->value = 0;
      for(ab=tmp->above; ab!=NULL; ab=ab->above) {
        if(ab->head!=NULL)
          ab=ab->head;
        if ( (!IS_FLYING(ab) || FLY_ON(tmp)) && (ab->race==tmp->slaying ||
             (!strcmp (tmp->slaying, "player") && ab->type == PLAYER)))
          tmp->value = 1;
      }
      if(tmp->value)
        any_down=1;
    }
  }
  if(any_down) /* If any other buttons were down, force this to remain down */
    op->value=1;
  op->face.number=op->arch->faces[op->value];
  update_object(op);
  push_button(op); /* Make all other buttons the same */
}

/*
 * Updates every button on the map (by calling update_button() for them).
 */

void update_buttons(mapstruct *m) {
  objectlink *ol;
  oblinkpt *obp;
  for (obp = m->buttons; obp; obp = obp->next)
    for (ol = obp->link; ol; ol = ol->next) {
      if (!ol->ob || ol->ob->count != ol->id) {
        LOG(llevError, "Internal error in update_button.\n");
        continue;
      }
      if(ol->ob->type==BUTTON || ol->ob->type==PEDESTAL) {
        update_button(ol->ob);
        break;
      }
    }
}

/*
 * Note: animate_object should be used instead of this,
 * but it can't handle animations in the 8 directions
 */

void animate_turning(object *op) /* only one part objects */
{
    if (++op->state >= op->arch->animations/8)
        op->state=0;
    op->face.number = op->arch->faces[(op->stats.sp-1) * op->arch->animations/8 +
                               op->state];
    update_object(op);
}

void use_trigger(object *op) 
{
  object *tmp;
  objectlink *ol;

  for (ol = get_button_links(op); ol; ol = ol->next) {
    if (!ol->ob || ol->ob->count != ol->id) {
      LOG(llevError, "Internal error in update_button.\n");
      continue;
    }
    tmp = ol->ob;
    switch(tmp->type) {
      case TIMED_GATE:
        tmp->speed = tmp->arch->clone.speed; /* original values */
        tmp->value = tmp->arch->clone.value;
        tmp->stats.sp = 1;
        tmp->stats.hp = tmp->stats.maxhp;
        break;
      case DIRECTOR:
      case FIREWALL:
        if ((tmp->stats.sp += tmp->stats.maxsp) > 8) /* next direction */
          tmp->stats.sp = ((tmp->stats.sp-1)%8)+1;
        animate_turning(tmp);
        break;
    }
  }
}

/*
 * check_altar checks if sacrifice was accepted and removes sacrificed
 * objects. If sacrifice was succeed return 1 else 0
 */
#define ARCH_SACRIFICE(xyz) (xyz)->slaying
#define NROF_SACRIFICE(xyz) (xyz)->stats.food

int check_altar (object *altar)
{
  object *op;

  if (!altar->slaying || altar->value)
    return 0;

  for (op=altar->above; op; op=op->above)
    if (!IS_ALIVE(op) &&
        ((op->type != PLAYER && ARCH_SACRIFICE(altar) == op->arch->name) ||
         ARCH_SACRIFICE(altar) == op->name ) &&
        NROF_SACRIFICE(altar) <= (op->nrof?op->nrof:1))
      break;

  if (!op)
    return 0;

  decrease_ob_nr (op, NROF_SACRIFICE(altar));
 
  for (op = get_map_ob(altar->map,altar->x,altar->y);
       op && op->type != PLAYER; op=op->above);
  if (op && altar->msg)
    (*info_map_func) (op->map, altar->msg);
  return 1;
}

void trigger_move (object *op, int state) /* 1 down and 0 up */
{
  op->stats.wc = state;
  op->face.number=op->arch->faces[op->stats.wc];
  update_object(op);
  if (state) {
    use_trigger(op);
    op->speed = op->arch->clone.speed;
    op->speed_left = -1;
  } else {
    op->speed = 0;
  }
}

void check_trigger (object *op) {
  object *tmp;
  int push = 0, tot = 0;

  switch (op->type) {
    case TRIGGER_BUTTON:
      for(tmp=op->above; tmp; tmp=tmp->above)
	if(!IS_FLYING(tmp))
	  tot += tmp->weight * (tmp->nrof ? tmp->nrof : 1) + tmp->carrying;
      if (tot >= op->weight)
	push = 1;
      if (!push || op->stats.wc == 0)
	trigger_move (op, push);
      return;
    case TRIGGER_PEDESTAL:
      for(tmp=op->above; tmp; tmp=tmp->above) {
	if(tmp->head!=NULL)
	  tmp=tmp->head;
	if ( (!IS_FLYING(tmp) || FLY_ON(op)) && (tmp->race==op->slaying ||
	     (!strcmp (op->slaying, "player") && tmp->type == PLAYER)))
	  push = 1;
      }
      if (!push || op->stats.wc == 0)
	trigger_move(op, push);
      return;
    case TRIGGER_ALTAR:
      if (op->stats.wc  == 0)
        trigger_move (op,  op->speed == 0 ? check_altar(op) : 0);
      return;
    default:
      if (op->stats.wc == 0)   /* handle-trigger */
	trigger_move (op, op->speed == 0 ? 1 : 0);
  }
}

void add_button_link(object *button, mapstruct *map, int connected) {
  oblinkpt *obp;
  objectlink *ol = get_objectlink();

  if (!map) {
    LOG(llevError, "Tried to add button-link without map.\n");
    return;
  }

  SET_IS_LINKED(button);

  ol->ob = button;
  ol->id = button->count;

  for (obp = map->buttons; obp && obp->value != connected; obp = obp->next);

  if (obp) {
    ol->next = obp->link;
    obp->link = ol;
  } else {
    obp = get_objectlinkpt();
    obp->value = connected;

    obp->next = map->buttons;
    map->buttons = obp;
    obp->link = ol;
  }
}

/*
 * Remove the object from the linked lists of buttons in the map.
 * This is only needed by editors.
 */

void remove_button_link(object *op) {
  oblinkpt *obp;
  objectlink **olp, *ol;

  if (op->map == NULL) {
    LOG(llevError, "remove_button_link() in object without map.\n");
    return;
  }
  if (!IS_LINKED(op)) {
    LOG(llevError, "remove_button_linked() in unlinked object.\n");
    return;
  }
  for (obp = op->map->buttons; obp; obp = obp->next)
    for (olp = &obp->link; (ol = *olp); olp = &ol->next)
      if (ol->ob == op) {
        LOG(llevDebug, "Removed link %d in button %s and map %s.\n",
            obp->value, op->name, op->map->path);
        *olp = ol->next;
        free(ol);
        return;
      }
  LOG(llevError, "remove_button_linked(): couldn't find object.\n");
  UNSET_IS_LINKED(op);
}
  
/*
 * Return the first objectlink in the objects linked to this one
 */

objectlink *get_button_links(object *button) {
  oblinkpt *obp;
  objectlink *ol;

  if (!button->map)
    return NULL;
  for (obp = button->map->buttons; obp; obp = obp->next)
    for (ol = obp->link; ol; ol = ol->next)
      if (ol->ob == button && ol->id == button->count)
        return obp->link;
  return NULL;
}

/*
 * Made as a separate function to increase efficiency
 */

int get_button_value(object *button) {
  oblinkpt *obp;
  objectlink *ol;

  if (!button->map)
    return 0;
  for (obp = button->map->buttons; obp; obp = obp->next)
    for (ol = obp->link; ol; ol = ol->next)
      if (ol->ob == button && ol->id == button->count)
        return obp->value;
  return 0;
}
