! "main" (cells 1226 length 220 width 150 generation 0)
! Sawtooth with external timing
! David I. Bell, 16 Aug 1993
!
! This gives an example of a different type of sawtooth.  Unlike all the
! other known sawtooths, the components that cause the population to grow are
! not used to trigger the cycles of the sawtooth.  Instead, those components
! are passive, and the triggering is external.
!
! This is based on two of Dean's previous constructions (his caber tosser log(t)
! pattern and his hacksaw sawtooth).  Here a blinker puffer lays down blinkers
! which are occasionally ignited by a salvo of a MWSS and two LWSSs.  When the
! burning reaches the blinker puffer, it simply goes out.  An occasional glider
! emitted by a caber tosser is used to initiate each salvo.  Each salvo is sent
! out at a time which doubles each cycle.
!
! Since the blinkers are further and further away on each cycle, and the time
! between salvos increases, the maximum population of the blinkers obviously
! increases on each cycle.
!
! What is not so obvious is whether or not the population returns to the same
! low point on each cycle.  (In this sawtooth, several salvos are in transit
! at the same time, so that the "cycles" overlap!)  To be a sawtooth, the
! number of salvos has to remain bounded.  The following analysis by Dean
! Hickerson shows that this is indeed the case.
!
! Suppose you send the N'th salvo toward the blinkers in generation t(N),
! and the blinker which it's going to hit will be a distance f(N) away.
! (The blinker may not exist yet.)  It takes  2 f(N)  gens for the salvo
! to reach the blinkers, so ignition occurs about gen  t(N) + 2 f(N).  At
! this time, the puffer is at distance  t(N)/2 + f(N),  so the burn has a
! distance of  t(N)/2  to catch up.  Since it catches up at  2c/3 - c/2
! = c/6,  it takes  3 t(N)  gens to do so, catching up at gen
! 4 t(N) + 2 f(N).  Then the blinkers start forming again, at distance
! 2 t(N) + f(N).  So  f(N+1) = 2 t(N) + f(N), implying that  f(N) =
! 2 [t(N-1) + t(N-2) + ... + t(0)] + C  for some constant C.
! For the cabertosser,  t(N) = 960 2^N  and the sum in brackets is
! 960 2^(N-1) + ... + 960 2^0 = 960 (2^N - 1).  Thus, f(N) is about
! 1920 2^N,  and the N'th burn finishes about gen  7680 2^N.  Note that
! this equals  t(N+3).  Thus, by the time the N'th burn finishes, 2 more
! salvos are well on their way and a 3rd is being sent.  The population
! at this time is bounded, so this is indeed a sawtooth.  The population
! maxima occur at the times of ignition,  T = t(N) + 2 f(N) = 4800 2^N.
! At this time the blinkers cover a distance of  t(N)/2 = 480 2^N = T/10;
! since they have linear density 3/4, the population at this time is
! about  3T/40.
! "main" (cells 1250 length 219 width 150 generation 0)
109k75h@!
60........................................................................OO
60........................................................................OO
60..O
60.O.O
43.OO15.OO.O68.O
43.O.O14.OO.OO8.OO21.OO33.3O
38.OO6.O13.OO.O8.O.O21.O33.O3.O
34.OO.O..O..O..O13.O.O8.3O12.O7.O.O19.OO14.O
34.OO..OO6.O8.O5.O8.3O8.OO3.4O4.OO20.OO11.O5.O
43.O.O7.O.O15.3O8.OO3.4O11.O10.OO6.O3.OO..O5.O
43.OO9.OO16.O.O..OO.O.OO3.O..O11.O.O7.3O5.O3.O.O3.O3.O
61.............OO..OO.O.O....OOOO..............OO......OO......OOOOO.....OOO
61...................OO.O...OOOO...............OO.........OO....OOO
61..........................O..................OO.........OO
61.................................OO.......O.O
61................................O.O.......O...........O
61..OO........O...................O...................O.O...............O
61.OO.OO....OO...................OO....................OO
31.OO......................................OO........................OO....O....OO
32.O30.O32.O..O.O3.O.O..O19.O
32.O.O29.O.OO28.3O9.3O19.O.O
33.OO30.O33.OO5.OO22.OO
98.O..OOOOO..O............O
98.OO.......OO.............O
4.OO114.3O
3.OO.3O122.OO3.OO
4.5O23.OO28.OO28.OO29.O
5.3O23.4O26.4O26.4O11.OO14.O9.O3.O
18.3O9.OO.OO25.OO.OO25.OO.OO10.OO.OO9.O..3O8.3O
17.5O9.OO28.OO28.OO13.4O8.OO13.3O
4.5O7.OO.3O85.OO9.O.O
4.O......O.....OO......................................O
4.O......O...........................................OO
4..O.....O............................................OO
7.O125.OO
83...................................................OO
83.OO.........................................OO
6.OO75.OO40.OO
5.OO.4O60.OO6.OO10.O4.O29.O9.O
6.6O42.O.O15.OO5.3O10.O4.O.O35.O.O
7.4O46.O22.OO10.O7.OO21.OO9.O.O11.OO
41.OO10.O4.O..OO5.OO13.OO..OO11.OO4.OO15.3O7.O..O11.OO
40.O.O10.OO.O..O.OO4.OO14.OO..O..OO8.OO4.OO6.OO9.OO.O5.O.O
42.O14.OO10.O18.4O5.O.O14.O5.O4.O..O6.O.O
64..........................O.......O.....................O.....OO.O........O
64..OO................................................O...O...OOO
64.O..O.................................................O.....OO
64....O
64....O............O.O
25................OO......................OO.O............OO
25................OO......................OO...............O
25................OO...................................OO
25................O....................................OO
25...............O.O.......................OO
25...............O.OO......................OO
25................................OOO
25..OO....O.O.....................O..........................OO.........OO
25.O.O............OO...............O........................OO.........O.O
27.O....OOOOO...OO...................................O......O.......OOO....OO.OOO
27.......OOO........................................O.O............OOO....O..OOOO
27........OO.................................OO...OO...O............OOO....OO
27...........................................OO...OO...O.............O.O
9.O8.OO54.OO3.O14.OO
.......O.O......O..O........................................................O.O
OO....O.O.......O...O..OO.................O..................................O
OO...O..O.......O..OO..OOO...............OO..........OO
......O.O................OO.O............O.O.........OO
.......O.O....OOO........O..O.......OO............OO......O...OO
.........O...............OO.O.....O...O..........OOO.....O...O.O
.......................OOO.......O.....O..........OO......OOOOO
.......................OO.......OO.O...O.............OO....OOO
.................................O.....O.............OO
....................O.............O...O
....................OOO.............OO
.......................O.............................................OO
......................OO.............................................OO
.
.
7...................O...........................................OOO..........O
7.OO..............OO.OO..........................................OO.....OOOO.O
7.OO..........................................................OO........O.O.OO
7................O.....O......................................OOO.........O
7..............................................................O.O.......OO
7................OO.O.OO........................................OO
.
71..O.............OOO
71..OO............O
71.O.O.............O.........O
7.O88.O.O
6.3O75.O.O8.O.OO10.OO
5.5O48.OO24.O..O6.OO.OO10.OO
4.OO3.OO46.3O3.OO.O20.OO6.O.OO
54.O.OO.....O...O..O..............O...OO.....O.O
54.O..O....O....O..OO...............OO........O
54.O.OO....OOOO.....OO...........O..O
8.O...............OO...OO..................OO......OOO...O.......OOO..........O.O
.......OO...............O.....O.................O.O.......OO...........OO
................................................O.....................OO
.....O...................O...O.................OO.....................O
....O.O...................OOO
...O...O
....OOO
..OO...OO
.
........................OO
.........................O
......................OOO
......................O
.
.
.
..OO........O
...O......OOO
OOO......O
O........OO
.
.
.
.
.
.
.
.
.....OOOOO
....O.OOO.O
.....O...O
......OOO
.......O
.
..........O
.........OO
.
.
.
......OO.O.OO
......O.....O
.......O...O
........OOO
.
.
.
.
.
.
.
..........O
.........OO
.
.
.
.
.
46...............................................OO
46...............................................OO
.
.
46..............................O
46.............................O.O.OO
46...............................O..OO..O
46..................................O..OOO
46............................O..O..OOOO.OO..............OO
46.............................O.O.....OOO...............OO
46..........................O...O.......O
46.......................O...O
46......................O.....O
46.......................OO.OO
.
46.......................O
46.......................OOOO....................................OO
46........................O.O....................................OO
46..........................O
46.........................OOO
46........................OO.OO
46.........................OOO
46..........................O
.
.
.
.
46..........................................OOO....................OOOOO
46..........................................O......................OO.O
46...........................................O......................OOO
46....O.............................................................OO
46...O.O.OO.........................................................O
46.....O..OO..O....................................................O.O
46........O..OOO...................................................OO
46..O..O..OOOO.OO.................................................O.OOO
46...O.O.....OOO...................................................O...O
46....O.......O...................................................O...O
46....................................................................OOO
46.OO.................................O.............................OO
46.OO...............................OO.O............................OO.OO
46.........................O.O......OO..O.........OOO.................O
46.........................O..O......OO...OOO......O..O
46........................O...OO........OOOO.O.........O
46........................O............OOOO..O......O.O
46......................................O
46........................O..OOO
46.........OO.............OO
46.........OO...............OOO
46..........................OOO.........................O.O
46...............................................OO...OO.O
46...............................................OOOOO.OO...OO
46.........................O..................O..O.OO.O.O...OO
46........................O.O................O....OO....O.OO..O
46...........................O...........OOOO.O..........O.O.O
46.................OO...O....O...........OO.OOO............O.O
46.................OO..O.....OO...........OOO
46...........................O............OO
46......................OO..OOO...........O
46...........................OO..........O.O
46.......................................OO
46......................................O.OOO
46.......................................O...O
46........................O..O..........O...O
46.........................OO...............OOO
46........................................OO
46........................................OO.OO
46..........................................O
