/*
 * Copyright (c) 1995 David I. Bell
 * Permission is granted to use, distribute, or modify this source,
 * provided that this copyright notice remains intact.
 */

#include "life.h"


/*
 * Return a row structure for a given row number, returning NULL if not there.
 */
ROW *
FindRow(obj, row)
	OBJECT *obj;
	COORD	row;
{
	ROW *	rp;

	for (rp = obj->firstrow; (row > rp->row); rp = rp->next)
		;

	if (rp->row != row)
		return NULL;

	return rp;
}


/*
 * Return a row structure for a given row number, creating it if needed.
 */
ROW *
GetRow(obj, row)
	OBJECT *obj;
	COORD	row;
{
	ROW *	rp;		/* current row */
	ROW *	nrp;		/* next row */
	ROW *	prp;		/* previous row */

	prp = (ROW *) 0;
	rp = obj->firstrow;

	if (row < rp->row) {		/* at front */
		nrp = AllocateRow();

		nrp->row = row;
		nrp->next = obj->firstrow;
		obj->firstrow = nrp;

		if (nrp->next == termrow)
			obj->lastrow = nrp;

		return nrp;
	}

	if (row >= obj->lastrow->row)
		rp = obj->lastrow;

	while (row > rp->row) {
		prp = rp;
		rp = rp->next;
	}

	if (row == rp->row) {
		return rp;
	}

	nrp = AllocateRow();

	nrp->row = row;
	nrp->next = rp;
	prp->next = nrp;

	if (nrp->next == termrow)
		obj->lastrow = nrp;

	return nrp;
}


/*
 * Find a cell given its coordinates, returning NULL if not found.
 */
CELL *
FindCell(obj, row, col)
	OBJECT *obj;
	COORD	row;
	COORD	col;
{
	CELL *	cp;
	ROW *	rp;

	rp = FindRow(obj, row);

	if (rp == NULL)
		return NULL;

	for (cp = rp->firstcell; col > cp->col; cp = cp->next)
		;

	if (col != cp->col)
		return NULL;

	return cp;
}


/*
 * Create a cell at a given row and column.  Returns FALSE if the cell
 * already existed.  If the cell is new, it is marked with the current
 * mark value of the object.
 */
BOOL
AddCell(obj, row, col)
	OBJECT *obj;
	COORD	row;
	COORD	col;
{
	CELL *	cp;		/* current cell */
	CELL *	ncp;		/* next cell */
	CELL *	pcp;		/* previous cell */
	ROW *	rp;

	rp = GetRow(obj, row);
	cp = rp->firstcell;
	pcp = (CELL *) 0;

	if ((cp != termcell) && (col >= rp->lastcell->col)) {
		pcp = rp->lastcell;		/* at end */

		if (col == pcp->col)
			return FALSE;

		ncp = AllocateCell();

		ncp->col = col;
		ncp->marks |= obj->mark;
		ncp->next = termcell;
		pcp->next = ncp;
		rp->lastcell = ncp;
		rp->count++;
		obj->count++;
		obj->update |= U_ALL;

		return TRUE;
	}

	if (col < cp->col) {
		ncp = AllocateCell();		/* at front */

		ncp->col = col;
		ncp->marks |= obj->mark;
		ncp->next = cp;
		rp->firstcell = ncp;

		if (cp == termcell)
			rp->lastcell = ncp;

		rp->count++;
		obj->count++;
		obj->update |= U_ALL;

		return TRUE;
	}

	while (col > cp->col) {		/* in middle */
		pcp = cp;
		cp = pcp->next;
	}

	if (col == cp->col)
		return FALSE;

	ncp = AllocateCell();

	ncp->col = col;
	ncp->marks |= obj->mark;
	ncp->next = cp;
	pcp->next = ncp;

	if (cp == termcell)
		rp->lastcell = ncp;

	rp->count++;
	obj->count++;
	obj->update |= U_ALL;

	return TRUE;
}


/*
 * Delete a cell at a given coordinate.
 * Returns FALSE if it did not exist.
 */
BOOL
DeleteCell(obj, row, col)
	OBJECT *obj;
	COORD	row;
	COORD	col;
{
	ROW *	rp;
	CELL *	pcp;		/* previous cell */
	CELL *	cp;		/* current cell */

	rp = FindRow(obj, row);

	if (rp == NULL)
		return FALSE;

	pcp = NULL;
	cp = rp->firstcell;

	while (col > cp->col) {
		pcp = cp;
		cp = cp->next;
	}

	if (col != cp->col)
		return FALSE;

	if (pcp)
		pcp->next = cp->next;
	else
		rp->firstcell = cp->next;

	if (cp->next == termcell)
		rp->lastcell = pcp;

	cp->next = freecells;
	freecells = cp;
	rp->count--;
	obj->count--;
	obj->update |= U_ALL;

	return TRUE;
}

/* END CODE */
