#ifndef BROADCAST_H
# define BROADCAST_H

# include <X11/Intrinsic.h>
# include "gointer.h"

extern Widget BroadcastButton, YellButton;

extern void InitBroadcast(Widget Toplevel);
extern void ShowBroadcast(const char *Who, const char *What);
extern void InitYell(Widget Toplevel);
extern void CleanYell(void);
extern void ChannelJoin(int channel, const char *Who);
extern void ChannelLeave(int channel, const char *Who);
extern void WrongChannel(const char *Message);
extern void ChannelDisallowed(void);
extern void JoinChannel(int channel);
extern void RejoinChannel(void);
extern void ShowYell(int channel, const char *Who, const char *What);

extern ChannelData *OpenChannelData(void);
extern void         AddChannelData(ChannelData *Data, char *Name,
                                   char *Moderator, char *Title,
                                   char *state, NameList *Names);
extern void         CloseChannelData(ChannelData *Data);
extern void         ChannelList(const ChannelData *Data);
#endif /* BROADCAST_H */
