

/* warning.c */
#include "config.h"
#include "copyright.h"

#include <stdio.h>
#include <math.h>
#include <signal.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include <time.h>
#include INC_SYS_TIME

/* * The warning in text will be printed in the warning window. * The message
 * will last WARNTIME/10 seconds unless another message * comes through and
 * overwrites it. */
warning(char *text)
{
  int doPhaser;
  LONG    curtime;
  struct tm *tm;
  char    newtext[128];

  if (warncount > 0)
    {
      /* XFIX */
      W_ClearArea(warnw, 5, 5, W_Textwidth * warncount, W_Textheight);
    }
    
  warncount = strlen(text);
  W_WriteText(warnw, 5, 5, textColor, text, warncount, W_RegularFont);
  warntimer = udcounter + WARNTIME;		 /* set the line to be
						  * cleared */

  
  doPhaser = showPhaser && (strncmp(text, "Phaser burst", 12) == 0);
  
  if (logmess || doPhaser)
    {
  time(&curtime);
  tm = localtime(&curtime);
      sprintf(newtext, "%.100s %02d:%02d:%02d", text, tm->tm_hour,
		tm->tm_min, tm->tm_sec);
      warncount = (warncount > 100) ? 109 : warncount + 9;

  if (logmess)
    {
      if (logFile != NULL)
	{
	  fprintf(logFile, "%s\n", newtext);
	  fflush(logFile);
	}
      else
	    puts(newtext);
    }
	
      if (doPhaser)
    {
      switch (showPhaser)
	{
	case 0:
	  break;
	case 1:
	  W_WriteText(messwk, 0, 0, textColor, newtext, warncount, 0);
	  W_WriteText(reviewWin, 0, 0, textColor, newtext, warncount, 0);
	  break;
	case 2:
	  W_WriteText(phaserwin, 0, 0, textColor, newtext, warncount, 0);
	  W_WriteText(reviewWin, 0, 0, textColor, newtext, warncount, 0);
	  break;
	case 3:
	  W_WriteText(reviewWin, 0, 0, textColor, newtext, warncount, 0);
	  break;
	default:
	  break;
	}
	}
    }
}
