#include <pwd.h>
#include "vmsutils.h"

#include <stdio.h>
#include <time.h>
#include <timeb.h>
#include <ssdef.h>
#include <jpidef.h>
#include <iodef.h>

typedef struct itmlst_str {
  short buffer_length;
  short item_code;
  long buffer_address;
  long retlen_address;
} Itmlst;

long random(void) {
  long rand();
  return (rand());

int fork(void) {
  int vfork();
  return (vfork());
}

void srandom(int seed) {
  srand(seed);
}

char *crypt(char *cryptstr, char *key) {
  return (cryptstr);                         /* not really crypted */
}

bcopy(char *from_str, char *to_str, int length) {
  int i;
  for (i=0; i<length; i++)
    to_str[i] = from_str[i];
}
bzero( char *str, int length) {
  int i;
  for (i=0; i<length; i++)
    str[i] = '\0';
}

char *index(char *str, char c) {
  while (*str != '\0') {
    if (*str == c)
      return (str);
    else
      str++;
  }
  return ((char *) 0);
}

char *rindex(char *str, char c) {
  char *firstc = str;

  str += strlen(str);       /* go to the end of the string  */
  while (str >= str) {      /* while not over the beginning */
    if (*str == c)
      return (str);
    else
      str--;
  }
  return ((char *) 0);
}

int bcmp(char *b1, char *b2, int length) {
  int i;

  for (i=0; i<length; i++) {
    if (b1[i] != b2[i])
      return (-1);  /* strings aren't alike */
  }
  return (0);   /* strings are alike */
}

struct passwd *getpwuid(int not_used) {
  struct passwd *passwd= (struct passwd *) malloc(sizeof(struct passwd));
  short retlen;
  char *cptr  = malloc(20*sizeof(char));
  Itmlst itmlst = {19, JPI$_USERNAME, (long)cptr, (long)&retlen};
  unsigned int status;

  passwd->pw_name = cptr;

  status = sys$getjpiw(NULL, NULL, NULL, &itmlst, NULL, NULL, NULL);
  if ( ( status && 1 ) == 1 ) {
    passwd->pw_name[retlen] = '\0';
    while (*cptr) {          /* find first whitespace and terminate there */
      if (*cptr == ' ') {
        *cptr = '\0';
      }
      cptr++;
    }
    return (passwd);
  } else {
    printf ( "vmsutils: getpwuid(): sys$getjpiw returned %08.8x\n", status );
    strcpy(passwd->pw_name, "VMS-nousername");
    return (passwd);
  }
}

struct tv {
    long tv_sec;
    long tv_usec;
};

gettimeofday ( struct tv *tv, struct tv *tz )
{
    /* ignore tz */
    struct timeb tb;

    ftime (&tb);
    tv->tv_sec = (long) tb.time;
    tv->tv_usec = (long) tb.millitm;
}

/*
**  Event stuff
*/

/*
**  Message received flags; set to 1 when a message is received
*/
unsigned char win = 0;
unsigned char tcp = 0;
unsigned char udp = 0;

void vms_event_window(void)
{
    sys$wake(0,0);
    win = 1;
}

void vms_event_window_done(void)
{
    win = 0;
}

void vms_event_tcp(void)
{
    sys$wake(0,0);
    tcp = 1;
}

void vms_event_udp(void)
{
    sys$wake(0,0);
    udp = 1;
}

void vms_queue_read_attention ( int socket, void *(routine(void)) )
{
    unsigned int status;

    status = sys$qiow (
        0,                         /* event flag number */
        vaxc$get_sdc(socket),      /* channel */
        IO$_SETMODE|IO$M_READATTN, /* function code */
        0,                         /* iosb */
        0,                         /* astadr */
        0,                         /* astprm */
        routine,                   /* p1 - ast routine */
        0,                         /* p2 - ast parameter */
        0,                         /* p3 - ast access mode */
        0,                         /* p4 - not used */
        0,                         /* p5 - not used */
        0                          /* p6 - not used */
    );

    /* check status and report err */
    if ( ( status & 1 ) != 1 )
    {
        lib$signal ( status );
    }
}

void vms_wait_either(int *mask, int swin, int stcp, int sudp)
{
    unsigned int status;
    static unsigned char tcpraqd = FALSE;
    static unsigned char udpraqd = FALSE;

    if ( ! tcpraqd )
    {
        vms_queue_read_attention ( stcp, vms_event_tcp );
        tcpraqd = TRUE;
    }

    if ( ! udpraqd )
    {
        if ( sudp >= 0 ) vms_queue_read_attention ( sudp, vms_event_udp );
        udpraqd = TRUE;
    }

    while ( *mask == 0 )
    {
        sys$hiber();

        sys$setast(0);
        if ( tcp != 0 ) { tcp = 0; tcpraqd = FALSE; *mask |= ( 1<<stcp ); }
        if ( udp != 0 ) { udp = 0; udpraqd = FALSE; *mask |= ( 1<<sudp ); }
        if ( win != 0 ) { win = 0; *mask |= ( 1<<swin ); }
        sys$setast(1);
    }
}
