!
!   DESCRIP.MMS
!
!   Make file for OpenVMS/VAX for use with MMS or MMK.
!
!   Build COW for OpenVMS/VAX with either DEC TCP/IP Services for OpenVMS
!   or OpenCMU/IP.
!
!   Written by James Cameron, (cameron@sna.dec.com), Digital Equipment
!   Corporation, CSS Sydney Engineering, on 16-Apr-1994.
!
!   Used compiler VAX C V3.2-044 in ANSI standard mode
!

.first
  !
  !   Build COW for OpenVMS/VAX with either DEC TCP/IP Services for OpenVMS
  !   or OpenCMU/IP.  Derived from DESCRIP.MMS
  !
  !   The VAX C supplied header files are all in the one directory.
  !
  !   These logical names cause #include <sys/what.h> to search the SYS$LIBRARY  !   directory to find what.h, without them the compilation fails.
  !
  define /nolog sys      sys$library
  define /nolog netinet  sys$library
  define /nolog arpa     sys$library
  if f$type(vc) .nes. "" then vc
  !

cflags = /standard=ansi/list/include=(sys$disk:[],sys$library)/nowarnings
arch = OpenVMS/VAX
cwho = "cameron@sna.dec.com"

!
!  List of object modules required during link of final executable
!

objects = main, newwin, stats, pingstats, getname, cflags, defaults, socket,-
check, x11window, dmessage, reserved, enter, helpwin, macrowin, findslot,-
colors, input, vmsutils, getship, util, distress, ping, short, inform, redraw,-beeplite, lagmeter, smessage, parsemeta, netstatopt, netstat, option,-
planetlist, playerlist, senddist, ranklist, rotate, interface, defwin, docwin,-spopt, strdup, udpopt, death, war, warning, planets, dashboard, tools, data, -
sintab

cow.exe : cow.olb($(objects)), cow.opt
	library/compress/output=cow.olb cow.olb
	delete cow.olb;-1
	$(link)$(linkflags) -
	     /map=cow.map -
	     /cross_reference -
	     /full -
	     cow.opt/options

cflags.c : mkcflags.exe
	mkcflags = "$sys$disk:[]mkcflags"
	define/user_mode sys$output cflags.c
	mkcflags "$(CC) $(CFLAGS)" "$(ARCH)"
	open/append cflags cflags.c
	write cflags "char cwho[]="$(CWHO)";"
	close cflags

mkcflags.exe : mkcflags.obj cow.olb(vmsutils)
	link mkcflags, cow/library, sys$library:vaxcrtl/library

mkcflags.obj : mkcflags.c config.h version.h patchlevel.h

!
! Manually prepared header dependencies; OpenVMS/VAX does not have makedepend,
! but this can be derived from makedepend running on a system that does have it.!

audio.obj : config.h audio.h

beeplite.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

cflags.obj : config.h

check.obj : config.h copyright2.h Wlib.h defs.h struct.h data.h

colors.obj : config.h copyright2.h Wlib.h defs.h struct.h data.h

dashboard.obj : dashboard.c config.h copyright.h Wlib.h defs.h struct.h data.h -string_util.c

data.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

death.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

defaults.obj : config.h copyright2.h Wlib.h defs.h struct.h data.h

defwin.obj : config.h Wlib.h defs.h struct.h data.h

distress.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

dmessage.obj : config.h copyright.h Wlib.h defs.h struct.h data.h -
version.h patchlevel.h

docwin.obj : config.h copyright.h Wlib.h defs.h struct.h data.h -
packets.h

enter.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

feature.obj : config.h copyright.h Wlib.h defs.h struct.h data.h -
packets.h

findslot.obj : config.h copyright2.h Wlib.h defs.h struct.h data.h

getname.obj : config.h copyright2.h vmsutils.h Wlib.h defs.h -
struct.h data.h Kathy.xbm

getship.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

helpwin.obj : config.h Wlib.h defs.h struct.h data.h

inform.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

input.obj : config.h copyright.h vmsutils.h Wlib.h defs.h struct.h -
data.h packets.h

interface.obj : config.h copyright.h Wlib.h defs.h struct.h -
data.h packets.h

lagmeter.obj : config.h copyright.h Wlib.h defs.h struct.h data.h -
packets.h

macrowin.obj : config.h Wlib.h defs.h struct.h data.h

main.obj : config.h copyright.h Wlib.h defs.h struct.h data.h packets.h -
version.h patchlevel.h

mkcflags.obj : config.h version.h patchlevel.h

mkkey.obj : config.h defs.h

name.obj : version.h patchlevel.h

netstat.obj : config.h copyright2.h Wlib.h defs.h struct.h data.h -
packets.h

netstatopt.obj : config.h copyright.h Wlib.h defs.h struct.h -
data.h packets.h

newwin.obj : config.h copyright.h vmsutils.h Wlib.h defs.h struct.h -
data.h bitmaps.h moobitmaps.h rabbitbitmaps.h tngbitmaps.h hullbitmaps.h -
oldbitmaps.h packets.h

option.obj : config.h copyright.h Wlib.h defs.h struct.h data.h -
packets.h

parsemeta.obj : config.h copyright.h Wlib.h defs.h struct.h data.h -
vmsutils.h

ping.obj : config.h copyright2.h Wlib.h defs.h struct.h data.h packets.h

pingstats.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

planetlist.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

planets.obj : config.h copyright2.h Wlib.h defs.h struct.h data.h

playerlist.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

randomize.obj : config.h

ranklist.obj : config.h copyright2.h Wlib.h defs.h struct.h data.h

redraw.obj : config.h copyright.h Wlib.h defs.h struct.h data.h -
packets.h
reserved.obj : config.h copyright2.h Wlib.h defs.h struct.h data.h -
packets.h

rotate.obj : config.h copyright2.h Wlib.h defs.h struct.h data.h -
packets.h

senddist.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

short.obj : config.h Wlib.h defs.h struct.h data.h packets.h wtext.h

sintab.obj : config.h copyright.h

smessage.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

socket.obj : config.h copyright2.h Wlib.h defs.h struct.h data.h -
packets.h wtext.h vmsutils.h

sound.obj : config.h copyright.h Wlib.h defs.h struct.h data.h audio.h

spopt.obj : config.h copyright.h Wlib.h defs.h struct.h data.h packets.h

stats.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

tools.obj : config.h Wlib.h defs.h struct.h data.h

udpopt.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

util.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

vmsutils.obj : vmsutils.h

war.obj : config.h copyright.h Wlib.h defs.h struct.h data.h packets.h

warning.obj : config.h copyright.h Wlib.h defs.h struct.h data.h

x11window.obj : config.h vmsutils.h Wlib.h defs.h struct.h data.h -
teams.bitmap mapcursor.bitmap localcursor.bitmap

