/* maxvolume.c - Filters a soundfile (no pipe) to stdout with volume raised to max volume
**
** Copyright (C) 1989 by Jef Poskanzer.
** Frank Buchholz, 1993, <buchholz@lusty.informatik.uni-dortmund.de>
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include <multimedia/audio_filehdr.h>
#include "libst.h"

#define BUFSIZE 256

main( argc, argv )
int argc;
char *argv[];
{
	FILE *f;
	char buf[BUFSIZE];
	float scale;
	double atof();
	int i, c, lc;
	int maxrange = 0;
        int magic, hdr_size;

	if ( argc != 2 ) {
		fprintf( stderr, "usage:  %s <file>\n", argv[0] );
		exit(1);
	}

	/*
	 * 1st run: calculate scale 
	 */
	if ((f = fopen( argv[1], "r" )) == NULL) {
		perror( argv[1] );
		exit(2);
	}

	/* Read audio header */
        magic = getw( f );			/* magic number */
        if ((magic == EOF) || (magic != AUDIO_FILE_MAGIC)) {	
		fprintf( stderr, "File %s is not an audio file\n", argv[2]);
		exit(3);
	}
        if ((hdr_size = getw( f )) == EOF) {	/* size of the header */
		fprintf( stderr, "File %s is not an audio file\n", argv[1]);
		exit(4);
	}
	for (i = hdr_size - 6*sizeof(int), c = 0; (c != EOF) && (i > 0); i-- ) {
		c = getc( f );
	}

	while ( (c = getc( f )) != EOF )
	{
		lc = abs(st_ulaw_to_linear( c ));
		if (lc > maxrange)
			maxrange = lc;
	}

	fclose(f);

	scale = (float)MAXLIN / (float)maxrange;
	fprintf(stderr, "Scale sound by %f\n", scale);

	/* 
         * 2nd run: scale audio-data 
	 */
	setbuffer( stdout, buf, BUFSIZE );
	if ((f = fopen( argv[1], "r" )) == NULL) {
		perror( argv[1] );
		exit( 3 );
	}

	/* Read and write audio header */
	for (i = hdr_size, c = 0; (c != EOF) && (i > 0); i-- ) {
		c = getc( f );
		putchar( c );
	}

	while ( (c = getc( f )) != EOF )
	{
		lc = st_ulaw_to_linear( c ) * scale;
		LINCLIP( lc );
		putchar( st_linear_to_ulaw( lc ) );
	}

	fclose(f);

	exit( 0 );
}
