
/*
   Internal Configuration File for the Sound Library

   Copyright 1993 by Kurt Siegl <siegl@risc.uni-linz.ac.at>
   Permission to use, modify, copy and distribute this software without
   fee is hereby granted as long as this notice is left here.
*/

#ifndef __SNDCONFIG_H
#define __SNDCONFIG_H

#include <sys/time.h>

#define DEFAULT_DSP_SPEED 8000
#define DEFAULT_SAMPLE_SIZE 8
#define STEREO 0

#if 1
#define AUDIO "/dev/audio"
#else
#define AUDIO "/dev/dsp"
#endif


/* Reload Sound 1 second before End */
#define PLAY_TIME 1000000
/* Check Intervall 0.5 sec */
#define CHECK_SEC 0
#define CHECK_USEC 500000

#define BgPlayer "bgsndplay"

struct shm_sound
  {
    char name[PATH_MAX];
    struct timeval tag;
  };


#endif /* __SNDCONFIG_H */
