/*
   Background Sound Library

   Copyright 1993 by Kurt Siegl <siegl@risc.uni-linz.ac.at>
   Permission to use, modify, copy and distribute this software without
   fee is hereby granted as long as this notice is left here.
*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <sys/time.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#include "sndconfig.h"

static int snd_pid, SoundRet, shmid;

static struct shm_sound *shared_data;

static void 
RetOk ()
{
  SoundRet = 0;
}

static void 
RetErr ()
{
  SoundRet = -1;
}

extern void 
ExitSound ()
{
  kill (snd_pid, SIGINT);
  shmctl (shmid, IPC_RMID, 0);
}

extern int 
InitSound ()
{

  char *argv[5], shmids[10], mypid[10];
  int argc = 0;
  int pid, shmKey = 0;
  struct shmid_ds smbuf;

  /*  if ((shmid=shmget(shmKey, sizeof(struct shm_sound),0))>=0)
	{
	  fprintf(stderr,"Killing Sound Shared Memory\n");
	  shmctl(shmid, IPC_RMID, 0);
	}
 */

  if ((shmid = shmget (shmKey, sizeof (struct shm_sound), (IPC_CREAT | 0777))) < 0)
    {
      perror ("Can't open Sound Shared Memory\n");
      return (-1);
    }

  shmctl (shmid, IPC_STAT, &smbuf);
  smbuf.shm_perm.uid = getuid ();
  smbuf.shm_perm.mode = 0777;
  shmctl (shmid, IPC_SET, &smbuf);

  if ((shared_data = (struct shm_sound *) shmat (shmid, 0, 0)) == (void *) -1)
    {
      perror ("shm attach failed");
      return (-1);
    }

  SoundRet = -1;
  signal (SIGUSR1, RetOk);
  signal (SIGUSR2, RetErr);
  sprintf (shmids, "%i", shmid);
  sprintf (mypid, "%i", getpid ());

  if ((pid = fork ()) == 0)
    {

      /*  setsid();  Make it independend of the main program */

      argv[argc++] = "bgplay";
      argv[argc++] = (char *) shmids;
      argv[argc++] = (char *) mypid;
      argv[argc] = NULL;

      signal (SIGINT, SIG_DFL);
      execvp (BgPlayer, argv);
      perror (BgPlayer);
      fflush (stderr);
      _exit (-1);
    }

  if (pid == -1)
    {
      perror ("forking");
      return (-1);
    }

  snd_pid = pid;
  pause ();
  return (SoundRet);

}

extern void 
StopSound ()
{
  kill (snd_pid, SIGUSR1);
}

extern int 
StartSound (name)
     char *name;
{
  strcpy (shared_data->name, name);
  gettimeofday (&(shared_data->tag), NULL);
  kill (snd_pid, SIGUSR2);
  return (0);
}
