/*	Copyright Alex Hornby 1994/1995. All rights reserved.
 	See file README for details
*/

#include "soul.h"

Soul :: Soul(int l, int e, int v) 
{
	score=0;
	lives=l;
	maxenergy=energy=e;
	value=v;
}

Soul :: Soul( const Soul& s) 
{
	copy(s);
}

void
Soul :: copy(const Soul &s)
{
	lives=s.lives;
	energy=s.energy;
	maxenergy=s.energy;
	score=s.score;
	value=s.value;
}

Soul& 
Soul :: operator=(const Soul& s)
{
	copy(s);
	return *this;
}

void
Soul :: subEnergy(int e)
{
	energy-=e;
	if(energy<=0)
	{
		energy=maxenergy;	
		lives--;
	}
}

void
Soul :: addEnergy(int e)
{
	energy+=e;
	if(energy>maxenergy)
		energy=maxenergy;
}
