#include "btypes.h"
#include "palette.h"
#include <assert.h>
#include <stdlib.h>

Palette::Palette()
{
	for(int i=0; i<256; i++)
	{
		red[i]=green[i]=blue[i]=0;
		allocated[i]=false;
	}
}

void
Palette::getData(int c, int &r, int &g, int &b)
{
	assert(c>=0 && c<256);
	r=red[c]; g=green[c]; b=blue[c];
}

int
Palette::request(int r, int g, int b)
{
	bool found=false;
	int retval=0;

	assert(r>=0 && r<256 && b>=0 && b<256 && g>=0 && g<256);

	// Search for a match
	for(int i=0;i<256 && !found ;i++)
	{
		if(allocated[i])
		{
			if(r==red[i] && g==green[i] && b==blue[i])
			{
				found=true;
				retval=i;
			}
		}
	}

	// If no exact match then try to allocate new color
	if(!found)
	{
		for(int j=0;j<256 && !found ;j++)
		{
			if(!allocated[j])
			{
				found=true;
				red[j]=r;
				green[j]=g;
				blue[j]=b;
				allocated[j]=true;
				retval=j;
			}
		}
	}

	// If still not found then find nearest match on minimax principle
	if( ! found)
	{
		int nearest=0, maxdist=1000, rd,gd,bd;
		for(int k=0; k<256; k++)
		{
			rd=abs(red[k]-r);
			gd=abs(green[k]-g);
			bd=abs(green[k]-b);
			if(rd>gd && rd>bd && rd<maxdist)
				nearest=k;
			else if(bd>rd && bd>gd && bd<maxdist)
				nearest=k;
			else if(gd>rd && gd>bd && gd<maxdist)
				nearest=k;
		}
		retval=nearest;
	}
	return retval;
}

bool
Palette::getAlloc(int i)
{
	return allocated[i];
}

void
Palette::allocate(int i, int r, int g, int b)
{
	red[i]=r;green[i]=g;blue[i]=b;
	allocated[i]=true;
}

void
Palette::scan(byte *data, int len)
{
	for(int i=0;i<len ;i++)
	{
		allocated[*data]=true;
		data++;
	}
}

void
Palette::remap(byte *data, int len, Palette &inpal)
{
	int r,g,b;
	int map[256];
	for(int i=0;i<256;i++)
	{
		if(inpal.allocated[i])
		{
			inpal.getData(i,r,g,b);
			map[i]=request(r,g,b);
		}
	}
	for(int j=0;j<len;j++)
	{
		*data=map[*data];
		data++;
	}
}
