/* abstract base for game control */

#ifndef CONTROL_H
#define CONTROL_H

#include "btypes.h"
#include "action.h"

class 
Control
{
private:
	void copy(const Control &c);
protected:
	bool last[FIRE4+1];
	bool raw;
	bool okay;
public:
	Control();
	Control(const Control& c);
	Control& operator=(const Control& c);
	virtual ~Control();

	virtual void fetch(void)=0;
	virtual void calibrate(void)=0;
	bool getRaw(void);
	bool test(action a);
	bool getOkay(void);
};

#endif
