/*	Copyright Alex Hornby 1994/1995. All rights reserved.
 	See file README for details
*/

#include "btypes.h"
#include "screendefs.h"

void
cls( void *video, byte col)
{
	for(int i=0; i<SCREENWIDTH*SCREENHEIGHT; i++)
	{
		*(((byte*)video)++)=col;
	}
}

void 
cutblock( void* source, void* dest, unsigned int width, unsigned int height)
{
	uint32 widthl=width/4;
	uint32 adj=(SCREENWIDTH-width)/4;
	
	for(int y=0; y<height; y++)
	{
		for(int x=0; x<widthl ;x++)
			*(((uint32*)dest)++)=*(((uint32*)source)++);
		(uint32*)source+=adj;
	}
}

void 
cutblocknew( void* source, void* dest, unsigned int swidth, unsigned int width, unsigned int height)
{
	uint32 widthl=width/4;
	uint32 adj=(swidth-width)/4;
	
	for(int y=0; y<height; y++)
	{
		for(int x=0; x<widthl ;x++)
			*(((uint32*)dest)++)=*(((uint32*)source)++);
		(uint32*)source+=adj;
	}
}

void 
pasteblock( void* source, void* dest, unsigned int width, unsigned int height)
{
	uint32 widthl=width/4;
	uint32 adj=(SCREENWIDTH-width)/4;
	
	for(int y=0; y<height; y++)
	{
		for(int x=0; x<widthl ;x++)
			*(((uint32*)dest)++)=*(((uint32*)source)++);
		(uint32*)dest+=adj;
	}
}

void 
andpasteblock( void* source, void* dest, unsigned int width, unsigned int height)
{
	uint32 widthl=width/4;
	uint32 adj=(SCREENWIDTH-width)/4;
	
	for(int y=0; y<height; y++)
	{
		for(int x=0; x<widthl ;x++)
			*(((uint32*)dest)++)&=*(((uint32*)source)++);
		(uint32*)dest+=adj;
	}
}

void 
xorpasteblock( void* source, void* dest, unsigned int width, unsigned int height)
{
	uint32 widthl=width/4;
	uint32 adj=(SCREENWIDTH-width)/4;

	for(int y=0; y<height; y++)
	{
		for(int x=0; x<widthl ;x++)
			*(((uint32*)dest)++)^=*(((uint32*)source)++);
		(uint32*)dest+=adj;
	}
}

void 
orpasteblock( void* source, void* dest, unsigned int width, unsigned int height)
{
	uint32 widthl=width/4;
	uint32 adj=(SCREENWIDTH-width)/4;

	for(int y=0; y<height; y++)
	{
		for(int x=0; x<widthl ;x++)
			*(((uint32*)dest)++)|=*(((uint32*)source)++);
		(uint32*)dest+=adj;
	}
}

void 
transpasteblock( void* source, void *mask, void* dest, unsigned int width, unsigned int height)
{
	uint32 widthl=width/4;
	uint32 adj=(SCREENWIDTH-width)/4;

	for(int y=0; y<height; y++)
	{
		for(int x=0; x<widthl ;x++)
		{
			*(((uint32*)dest))&=*(((uint32*)mask)++);
			*(((uint32*)dest)++)^=*(((uint32*)source)++);
		}
		(uint32*)dest+=adj;
	}
}
