/*	
	Defines the animation property as an abstract class, 
	i.e. they can be declared though!	
*/

#ifndef ANIMATION_H
#define ANIMATION_H

#include <SLList.h>
#include "btypes.h"
#include <iostream.h>

const int MAXSPRITE=64;
const int MAXFRAME=256;
const int LOOPANIM=1024;
const int VANISHANIM=1025;

struct slotElt{
	byte* block;
	byte* mask;
	uint32 width, height, ByteLength;
};

struct animElt{
public:
	int slot;
	int duration;
};

typedef SLList<struct animElt> animList; 

struct animElt animElt(int s, int d); 
animList operator+(animList l,struct animElt a);
animList operator+(struct animElt a, struct animElt b);

class
Animation
{
private:
        virtual void setVisible( bool v){cerr << "SHOULD NEVER BE CALLED\n";}
	Pix curframe;
	bool animflag;
protected:
	static slotElt sprbank[MAXFRAME]; 
	animList anim;
	int curslot, framecounter;
	void doAnim(void);
	void setFrame(Pix f){curframe=f;}
public:
	Animation();
	Animation(const Animation& a);
	Animation& operator=(const Animation& a);

	void loadFilm( animList a);
	bool getAnim(void) const {return animflag;}
	int getSlot(void) const {return curslot;}

	void setAnim(bool a);
	virtual void setSlot(int slot);
};

#endif
