/*	Copyright Alex Hornby 1994/1995. All rights reserved.
 	See file README for details
*/

/*	Make use of the svgalib raw keyboard mode. Somewhat risky as it can
	freeze the console!
*/

#include <iostream.h>
#include <vga.h>
#include <vgakeyboard.h>
#include "RawKey.h"

RawKey::RawKey() : Control()
{
	//calibrate();
	int status=keyboard_init();
	if(status!=0) 
	{
		cerr << "keyboard_init failed" << endl;
		raw=false;
		okay=false;
	}
	else
	{
		raw=true;
		okay=true;
	}
	left=SCANCODE_CURSORBLOCKLEFT; right=SCANCODE_CURSORBLOCKRIGHT;
	up=SCANCODE_CURSORBLOCKUP; down=SCANCODE_CURSORBLOCKDOWN;
	fire1=SCANCODE_LEFTCONTROL; quit=SCANCODE_ESCAPE; pause=25;
	fire2=SCANCODE_LEFTALT; fire3=SCANCODE_SPACE; fire4=42;
}

RawKey::~RawKey()
{
	if(raw==true)
		keyboard_close();
}

int
RawKey::getkey(void)
{
	int k=-1,j=25;
	while(k==-1)
		k=vga_getkey();
	while(j!=-1)
		j=vga_getkey();
	return k;
}

void
RawKey::calibrate(void)
{
	cout << "Press key for LEFT\n";
	left=getkey();
	cout << "Press key for RIGHT\n";
	right=getkey();
	cout << "Press key for UP\n";
	up=getkey();
	cout << "Press key for DOWN\n";
	down=getkey();
	cout << "Press key for FIRE1\n";
	fire1=getkey();
	cout << "Press key for FIRE2\n";
	fire2=getkey();
}

void
RawKey::fetch(void)
{
	keyboard_update();
	for(int i=0;i<=FIRE4;i++)
		last[i]=false;
	if(keyboard_keypressed(right))
		last[RIGHT]=true;
	else if(keyboard_keypressed(left))
		last[LEFT]=true;
	if(keyboard_keypressed(down))
		last[DOWN]=true;
	else if(keyboard_keypressed(up))
		last[UP]=true;
	if(keyboard_keypressed(fire1)) 
		last[FIRE1]=true;
	if(keyboard_keypressed(fire2)) 
		last[FIRE2]=true;
	if(keyboard_keypressed(fire3)) 
		last[FIRE3]=true;
	if(keyboard_keypressed(fire4)) 
		last[FIRE4]=true;
	if(keyboard_keypressed(quit)) 
		last[QUIT]=true;
	if(keyboard_keypressed(pause)) 
		last[PAUSE]=true;
	last[STRAIGHT] = !(last[LEFT] || last[RIGHT] || last[UP] || last[DOWN]);	
}

