/*
**  wt -- a 3d game engine
**
**  Copyright (C) 1994 by Chris Laurel
**  email:  claurel@mr.net
**  snail mail:  Chris Laurel, 5700 W Lake St #208,  St. Louis Park, MN  55416
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#define PIXEL_GUARD_VAL ((Pixel) ~0)


inline void draw_wall_slice(Pixel *start, Pixel *end, Pixel *tex_base,
			    fixed tex_y, fixed tex_dy, int fb_width, 
			    int tex_height, int npix);
inline void draw_floor_slice(Pixel *start, Pixel *tex,
			     fixed x, fixed y, fixed dx, fixed dy,
			     int tex_width);



inline void draw_wall_slice(Pixel *start, Pixel *end, Pixel *tex_base,
			    fixed tex_y, fixed tex_dy, int fb_width, 
			    int tex_height, int npix)
{
     /* npix is not used in this version of draw_wall_slice, but it is
     **   used in others for loop unrolling.
     */

     if (tex_height == 64) {

	  tex_y <<= 10;
	  tex_dy <<= 10;

	  while (start >= end) {
	       *start = tex_base[tex_y >> 26];
	       tex_y += tex_dy;
	       start -= fb_width;
	  }

     } else {

	  tex_y <<= 9;
	  tex_dy <<= 9;

	  while (start >= end) {
	       *start = tex_base[tex_y >> 25];
	       tex_y += tex_dy;
	       start -= fb_width;
	  }

     }
}


inline void draw_floor_slice(Pixel *start, Pixel *tex,
			     fixed x, fixed y, fixed dx, fixed dy,
			     int tex_width)
{
     register Pixel temp;


     temp = *start;
     if (temp != PIXEL_GUARD_VAL)
	  return;

     if (tex_width == 64) {
	  /* width of 64 == 2^6 */
	  y <<= 6;
	  dy <<= 6;

	  do {

	       x &= 0x3fffff;
	       /* No need to mask y--it rolls automatically *if* ints
               **   are 32 bits.
	       */

	       temp = tex[FIXED_TO_INT((y & 0xfc00000) | x)];
	       *start++ = temp;
	       x += dx;
	       temp = *start;
	       y += dy;

	  } while (temp == PIXEL_GUARD_VAL);

     } else {

	  /* tex_width == 128 == 2^7*/
	  y <<= 7;
	  dy <<= 7;

	  do {

	       x &= 0x7fffff;

	       temp = tex[FIXED_TO_INT((y & 0x3f800000) | x)];
	       *start++ = temp;
	       x += dx;
	       temp = *start;
	       y += dy;

	  } while (temp == PIXEL_GUARD_VAL);

     }
}
