#define __RAWKS_MAIN__
#define DBG 0

#include <signal.h>
#include <sys/time.h>
#include <stdio.h>
#include "gl.h"
#include <getopt.h>

#include "defines.h"
#include "struct.h"
#include "protos.h"
#include "globals.h"
#include "constants.h"

static void usage(char *optstr);
static void default_options(void);

Matrix Identity = {1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1};

void main(int argc,char **argv)
{
  char *wd = "./.data/rawks";
  extern char *optarg;
  extern int optind;
  int c;
  char *optstr = "bdfgqs:";
  char *obsoleteoptions = "l";

  signal(SIGCLD,SIG_IGN);
  default_options();

#if defined(NO_SOUND)
  fprintf(stderr,"Warning!  This code not compiled with audio library!\n"
		 "No sound effects available.\n\n");
#endif

  DEBUG("initvars()");	initvars();
  DEBUG("chdir()");	chdir(amh_dirname(argv[0]));

  while((c=getopt(argc,argv,optstr)) != -1) {
    switch(c) {
      case 'g':
	Opts.nodbuff = 1;
	break;
      case 'd': /* Draw a rock */
	Opts.drock = 1;
	Opts.nosound = 1;
	break;
      case 'f':
	Opts.fullscreen = 1;
	break;
      case 'b':
	Opts.noborder = 1;
	break;
      case 'l':
	Opts.logo = 1;
	break;
      case 'q':
	Opts.nosound = 1;
	break;
      case 'n':
	strncpy(Opts.username,optarg,MAX_SCORENAME-1);
	break;
      case 's': /* Specific window size?  Cool */
	Opts.fullscreen = 0;
        if(sscanf(optarg,"%ld,%ld,%ld,%ld",
                  &Opts.xoff,&Opts.yoff,&Opts.xsize,&Opts.ysize)!=4)
        {
          if(sscanf(optarg,"%ld,%ld",&Opts.xsize,&Opts.ysize)!=2)
            if(sscanf(optarg,"%ld",&Opts.xsize)==1)
              Opts.ysize = Opts.xsize;
#ifndef __LINUX__
	  Opts.xoff= ((getgdesc(GD_XPMAX) - Opts.xsize)>>1);
	  Opts.yoff= ((getgdesc(GD_YPMAX) - Opts.ysize)>>1);
#endif
        }
        break;
      case '?':
	usage(optstr);
	exit(-1);
	break;
    }
  }

  DEBUG("initwindow()"); initwindow();
/*   vgets("Testing...","Is this going to work again?",10,0xFFFF00); */
  DEBUG("initsound()"); init_sound();
  DEBUG("loadmissions()"); loadmissions();
  DEBUG("getmission()"); if(!getmission()) closeall();
  if(!Opts.drock) {
    DEBUG("loadgeometry()"); loadgeometry();
  }
  DEBUG("play()");       play();
  DEBUG("closeall()");   closeall();
}

static void default_options(void)
{
  cuserid(Opts.username);
  Opts.xsize = 640; Opts.xoff = 100;
  Opts.ysize = 480; Opts.yoff = 100;
}

static void usage(char *optstr)
{
  fprintf(stderr,"\n Option string: %s\n\n",optstr);
  while(optstr && *optstr) {
    switch(*optstr) {
      case ':': break;
      case 'g':
	fprintf(stderr,"-%c: Go to sinGle buffering by default\n",*optstr);
	break;
      case 'd':
	fprintf(stderr,"-%c: Delay loading ships and sound (preview rocks fast)\n",*optstr);
	break;
      case 'f':
	fprintf(stderr,"-%c: Fullscreen mode (implies noborder)\n",*optstr);
	break;
      case 'b':
	fprintf(stderr,"-%c: No border\n",*optstr);
	break;
      case 'l': 
	fprintf(stderr,"-%c: View logo\n",*optstr);
	break;
      case 'q':
	fprintf(stderr,"-%c: Quiet - do not load sound at beginning\n",*optstr);
	break;
      case 'n':
	fprintf(stderr,"-%c <name>: Override username\n",*optstr);
	break;
      case 's':
        fprintf(stderr,"-%c [xoff,yoff,][xsize,]ysize\n",*optstr);
        break;
    }
    optstr++;
  }
  fprintf(stderr,"\n\n");
}
